package com.oracle.adcs;

import java.util.ListResourceBundle;

public class AdcsResourceBundle extends ListResourceBundle
{
  @Override
  public Object[][] getContents()
  {
    return _CONTENTS;
  }

  static private final Object[][] _CONTENTS =
    {
      { "AFLogoIconShortDesc", "Demo:Logo" },
      { "AFRequiredIconShortDesc", "Demo:Required" },
      { "AFIndexedIconShortDesc", "Demo:Indexed" },
      { "AFChangedIconShortDesc", "Demo:Changed" },
      { "AFErrorIconShortDesc", "Demo:Error" },
      { "AFWarningIconShortDesc", "Demo:Warning" },
      { "AFInfoIconShortDesc", "Demo:Info" },
      { "AFUnsupportedBrowser", "Demo:You are using an unsupported browser. The supported browsers are IE7 and higher and Firefox 2.0.0.2 and higher." },

/* Miscellaneous.  TODO: should these be in a different ResourceBundle?!? */ 
      { "MSGPPRViewExpired", "Demo:Because of inactivity, your session has timed out and is no longer active.  Click OK to reload the page." },
      { "MSGNonPPRViewExpired", "Demo:Because of inactivity, your session has timed out and is no longer active.  The page will automatically be reloaded in 10 seconds;  if not, {0}click here{1}." },

/* Key modifiers and keys used in assembling the accelerator key strokes for the UI, e.g. menu items. */ 
      { "AFKeyModifierMeta", "Demo:Meta" },
      { "AFKeyModifierControl", "Demo:Ctrl" },
      { "AFKeyModifierAlt", "Demo:Alt" },
      { "AFKeyModifierShift", "Demo:Shift" },
      { "AFKeyUp", "Demo:Up" },
      { "AFKeyDown", "Demo:Down" },
      { "AFKeyLeft", "Demo:Left" },
      { "AFKeyRight", "Demo:Right" },
      { "AFKeyEscape", "Demo:Esc" },
      { "AFKeyPageUp", "Demo:PgUp" },
      { "AFKeyPageDown", "Demo:PgDwn" },
      { "AFKeyEnter", "Demo:Enter" },
      { "AFKeyHome", "Demo:Home" },
      { "AFKeyEnd", "Demo:End" },
      { "AFKeyClear", "Demo:Clear" },
      { "AFKeyTab", "Demo:Tab" },
      { "AFKeyForwardDelete", "Demo:Del" },
      { "AFKeyBackwardDelete", "Demo:Backspace" },
      { "AFKeySpace", "Demo:Space" },
      
/*  Active Data  */ 
      { "AFActiveDataConfirmRequest", "Demo:There are some active data changes on your page. Here is the list: {0}Do you want to reload the page?" },
      { "AFActiveDataNoChange", "Demo:There is no active data change on your page" },
      { "AFActiveDataHotKeyInfo", "Demo:This page contains the following active components: {0}Please press the following hot key to query active data changes: {1} " },
      { "AFActiveDataEventTime", "Demo:{0} updated {1} hours {2} minutes {3} seconds ago " },
      { "AFActiveDataNoActiveComponent", "Demo:There is no active component on your page" },
    
/* breadCrumbs */ 
      { "af_breadCrumbs.TIP_SHOW_MORE_LINKS", "Demo:Show More Links..." },
/* chooseColor */ 
      { "af_chooseColor.LABEL_LAST_USED_COLOR", "Demo:Last Used Color" },
      { "af_chooseColor.LABEL_DEFAULT_COLOR", "Demo:Default Color" },
      { "af_chooseColor.LABEL_CUSTOM_COLOR", "Demo:Custom Color..." },
      { "af_chooseColor.LABEL_HEX", "Demo:Hex" },
      { "af_chooseColor.LABEL_RED", "Demo:Red" },
      { "af_chooseColor.LABEL_GREEN", "Demo:Green" },
      { "af_chooseColor.LABEL_BLUE", "Demo:Blue" },
      { "af_chooseColor.TIP_NO_COLOR", "Demo:No Color" },
      { "af_chooseColor.TIP_NEW_COLOR", "Demo:New Color" },
      { "af_chooseColor.TIP_CURRENT_COLOR", "Demo:Current Color" },
      { "af_chooseColor.TIP_TRAN_NO_COLOR", "Demo:Transparent" },
      { "af_chooseColor.MSG_HEX_INVALID", "Demo:Color Value {0} is not valid. Please enter hex color value in 'RRGGBB' format. Example: 0F9A00" },
      { "af_chooseColor.MSG_RGB_INVALID", "Demo:Color Value {0} is not valid. Please enter a number value between 0 and 255 inclusive." },
      { "af_chooseColor.TITLE_CUSTOM_DLG", "Demo:Select Custom Color" },
/* Below are the colors defined in 49/64/121-color plaettes */ 
/* The color name key consists of the prefix, af_chooseColor.COLORNAME_, part and then hex RGB value.  The key names should be unique.  */ 
/* In case the value of color name is not translated, it should be either set as an empty string or remove the key. */ 
/* Colors in 1st row of 121-color */ 
      { "af_chooseColor.COLORNAME_F5F5F5", "Demo:White Smoke" },
      { "af_chooseColor.COLORNAME_87CEEB", "Demo:Sky Blue" },
      { "af_chooseColor.COLORNAME_E0FFFF", "Demo:Light Cyan" },
      { "af_chooseColor.COLORNAME_90EE90", "Demo:Light Green" },
      { "af_chooseColor.COLORNAME_ADFF2F", "Demo:Green Yellow" },
      { "af_chooseColor.COLORNAME_FFF8DC", "Demo:Cornsilk" },
      { "af_chooseColor.COLORNAME_FAF0E6", "Demo:Linen" },
      { "af_chooseColor.COLORNAME_FFFF00", "Demo:Yellow" },
      { "af_chooseColor.COLORNAME_FFE4E1", "Demo:Misty Rose" },
      { "af_chooseColor.COLORNAME_D8BFD8", "Demo:Thistle" },
/* Colors in 2nd row of 121-color */ 
      { "af_chooseColor.COLORNAME_FFFFFF", "Demo:White" },
      { "af_chooseColor.COLORNAME_DCDCDC", "Demo:Gainsboro" },
      { "af_chooseColor.COLORNAME_87CEFA", "Demo:Light Sky Blue" },
      { "af_chooseColor.COLORNAME_AFEEEE", "Demo:Pale Turquoise" },
      { "af_chooseColor.COLORNAME_00FA9A", "Demo:Medium Spring Green" },
      { "af_chooseColor.COLORNAME_7FFF00", "Demo:Chartreuse" },
      { "af_chooseColor.COLORNAME_FFEBCD", "Demo:Blanched Almond" },
      { "af_chooseColor.COLORNAME_FFDEAD", "Demo:Navajo White" },
      { "af_chooseColor.COLORNAME_FFA500", "Demo:Orange" },
      { "af_chooseColor.COLORNAME_FFC0CB", "Demo:Pink" },
      { "af_chooseColor.COLORNAME_B0C4DE", "Demo:Light Steel Blue" },
/* Colors in 3rd row of 121-color */ 
      { "af_chooseColor.COLORNAME_F0FFF0", "Demo:Honeydew" },
      { "af_chooseColor.COLORNAME_D3D3D3", "Demo:Light Gray" },
      { "af_chooseColor.COLORNAME_00BFFF", "Demo:Deep Sky Blue" },
      { "af_chooseColor.COLORNAME_B0E0E6", "Demo:Powder Blue" },
      { "af_chooseColor.COLORNAME_66CDAA", "Demo:Medium Aquamarine" },
      { "af_chooseColor.COLORNAME_7CFC00", "Demo:Lawn Green" },
      { "af_chooseColor.COLORNAME_FFE4C4", "Demo:Bisque" },
      { "af_chooseColor.COLORNAME_FFA07A", "Demo:Light Salmon" },
      { "af_chooseColor.COLORNAME_FF8C00", "Demo:Dark Orange" },
      { "af_chooseColor.COLORNAME_FFB6C1", "Demo:Light Pink" },
      { "af_chooseColor.COLORNAME_6495ED", "Demo:Cornflower Blue" },
/* Colors in 4th row of 121-color */ 
      { "af_chooseColor.COLORNAME_F5FFFA", "Demo:Mint Cream" },
      { "af_chooseColor.COLORNAME_C0C0C0", "Demo:Silver" },
      { "af_chooseColor.COLORNAME_1E90FF", "Demo:Dodger Blue" },
      { "af_chooseColor.COLORNAME_00FFFF", "Demo:Cyan" },
      { "af_chooseColor.COLORNAME_8FBC8F", "Demo:Dark Sea Green" },
      { "af_chooseColor.COLORNAME_00FF00", "Demo:Lime" },
      { "af_chooseColor.COLORNAME_F5DEB3", "Demo:Wheat" },
      { "af_chooseColor.COLORNAME_E9967A", "Demo:Dark Salmon" },
      { "af_chooseColor.COLORNAME_FF4500", "Demo:Orange Red" },
      { "af_chooseColor.COLORNAME_DDA0DD", "Demo:Plum" },
      { "af_chooseColor.COLORNAME_7B68EE", "Demo:Medium Slate Blue" },
/* Colors in 5th row of 121-color */ 
      { "af_chooseColor.COLORNAME_F0FFFF", "Demo:Azure" },
      { "af_chooseColor.COLORNAME_A9A9A9", "Demo:Dark Gray" },
      { "af_chooseColor.COLORNAME_4169E1", "Demo:Royal Blue" },
      { "af_chooseColor.COLORNAME_7FFFD4", "Demo:Aquamarine" },
      { "af_chooseColor.COLORNAME_20B2AA", "Demo:Light Sea Green" },
      { "af_chooseColor.COLORNAME_9ACD32", "Demo:Yellow Green" },
      { "af_chooseColor.COLORNAME_DEB887", "Demo:Burly Wood" },
      { "af_chooseColor.COLORNAME_F08080", "Demo:Light Coral" },
      { "af_chooseColor.COLORNAME_D2691E", "Demo:Chocolate" },
      { "af_chooseColor.COLORNAME_EE82EE", "Demo:Violet" },
      { "af_chooseColor.COLORNAME_9370DB", "Demo:Medium Purple" },
/* Colors in 6th row of 121-color */ 
      { "af_chooseColor.COLORNAME_F0F8FF", "Demo:Alice Blue" },
      { "af_chooseColor.COLORNAME_778899", "Demo:Light Slate Gray" },
      { "af_chooseColor.COLORNAME_6A5ACD", "Demo:Slate Blue" },
      { "af_chooseColor.COLORNAME_40E0D0", "Demo:Turquoise" },
      { "af_chooseColor.COLORNAME_3CB371", "Demo:Medium Sea Green" },
      { "af_chooseColor.COLORNAME_32CD32", "Demo:Lime Green" },
      { "af_chooseColor.COLORNAME_D2B48C", "Demo:Tan" },
      { "af_chooseColor.COLORNAME_FA8072", "Demo:Salmon" },
      { "af_chooseColor.COLORNAME_A0522D", "Demo:Sienna" },
      { "af_chooseColor.COLORNAME_DA70D6", "Demo:Orchid" },
      { "af_chooseColor.COLORNAME_BA55D3", "Demo:Medium Orchid" },
/* Colors in 7th row of 121-color */ 
      { "af_chooseColor.COLORNAME_F8F8FF", "Demo:Ghost White" },
      { "af_chooseColor.COLORNAME_708090", "Demo:Slate Gray" },
      { "af_chooseColor.COLORNAME_0000FF", "Demo:Blue" },
      { "af_chooseColor.COLORNAME_48D1CC", "Demo:Medium Turquoise" },
      { "af_chooseColor.COLORNAME_2E8B57", "Demo:Sea Green" },
      { "af_chooseColor.COLORNAME_808000", "Demo:Olive" },
      { "af_chooseColor.COLORNAME_BC8F8F", "Demo:Rosy Brown" },
      { "af_chooseColor.COLORNAME_FF7F50", "Demo:Coral" },
      { "af_chooseColor.COLORNAME_8B4513", "Demo:Saddle Brown" },
      { "af_chooseColor.COLORNAME_FF69B4", "Demo:Hot Pink" },
      { "af_chooseColor.COLORNAME_9932CC", "Demo:Dark Orchid" },
/* Colors in 8th row of 121-color */ 
      { "af_chooseColor.COLORNAME_FFF5EE", "Demo:Seashell" },
      { "af_chooseColor.COLORNAME_808080", "Demo:Gray" },
      { "af_chooseColor.COLORNAME_0000CD", "Demo:Medium Blue" },
      { "af_chooseColor.COLORNAME_00CED1", "Demo:Dark Turquoise" },
      { "af_chooseColor.COLORNAME_228B22", "Demo:Forest Green" },
      { "af_chooseColor.COLORNAME_6B8E23", "Demo:Olive Drab" },
      { "af_chooseColor.COLORNAME_F4A460", "Demo:Sandy Brown" },
      { "af_chooseColor.COLORNAME_FF6347", "Demo:Tomato" },
      { "af_chooseColor.COLORNAME_B22222", "Demo:Fire Brick" },
      { "af_chooseColor.COLORNAME_DB7093", "Demo:Pale Violet Red" },
      { "af_chooseColor.COLORNAME_8A2BE2", "Demo:Blue Violet" },
/* Colors in 9th row of 121-color */ 
      { "af_chooseColor.COLORNAME_F5F5DC", "Demo:Beige" },
      { "af_chooseColor.COLORNAME_696969", "Demo:Dim Gray" },
      { "af_chooseColor.COLORNAME_4B0082", "Demo:Indigo" },
      { "af_chooseColor.COLORNAME_4682B4", "Demo:Steel Blue" },
      { "af_chooseColor.COLORNAME_008B8B", "Demo:Dark Cyan" },
      { "af_chooseColor.COLORNAME_008000", "Demo:Green" },
      { "af_chooseColor.COLORNAME_DAA520", "Demo:Golden Rod" },
      { "af_chooseColor.COLORNAME_CD5C5C", "Demo:Indian Red" },
      { "af_chooseColor.COLORNAME_A52A2A", "Demo:Brown" },
      { "af_chooseColor.COLORNAME_FF00FF", "Demo:Magenta" },
      { "af_chooseColor.COLORNAME_9400D3", "Demo:Dark Violet" },
/* Colors in 10th row of 121-color */ 
      { "af_chooseColor.COLORNAME_FDF5E6", "Demo:Old Lace" },
      { "af_chooseColor.COLORNAME_2F4F4F", "Demo:Dark Slate Gray" },
      { "af_chooseColor.COLORNAME_00008B", "Demo:Dark Blue" },
      { "af_chooseColor.COLORNAME_483D8B", "Demo:Dark Slate Blue" },
      { "af_chooseColor.COLORNAME_5F9EA0", "Demo:Cadet Blue" },
      { "af_chooseColor.COLORNAME_006400", "Demo:Dark Green" },
      { "af_chooseColor.COLORNAME_B8860B", "Demo:Dark Golden Rod" },
      { "af_chooseColor.COLORNAME_DC143C", "Demo:Crimson" },
      { "af_chooseColor.COLORNAME_8B0000", "Demo:Dark Red" },
      { "af_chooseColor.COLORNAME_FF1493", "Demo:Deep Pink" },
      { "af_chooseColor.COLORNAME_8B008B", "Demo:Dark Magenta" },
/* Colors in 11th row of 121-color */ 
      { "af_chooseColor.COLORNAME_FFFAF0", "Demo:Floral White" },
      { "af_chooseColor.COLORNAME_000000", "Demo:Black" },
      { "af_chooseColor.COLORNAME_000080", "Demo:Navy" },
      { "af_chooseColor.COLORNAME_191970", "Demo:Midnight Blue" },
      { "af_chooseColor.COLORNAME_008080", "Demo:Teal" },
      { "af_chooseColor.COLORNAME_556B2F", "Demo:Dark Olive Green" },
      { "af_chooseColor.COLORNAME_CD853F", "Demo:Peru" },
      { "af_chooseColor.COLORNAME_FF0000", "Demo:Red" },
      { "af_chooseColor.COLORNAME_800000", "Demo:Maroon" },
      { "af_chooseColor.COLORNAME_C71585", "Demo:Medium Violet Red" },
      { "af_chooseColor.COLORNAME_800080", "Demo:Purple" },
/* Colors in 49-color and/or 64-color */ 
      { "af_chooseColor.COLORNAME_FFDAB9", "Demo:Peach Puff" },
      { "af_chooseColor.COLORNAME_E6E6FA", "Demo:Lavender" },
      { "af_chooseColor.COLORNAME_ADD8E6", "Demo:Light Blue" },
      { "af_chooseColor.COLORNAME_00FF7F", "Demo:Spring Green" },
      { "af_chooseColor.COLORNAME_FAFAD2", "Demo:Light Golden Rod Yellow" },
      { "af_chooseColor.COLORNAME_EEE8AA", "Demo:Pale Golden Rod" },
      { "af_chooseColor.COLORNAME_FFE4B5", "Demo:Moccasin" },
      { "af_chooseColor.COLORNAME_FFD700", "Demo:Gold" },
      { "af_chooseColor.COLORNAME_D02090", "Demo:Violet Red" },
/* chooseDate */ 
      { "af_chooseDate.TIP_PREVIOUS_MONTH", "Demo:Previous Month" },
      { "af_chooseDate.TIP_NEXT_MONTH", "Demo:Next Month" },
      { "af_chooseDate.LABEL_SELECT_MONTH", "Demo:Select Month" },
      { "af_chooseDate.LABEL_SELECT_YEAR", "Demo:Select Year" },
      { "af_chooseDate.LABEL_SELECT_HOURS", "Demo:Select Hours" },
      { "af_chooseDate.LABEL_SELECT_MINUTES", "Demo:Select Minutes" },
      { "af_chooseDate.LABEL_SELECT_SECONDS", "Demo:Select Seconds" },
      { "af_chooseDate.LABEL_SELECT_TIMEZONE", "Demo:Select Time Zone" },
/* column */ 
      { "af_column.TIP_SORT_ASCENDING", "Demo:Sort Ascending" },
      { "af_column.TIP_SORT_DESCENDING", "Demo:Sort Descending" },
      { "af_column.LABEL_ROW_SELECT", "Demo:Select" },
      { "af_column.LABEL_DETAIL_STAMP", "Demo:Show Detail" },
      { "af_column.LABEL_COLUMN_SELECT", "Demo:Select Column" },
      { "af_column.LABEL_SELECT_ALL", "Demo:Select All" },
/* commandMenuItem */ 
      { "af_commandMenuItem.ROLE_TYPE_NORMAL", "Demo:Menu Item" },
      { "af_commandMenuItem.ROLE_TYPE_CHECKBOX", "Demo:Checkbox Menu Item" },
      { "af_commandMenuItem.ROLE_TYPE_RADIO", "Demo:Radio Button Menu Item" },
      { "af_commandMenuItem.STATE_CHECKBOX_SELECTED", "Demo:Checked" },
      { "af_commandMenuItem.STATE_RADIO_SELECTED", "Demo:Selected" },
      { "af_commandMenuItem.STATE_DISABLED", "Demo:Disabled" },
/* commandNavigationItem */ 
      { "af_commandNavigationItem.TIP_SELECTED", "Demo:Selected Item: {0}" },
      { "af_commandNavigationItem.TIP_DISABLED", "Demo:Disabled Item: {0}" },
/* commandToolbarButton */ 
      { "af_commandToolbarButton.TIP_SELECTOR", "Demo:{0} Selector" },
      { "af_commandToolbarButton.TIP_ADD_LINK", "Demo:Add Link" },
      { "af_commandToolbarButton.TIP_REMOVE_LINK", "Demo:Remove Link" },
      { "af_commandToolbarButton.TIP_CLEAR_STYLING", "Demo:Clear Styling" },
      { "af_commandToolbarButton.TIP_UNDO", "Demo:Undo" },
      { "af_commandToolbarButton.TIP_REDO", "Demo:Redo" },
      { "af_commandToolbarButton.TIP_BOLD", "Demo:Bold" },
      { "af_commandToolbarButton.TIP_ITALIC", "Demo:Italic" },
      { "af_commandToolbarButton.TIP_UNDERLINE", "Demo:Underline" },
      { "af_commandToolbarButton.TIP_SUBSCRIPT", "Demo:Subscript" },
      { "af_commandToolbarButton.TIP_SUPERSCRIPT", "Demo:Superscript" },
      { "af_commandToolbarButton.TIP_STRIKETHROUGH", "Demo:Strikethrough" },
      { "af_commandToolbarButton.TIP_JUSTIFY_LEFT", "Demo:Justify Left" },
      { "af_commandToolbarButton.TIP_JUSTIFY_CENTER", "Demo:Justify Center" },
      { "af_commandToolbarButton.TIP_JUSTIFY_RIGHT", "Demo:Justify Right" },
      { "af_commandToolbarButton.TIP_JUSTIFY_FULL", "Demo:Justify Full" },
      { "af_commandToolbarButton.TIP_LIST_UNORDERED", "Demo:Bulleted List" },
      { "af_commandToolbarButton.TIP_LIST_ORDERED", "Demo:Numbered List" },
      { "af_commandToolbarButton.TIP_OUTDENT", "Demo:Outdent" },
      { "af_commandToolbarButton.TIP_INDENT", "Demo:Indent" },
      { "af_commandToolbarButton.TIP_MODE_RICH_TEXT", "Demo:Rich Text Editing Mode" },
      { "af_commandToolbarButton.TIP_MODE_CODE", "Demo:Source Code Editing Mode" },
      { "af_commandToolbarButton.ROLE", "Demo:Toolbar Button" },
      { "af_commandToolbarButton.ROLE_CHECKBOX", "Demo:Checkbox Toolbar Button" },
      { "af_commandToolbarButton.ROLE_RADIO", "Demo:Radio Toolbar Button" },
      { "af_commandToolbarButton.STATE_POPUP", "Demo:Submenu" },
      { "af_commandToolbarButton.STATE_CHECKBOX_SELECTED", "Demo:Checked" },
      { "af_commandToolbarButton.STATE_RADIO_SELECTED", "Demo:Selected" },
      { "af_commandToolbarButton.STATE_DISABLED", "Demo:Disabled" },
/* dialog */ 
      { "af_dialog.LABEL_OK", "Demo:OK" },
      { "af_dialog.LABEL_CANCEL", "Demo:Cancel" },
      { "af_dialog.LABEL_YES", "Demo:Yes" },
      { "af_dialog.LABEL_NO", "Demo:No" },
/* document */ 
      { "af_document.LABEL_SPLASH_SCREEN",  "Loading: Oracle ADF Rocks!" },
      { "af_document.LABEL_SKIP_LINK_TEXT", "Skip to content" },      
      { "af_document.MSG_FAILED_CONNECTION","A connection to the server has failed." },
/* inputColor */ 
      { "af_inputColor.TIP_CLICK_TO_LAUNCH_POPUP_SELECTOR", "Demo:Click to launch inline popup color selector" },
/* inputComboboxListOfValues */ 
      { "af_inputComboboxListOfValues.LABEL_SEARCH", "Demo:Search..." },
      { "af_inputComboboxListOfValues.TIP_CREATE", "Demo:Create" },
/* inputDate */ 
      { "af_inputDate.TIP_TITLE_SELECT_DATE", "Demo:Select Date" },
      { "af_inputDate.TIP_TITLE_SELECT_DATE_AND_TIME", "Demo:Select Date and Time" },
      { "af_inputDate.TIP_CLICK_TO_LAUNCH_POPUP_SELECTOR", "Demo:Click to launch popup selector" },
/* inputFile */ 
      { "af_inputFile.LABEL_UPDATE_BUTTON", "Demo:Update..." },
      { "af_inputFile.LABEL_UPDATE_DIALOG_TITLE", "Demo:Update File" },
      { "af_inputFile.MSG_UPLOAD_ERROR", "Demo:Upload Error" },
      { "af_inputFile.MSG_UPLOAD_ERROR_DETAIL", "Demo:Please verify your upload data." },
/* inputListOfValues */ 
      { "af_inputListOfValues.TIP_SEARCH", "Demo:Search" },
      { "af_inputListOfValues.TIP_SEARCH_LABEL", "Demo:Search: {0}" },
      { "af_inputListOfValues.TIP_CREATE", "Demo:Create" },
/* inputNumberSlider */ 
      { "af_inputNumberSlider.TIP_INCREASE", "Demo:Increase" },
      { "af_inputNumberSlider.TIP_DECREASE", "Demo:Decrease" },
/* inputNumberSpinbox */ 
      { "af_inputNumberSpinbox.TIP_INCREMENT", "Demo:increment" },
      { "af_inputNumberSpinbox.TIP_DECREMENT", "Demo:decrement" },
      { "af_inputNumberSpinbox.TIP_INCREMENT_DISABLED", "Demo:increment disabled" },
      { "af_inputNumberSpinbox.TIP_DECREMENT_DISABLED", "Demo:decrement disabled" },
/* inputRangeSlider */ 
      { "af_inputRangeSlider.TIP_START_RANGE", "Demo:Start of Range" },
      { "af_inputRangeSlider.TIP_END_RANGE", "Demo:End of Range" },
/* media */ 
      { "af_media.TIP_DEFAULT_LINK_TEXT_AUDIO", "Demo:Play Audio" },
      { "af_media.TIP_DEFAULT_LINK_TEXT_VIDEO", "Demo:Play Video" },
      { "af_media.TIP_DEFAULT_LINK_TEXT_UNKOWN", "Demo:Play Media" },
/* menu */ 
      { "af_menu.ROLE", "Demo:Menu Item" },
      { "af_menu.STATE_SUBMENU", "Demo:Submenu" },
      { "af_menu.STATE_DISABLED", "Demo:Disabled" },
/* message */ 
      { "af_message.TIP_FATAL", "Demo:Critical Error" },
      { "af_message.TIP_ERROR", "Demo:Error" },
      { "af_message.TIP_WARNING", "Demo:Warning" },
      { "af_message.TIP_CONFIRMATION", "Demo:Confirmation" },
      { "af_message.TIP_INFO", "Demo:Information" },
      { "af_message.LABEL_COMPONENT_MESSAGES_INTRO", "Demo:Messages for this component are listed below." },
      { "af_message.TIP_PREVIOUS_MESSAGE", "Demo:Previous" },
      { "af_message.TIP_NEXT_MESSAGE", "Demo:Next" },
      { "af_message.LABEL_SHOW_ALL_MESSAGES", "Demo:All" },
      { "af_message.TIP_SHOW_ALL_MESSAGES", "Demo:All" },
/* {0} is the type and {1} is the message summary. Example would be 'Error: Not a number' 
         where {0} ='Error' and {1} = 'Not a number'. */ 
      { "af_message.LABEL_COMPACT_TYPE_SUMMARY", "Demo:{0}: {1}" },
/* messages */ 
      { "af_messages.TIP_FATAL", "Demo:Critical Error" },
      { "af_messages.TIP_ERROR", "Demo:Error" },
      { "af_messages.TIP_WARNING", "Demo:Warning" },
      { "af_messages.TIP_CONFIRMATION", "Demo:Confirmation" },
      { "af_messages.TIP_INFO", "Demo:Information" },
      { "af_messages.LABEL_COMBINED_MESSAGES_INTRO", "Demo:Messages for this page are listed below." },
      { "af_messages.LABEL_COMPONENT_LEVEL_MESSAGE", "Demo:Component" },
      { "af_messages.LABEL_SET_FOCUS_ON_COMPONENT", "Demo:Set focus on {0}" },
/* panelAccordion */  
      { "af_panelAccordion.TIP_DISCLOSE_BUTTON", "Demo:Show this panel" },
      { "af_panelAccordion.TIP_UNDISCLOSE_BUTTON", "Demo:Hide this panel" },
      { "af_panelAccordion.TIP_UNDISCLOSE_DISABLED_BUTTON", "Demo:This panel cannot be hidden" },
      { "af_panelAccordion.TIP_SHOW_PREVIOUS_BUTTON", "Demo:Show previous panels" },
      { "af_panelAccordion.TIP_SHOW_NEXT_BUTTON", "Demo:Show next panels" },
      { "af_panelAccordion.TIP_DISCLOSE_PRECISE_BUTTON", "Demo:Show accordion panel: {0}" },
      { "af_panelAccordion.TIP_UNDISCLOSE_PRECISE_BUTTON", "Demo:Hide accordion panel: {0}" },
      { "af_panelAccordion.TIP_UNDISCLOSE_DISABLED_PRECISE_BUTTON", "Demo:Accordion panel cannot be hidden: {0}" },
      { "af_panelAccordion.TIP_PANEL_DISCLOSED", "Demo:Shown accordion panel: {0}" },
      { "af_panelAccordion.TIP_PANEL_UNDISCLOSED", "Demo:Hidden accordion panel: {0}" },
/* panelCollection */ 
      { "af_panelCollection.LABEL_ADVANCED_SORT_DLG", "Demo:Advanced Sort" },
      { "af_panelCollection.LABEL_SORT_BY", "Demo:Sort By" },
      { "af_panelCollection.LABEL_THEN_BY", "Demo:Then By" },
      { "af_panelCollection.LABEL_ASCENDING", "Demo:Ascending" },
      { "af_panelCollection.LABEL_DESCENDING", "Demo:Descending" },
      { "af_panelCollection.LABEL_SHOW_COLUMNS_DLG", "Demo:Show More Columns" },
      { "af_panelCollection.LABEL_VISIBLE_COLUMNS", "Demo:Visible Columns" },
      { "af_panelCollection.LABEL_HIDDEN_COLUMNS", "Demo:Hidden Columns" },
      { "af_panelCollection.MSG_VISIBLE_COLUMN_REQUIRED", "Demo:At least 1 column must be in the Visible Columns list." },
      { "af_panelCollection.LABEL_REORDER_COLUMNS_DLG", "Demo:Reorder Columns" },
      { "af_panelCollection.LABEL_RESIZE_COLUMN_DLG", "Demo:Resize Column" },
      { "af_panelCollection.LABEL_COLUMN", "Demo:Column" },
      { "af_panelCollection.LABEL_COLUMN_MULTIPLE", "Demo:Multiple" },
      { "af_panelCollection.LABEL_WIDTH", "Demo:Width" },
      { "af_panelCollection.LABEL_PERCENT", "Demo:Percent" },
      { "af_panelCollection.LABEL_PIXEL", "Demo:Pixels" },
      { "af_panelCollection.LABEL_DETACH_TABLE_DLG", "Demo:Detached Table" },
      { "af_panelCollection.LABEL_DETACH_TREE_TABLE_DLG", "Demo:Detached treeTable" },
      { "af_panelCollection.LABEL_MENU_VIEW", "Demo:View" },
      { "af_panelCollection.LABEL_MENU_COLUMNS", "Demo:Columns" },
      { "af_panelCollection.LABEL_MENUITEM_COLUMNS_SHOWALL", "Demo:Show All" },
      { "af_panelCollection.LABEL_MENUITEM_COLUMNS_SHOWMORECOLUMNS", "Demo:Show More Columns..." },
      { "af_panelCollection.LABEL_MENUITEM_FREEZE", "Demo:Freeze" },
      { "af_panelCollection.TIP_BUTTON_FREEZE", "Demo:Freeze Column" },
      { "af_panelCollection.LABEL_MENUITEM_UNFREEZE", "Demo:Unfreeze" },
      { "af_panelCollection.TIP_BUTTON_DETACH", "Demo:Detach Table" },
      { "af_panelCollection.LABEL_MENUITEM_DETACH", "Demo:Detach" },
      { "af_panelCollection.LABEL_MENUITEM_REDUCE", "Demo:Attach" },
      { "af_panelCollection.LABEL_MENU_SORT", "Demo:Sort" },
      { "af_panelCollection.LABEL_MENUITEM_SORT_ASCENDING", "Demo:Ascending" },
      { "af_panelCollection.LABEL_MENUITEM_SORT_DESCENDING", "Demo:Descending" },
      { "af_panelCollection.LABEL_MENUITEM_SORT_ADVANCED", "Demo:Advanced..." },
      { "af_panelCollection.LABEL_MENUITEM_REORDER", "Demo:Reorder Columns..." },
      { "af_panelCollection.LABEL_MENUITEM_QBE", "Demo:Query By Example" },
      { "af_panelCollection.LABEL_MENU_FORMAT", "Demo:Format" },
      { "af_panelCollection.LABEL_MENUITEM_RESIZECOLUMNS", "Demo:Resize Columns..." },
      { "af_panelCollection.LABEL_MENUITEM_WRAP", "Demo:Wrap" },
      { "af_panelCollection.TIP_BUTTON_WRAP", "Demo:Wrap Text" },
      { "af_panelCollection.LABEL_STATUSBARITEM_ROWS_SELECTED", "Demo:Rows Selected:" },
      { "af_panelCollection.LABEL_STATUSBARITEM_ROWS_SELECTED_ALL", "Demo:All" },
      { "af_panelCollection.LABEL_STATUSBARITEM_COLUMNS_HIDDEN", "Demo:Columns Hidden:" },
      { "af_panelCollection.LABEL_STATUSBARITEM_COLUMNS_FROZEN", "Demo:Columns Frozen:" },
      { "af_panelCollection.LABEL_MENUITEM_EXPAND", "Demo:Expand" },
      { "af_panelCollection.LABEL_MENUITEM_COLLAPSE", "Demo:Collapse" },
      { "af_panelCollection.LABEL_MENUITEM_EXPAND_ALL_BELOW", "Demo:Expand All Below" },
      { "af_panelCollection.LABEL_MENUITEM_COLLAPSE_ALL_BELOW", "Demo:Collapse All Below" },
      { "af_panelCollection.LABEL_MENUITEM_EXPAND_ALL", "Demo:Expand All" },
      { "af_panelCollection.LABEL_MENUITEM_COLLAPSE_ALL", "Demo:Collapse All" },
      { "af_panelCollection.LABEL_MENUITEM_GO_UP", "Demo:Go Up" },
      { "af_panelCollection.LABEL_MENUITEM_SHOW_AS_TOP", "Demo:Show as Top" },
      { "af_panelCollection.LABEL_MENUITEM_GO_TO_TOP", "Demo:Go to Top" },
      { "af_panelCollection.LABEL_MENUITEM_SCROLL_TO_FIRST", "Demo:Scroll to First" },
      { "af_panelCollection.LABEL_MENUITEM_SCROLL_TO_LAST", "Demo:Scroll to Last" },
/* panelHeader */
      { "af_panelHeader.TIP_DYNAMIC_HELP", "Demo:Select to see help" },
      { "af_panelHeader.LABEL_HELP_DIALOG_TITLE", "Demo:Help" },
/* panelSplitter */ 
      { "af_panelSplitter.TIP_COLLAPSE", "Demo:Collapse Pane" },
      { "af_panelSplitter.TIP_RESTORE", "Demo:Restore Pane" },
/* panelWindow */ 
      { "af_panelWindow.TIP_CLOSE", "Demo:Close" },
/* popup */ 
      { "af_popup.TIP_START_OF_POPUP", "Demo:Start Of Popup" },
      { "af_popup.TIP_END_OF_POPUP", "Demo:End Of Popup" },
      { "af_popup.TIP_START_OF_MENU", "Demo:Start Of Menu" },
      { "af_popup.TIP_END_OF_MENU", "Demo:End Of Menu" },
/* progressIndicator */  
      { "af_progressIndicator.TIP_DETERMINATE", "Demo:{0}%" },
      { "af_progressIndicator.LABEL_DETERMINATE_ZERO_PERCENT", "Demo:0%" },
      { "af_progressIndicator.LABEL_DETERMINATE_HUNDRED_PERCENT", "Demo:100%" },
      { "af_progressIndicator.TIP_INDETERMINATE_RUNNING", "Demo:In Progress" },
      { "af_progressIndicator.TIP_INDETERMINATE_FINISHED", "Demo:Process Complete" },
      { "af_progressIndicator.TIP_SCREEN_READER_DETERMINATE", "Demo:Processing, {0}% complete" },
      { "af_progressIndicator.TIP_SCREEN_READER_INDETERMINATE_RUNNING", "Demo:Processing, unknown percent complete" },
      { "af_progressIndicator.TIP_SCREEN_READER_INDETERMINATE_FINISHED", "Demo:Processing complete" },
/* query */ 
      { "af_query.LABEL_HEADER_TEXT", "Demo:Search" },
      { "af_query.LABEL_REQUIRED_INFO_TEXT", "Demo:Required" },
      { "af_query.LABEL_INDEXED_INFO_TEXT", "Demo:At least one is required" },
      { "af_query.LABEL_FOOTER_ADD_FIELDS", "Demo:Add Fields" },  
      { "af_query.LABEL_CONJUNCTION", "Demo:Match" },
      { "af_query.LABEL_CONJUNCTION_AND", "Demo:All" },
      { "af_query.LABEL_CONJUNCTION_OR", "Demo:Any" },
      { "af_query.LABEL_MODE_BASIC", "Demo:Basic" },
      { "af_query.LABEL_MODE_ADVANCED", "Demo:Advanced" },
      { "af_query.LABEL_SAVE", "Demo:Save..." },
      { "af_query.LABEL_RESET", "Demo:Reset" },
      { "af_query.LABEL_SEARCH", "Demo:Search" },
      { "af_query.LABEL_DELETE", "Demo:Delete" },
      { "af_query.LABEL_DUPLICATE", "Demo:Duplicate" },
      { "af_query.LABEL_APPLY", "Demo:Apply" },
      { "af_query.LABEL_DUPLICATE_NAME_PREFIX", "Demo:copyOf_" },
      { "af_query.LABEL_SAVED_SEARCH", "Demo:Saved Search" },
      { "af_query.LABEL_SAVED_SEARCH_PERSONALIZE_ENTRY", "Demo:Personalize..." },
      { "af_query.LABEL_PERSONALIZE_SAVED_SEARCHES_DLG", "Demo:Personalize Saved Searches" },
      { "af_query.LABEL_CREATE_SAVED_SEARCH_DLG", "Demo:Create Saved Search" },
      { "af_query.LABEL_SAVED_SEARCH_NAME", "Demo:Name" },
      { "af_query.LABEL_UIHINT_SAVE_RESULTS_LAYOUT", "Demo:Save Results Layout" }, 
      { "af_query.LABEL_UIHINT_AUTO_EXECUTE", "Demo:Run Automatically" }, 
      { "af_query.LABEL_UIHINT_SHOW_IN_LIST", "Demo:Show in Search List" }, 
      { "af_query.LABEL_UIHINT_DEFAULT", "Demo:Set as Default" }, 
      { "af_query.MSG_SAVED_SEARCH_NAME_UNIQUE_CONSTRAINT", "Demo:A search with this name already exists." },
      { "af_query.MSG_SAVED_SEARCH_NAME_UNIQUE_CONSTRAINT_DETAIL", "Demo:You must provide a unique name." },
      { "af_query.MSG_SAVED_SEARCH_NAME_NOTNULL_CONSTRAINT", "Demo:Name Required" },
      { "af_query.MSG_SAVED_SEARCH_NAME_NOTNULL_CONSTRAINT_DETAIL", "Demo:Please enter a valid name for the saved search." },
      { "af_query.MSG_SAVED_SEARCH_DELDUP_CONSTRAINT", "Demo:Saved Search Selection Required" },
      { "af_query.MSG_SAVED_SEARCH_DELETE_CONSTRAINT_DETAIL", "Demo:Please select a valid saved search to delete." },
      { "af_query.MSG_SAVED_SEARCH_DELETE_WARNING", "Demo:Delete Saved Search: {0}?" },
      { "af_query.MSG_SAVED_SEARCH_DUPLICATE_CONSTRAINT_DETAIL", "Demo:Please select a valid saved search to duplicate." },  
      { "af_query.TIP_DELETE_SEARCH_FIELD", "Demo:Remove: {0}" }, 
      { "af_query.TIP_DELETE_WARNING", "Demo:Warning" },
      { "af_query.TIP_OPERATOR", "Demo:Operators for " }, 
      { "af_query.LABEL_VALUE_LOV_POPUP", "Demo:Search and Select: " }, 
/* quickQuery */ 
      { "af_quickQuery.LABEL_DEFAULT", "Demo:Search" },
/* richTextEditor */ 
      { "af_richTextEditor.TIP_FONT_SHORT_DESCRIPTION", "Demo:Font" },
      { "af_richTextEditor.TIP_FONT_UNSELECTED_LABEL", "Demo:Font" },
      { "af_richTextEditor.TIP_FONT_SIZE_SHORT_DESCRIPTION", "Demo:Font Size" },
      { "af_richTextEditor.TIP_COLOR_FOREGROUND", "Demo:Foreground Color" },
      { "af_richTextEditor.TIP_COLOR_BACKGROUND", "Demo:Background Color" },
      { "af_richTextEditor.LABEL_SPECIFY_THE_URL", "Demo:Please specify the URL:" },
      { "af_richTextEditor.LABEL_EDITING_REGION_TITLE", "Demo:Editing Region" },
/* selectBooleanCheckbox */ 
      { "af_selectBooleanCheckbox.TIP_SELECTED", "Demo:checked" },
      { "af_selectBooleanCheckbox.TIP_UNSELECTED", "Demo:unchecked" },
/* selectManyChoice */ 
      { "af_selectManyChoice.LABEL_SELECT_ALL", "Demo:All" },
/* selectManyListbox */ 
      { "af_selectManyListbox.LABEL_SELECT_ALL", "Demo:All" },
/* selectManyShuttle */ 
      { "af_selectManyShuttle.MSG_SCREEN_READER_INSTRUCTION", "Demo:This component allows you to select items from the list of available items and add them to a selected list. Use the keyboard to select items and then press the 'Add' button to move them to the list of selected items." },

  /* add demos for these two */ 
/* showDetail */ 
      { "af_showDetail.TIP_DISCLOSED", "Demo:Collapse" },
      { "af_showDetail.TIP_UNDISCLOSED", "Demo:Expand" },
/* showDetailItem */ 
      { "af_showDetailItem.TIP_ITEM", "Demo:Item: {0}" },
      { "af_showDetailItem.TIP_SELECTED_ITEM", "Demo:Selected Item: {0}" },
      { "af_showDetailItem.TIP_DISABLED_ITEM", "Demo:Disabled Item: {0}" },
      { "af_showDetailItem.TIP_SELECTED_DISABLED_ITEM", "Demo:Selected Disabled Item: {0}" },
/* statusIndicator */ 
      { "af_statusIndicator.TIP_IDLE", "Demo:Idle" },
      { "af_statusIndicator.TIP_BUSY", "Demo:Busy" },
      { "af_statusIndicator.TIP_CONNECTING", "Demo:Connecting" },
      { "af_statusIndicator.TIP_CONNECTED", "Demo:Connected" },
      { "af_statusIndicator.TIP_RECONNECTING", "Demo:Reconnecting" },
      { "af_statusIndicator.TIP_DISCONNECTED", "Demo:Disconnected" },
/* table */ 
      { "af_table.LABEL_REORDERING_COLUMN", "Demo:Reordering. Please wait..." },
      { "af_table.LABEL_FETCHING", "Demo:Fetching Data..." },
      { "af_table.LABEL_END", "Demo:End" },
      { "af_table.LABEL_START", "Demo:Start" },
      { "af_table.LABEL_ROW", "Demo:Row " },
      { "af_table.LABEL_SELECT_ROW", "Demo:Select Row " },
      { "af_table.LABEL_GOING_TO", "Demo:Going To: " },
      { "af_table.LABEL_ROW_RANGE_UNKNOWN_COUNT", "Demo:Rows {0} - {1}" },
      { "af_table.LABEL_ROW_RANGE_KNOWN_COUNT", "Demo:Rows {0} - {1} of {2}" },
      { "af_table.TIP_COLLAPSED_NODE", "Demo:Expand" },
      { "af_table.TIP_EXPANDED_NODE", "Demo:Collapse" },
      { "af_table.LABEL_HEADER_SUMMARY", "Demo:This table contains column headers corresponding to the data body table below" },
/* train */ 
      { "af_train.TIP_STOP", "Demo:{0} Step: {1}" },
      { "af_train.TIP_PARENT_TRAIN", "Demo:{0}" },
      { "af_train.LABEL_PARENT_TRAIN_SEPARATOR", "Demo: > " },
      { "af_train.TIP_STOP_ERROR", "Demo:{0} Step with Error in: {1}" },
      { "af_train.TIP_STOP_WARNING", "Demo:{0} Step with Warning in: {1}" },
      { "af_train.TIP_STOP_INFORMATION", "Demo:{0} Step with Information in: {1}" },
      { "af_train.TIP_STOP_CONFIRMATION", "Demo:{0} Step with Confirmation in: {1}" },
      { "af_train.TIP_SHOW_PREV_STEPS", "Demo:Show Previous Steps" },
      { "af_train.TIP_SHOW_NEXT_STEPS", "Demo:Show Next Steps" },
      { "af_train.VISITED_STEP", "Demo:Visited" },
      { "af_train.ACTIVE_STEP", "Demo:Current" },
      { "af_train.UNVISITED_STEP", "Demo:Unvisited" },
      { "af_train.DISABLED_STEP", "Demo:Disabled" },
/* trainButtonBar */ 
      { "af_trainButtonBar.LABEL_BACK", "Demo:&Back" },
      { "af_trainButtonBar.LABEL_NEXT", "Demo:N&ext" },
/* tree */ 
      { "af_tree.TIP_COLLAPSED_NODE", "Demo:Expand" },
      { "af_tree.TIP_EXPANDED_NODE", "Demo:Collapse" },
      { "af_tree.TIP_HIERARCHICAL_SELECTOR", "Demo:Select to display popup" },
      { "af_tree.TIP_GO_TO_TOP", "Demo:Go to Top" },
      { "af_tree.TIP_NODE_LEVEL", "Demo:Tree node level {0}" }
    };
}
