REM =======================================================
REM create adfdi schema objects
REM =======================================================


REM =======================================================
REM cleanup the existing tables
REM =======================================================

DROP TABLE PRODUCTS CASCADE CONSTRAINTS;
DROP TABLE CATEGORIES CASCADE CONSTRAINTS;
DROP TABLE SUPPLIERS CASCADE CONSTRAINTS;

REM =======================================================
REM cleanup the existing Sequences
REM =======================================================

DROP SEQUENCE PRODUCT_SEQ;
DROP SEQUENCE CATEGORY_SEQ;
DROP SEQUENCE SUPPLIER_SEQ;

REM =======================================================
REM Create Suppliers table
REM =======================================================

CREATE TABLE SUPPLIERS
(
SUPPLIER_ID NUMBER(15) NOT NULL,
SUPPLIER_NAME VARCHAR2(120) NOT NULL,
SUPPLIER_STATUS VARCHAR(30) NOT NULL,
PHONE_NUMBER VARCHAR2(20),
EMAIL VARCHAR2(255),
CONSTRAINT SUPPLIERS_PK PRIMARY KEY (SUPPLIER_ID)
);

REM =======================================================
REM Create Categories table
REM =======================================================

CREATE TABLE CATEGORIES
(
CATEGORY_ID NUMBER(15) NOT NULL,
CATEGORY_NAME VARCHAR2(50) NOT NULL,
CATEGORY_DESCRIPTION VARCHAR2(1000),
PARENT_CATEGORY_ID NUMBER(15),
CATEGORY_LOCKED_FLAG VARCHAR2(1) DEFAULT 'N' NOT NULL,
REPRESENTATIVE_PRODUCT_ID NUMBER(15),
CONSTRAINT CATEGORIES_PARENT_CATEGORY_FK FOREIGN KEY (PARENT_CATEGORY_ID) REFERENCES CATEGORIES (CATEGORY_ID),
CONSTRAINT CATEGORIES_PK PRIMARY KEY (CATEGORY_ID)
);

REM =======================================================
REM Create Products table
REM =======================================================

CREATE TABLE PRODUCTS
(
PRODUCT_ID NUMBER(15) NOT NULL,
SUPPLIER_ID NUMBER(15) NOT NULL,
PARENT_CATEGORY_ID NUMBER(15),
CATEGORY_ID NUMBER(15),
PRODUCT_NAME VARCHAR2(50) NOT NULL,
PRODUCT_STATUS VARCHAR2(30) NOT NULL,
COST_PRICE NUMBER(8, 2),
WARRANTY_PERIOD_MONTHS NUMBER(2, 0),
EXTERNAL_URL VARCHAR2(200),
CONSTRAINT PRODUCTS_PARENT_CATEGORY_FK FOREIGN KEY (PARENT_CATEGORY_ID) REFERENCES CATEGORIES (CATEGORY_ID),
CONSTRAINT PRODUCTS_CATEGORY_FK FOREIGN KEY (CATEGORY_ID) REFERENCES CATEGORIES (CATEGORY_ID),
CONSTRAINT PRODUCTS_SUPPLIER_FK FOREIGN KEY (SUPPLIER_ID) REFERENCES SUPPLIERS (SUPPLIER_ID),
CONSTRAINT PRODUCTS_PK PRIMARY KEY (PRODUCT_ID)
);

REM =======================================================
REM Create Database sequences for the primary keys 
REM =======================================================

CREATE SEQUENCE PRODUCT_SEQ INCREMENT BY 1 START WITH 100;
CREATE SEQUENCE CATEGORY_SEQ INCREMENT BY 1 START WITH 15;
CREATE SEQUENCE SUPPLIER_SEQ INCREMENT BY 1 START WITH 300 CACHE 10 ;

CREATE OR REPLACE
TRIGGER ASSIGN_PRODUCT_ID BEFORE INSERT ON PRODUCTS
FOR EACH ROW
BEGIN
 IF :NEW.PRODUCT_ID IS NULL OR :NEW.PRODUCT_ID <= 0 THEN
   SELECT PRODUCT_SEQ.NEXTVAL
     INTO :NEW.PRODUCT_ID
     FROM DUAL;
   END IF;
END;
/

CREATE OR REPLACE
TRIGGER ASSIGN_CATEGORY_ID BEFORE INSERT ON CATEGORIES
FOR EACH ROW
BEGIN
 IF :NEW.CATEGORY_ID IS NULL OR :NEW.CATEGORY_ID <= 0 THEN
   SELECT CATEGORY_SEQ.NEXTVAL
     INTO :NEW.CATEGORY_ID
     FROM DUAL;
   END IF;
END;
/

CREATE OR REPLACE TRIGGER ASSIGN_SUPPLIER_ID BEFORE INSERT ON SUPPLIERS
FOR EACH ROW
BEGIN
 IF :NEW.SUPPLIER_ID IS NULL OR :NEW.SUPPLIER_ID <= 0 THEN
   SELECT SUPPLIER_SEQ.NEXTVAL
     INTO :NEW.SUPPLIER_ID
     FROM DUAL;
   END IF;
END;
/

REM =======================================================
REM Insert records into Suppliers table
REM =======================================================

Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (100,'Stuffz','ACTIVE','402.555.0158','contact@stuffz.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (101,'Nexus','ACTIVE','608.555.0114','contact@nexus.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (102,'Gifts-N-More','ACTIVE','225.555.0181','contact@giftsnmore.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (103,'Emporium','INACTIVE','212.555.0198','contact@emporium.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (104,'Jeffery And Michael''s','ACTIVE','419.555.0167','contact@jeffery-michael.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (105,'Games Galore','ACTIVE','630.555.0127','contact@games_galore.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (106,'Transistor City','ACTIVE','303.555.0177','contact@transistorcity.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (107,'Mercury Imports','ACTIVE','862.555.0108','contact@mercury-imports.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (108,'BigSwamp','INACTIVE','248.555.0154','contact@bigswamp.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (109,'Z-Mart','INACTIVE','959.555.0120','contact@zmart.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (110,'Wally''s Mart','ACTIVE','470.555.0180','contact@wallymart.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (111,'Ellis','ACTIVE','641.555.0194','contact@ellis.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (112,'Electronics and More','ACTIVE','413.555.0140','contact@electronics_and_more.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (113,'Zibbers','ACTIVE','717.555.0162','contact@zibbers.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (114,'Great Gadgets','ACTIVE','320.555.0155','contact@greatgadgets.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (115,'Perfect Purchase','INACTIVE','971.555.0128','contact@perfect_purchase.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (116,'Silicon Super Store','ACTIVE','829.555.0141','contact@siliconsuperstore.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (117,'Value Valley','ACTIVE','325.555.0134','contact@valuevalley.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (118,'Super Stuff','ACTIVE','661.555.0186','contact@superstuff.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (119,'Gifts-to-Go','ACTIVE','308.555.0157','contact@giftstogo.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (120,'MoreStuffz','ACTIVE','662.555.0125','contact@morestuffz.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (121,'MoreAndMoreStuffz','ACTIVE','614.555.0121','contact@moreandmorestuffz.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (122,'MaxStuffz','INACTIVE','570.555.0196','contact@maxstuffz.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (123,'Geeky Gadgets','ACTIVE','256.555.0152','contact@geekygadgets.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (124,'Gobs of Goods','ACTIVE','647.555.0166','contact@gobsofgoods.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (125,'Stock Plus','ACTIVE','563.555.0191','contact@stockplus.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (126,'Zip City','ACTIVE','985.555.0163','contact@zipcity.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (127,'Shop-a-lot','ACTIVE','269.555.0175','contact@shopalot.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (128,'Shopster','ACTIVE','706.555.0109','contact@shopster.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (129,'Simply Shop','ACTIVE','848.555.0137','contact@simplyshop.example.com');
Insert into SUPPLIERS (SUPPLIER_ID,SUPPLIER_NAME,SUPPLIER_STATUS,PHONE_NUMBER,EMAIL) values (200,'BuyMyJunk','ACTIVE','980.555.0112','contact@buymyjunk.example.com');

REM =======================================================
REM Insert records into Categories table
REM =======================================================

Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (1,'Media','Books, Music, and Movies',null,'N',42);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (2,'Office','Office Supplies',null,'N',55);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (3,'Electronics','Consumer Electronics',null,'N',30);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (4,'Audio and Video','Audio and Video',3,'N',20);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (5,'Camera and Photo','Camera and Photo',3,'N',30);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (6,'Cell Phones','Cell Phones and Service',3,'N',4);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (7,'Games','Computer and Video Games',3,'N',36);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (8,'Books','Books',1,'N',61);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (9,'DVDs','DVDs',1,'N',62);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (10,'Periodicals','Magazines and Newspapers',1,'N',null);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (11,'Music','CDs',1,'N',42);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (12,'Hardware','Computers',2,'N',24);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (13,'Supplies','Office Supplies',2,'N',55);
Insert into CATEGORIES (CATEGORY_ID,CATEGORY_NAME,CATEGORY_DESCRIPTION,PARENT_CATEGORY_ID,CATEGORY_LOCKED_FLAG,REPRESENTATIVE_PRODUCT_ID) values (14,'Software','Software',2,'N',52);

REM =======================================================
REM Insert records into Products table
REM =======================================================

Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (1,112,3,4,'Plasma HD Television','AVAILABLE',1499.99,6,'images/1.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (2,107,2,13,'PlayStation 2 Video Game','AVAILABLE',85,2,'images/2.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (3,102,3,6,'Treo 650 Phone/PDA','AVAILABLE',200,6,'images/3.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (4,106,3,6,'Treo 700w Phone/PDA','AVAILABLE',300,6,'images/4.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (5,106,3,4,'Tungsten E PDA','AVAILABLE',100,3,'images/5.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (6,105,3,7,'XBox Video Game System','AVAILABLE',75,3,'images/6.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (7,105,3,7,'XBox 360 Video Game System','AVAILABLE',150,3,'images/7.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (8,119,3,7,'Playstation Portable','AVAILABLE',100,3,'images/8.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (9,105,3,7,'Nintendo DS','AVAILABLE',55,3,'images/9.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (10,123,3,4,'Zune 30Gb','AVAILABLE',100,3,'images/10.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (11,112,3,6,'RAZR Cellular Phone','AVAILABLE',140,3,'images/11.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (12,123,3,4,'Muvo Personal MP3 Player','AVAILABLE',64,3,'images/12.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (13,101,3,6,'Bluetooth Adaptor','AVAILABLE',5,0,'images/13.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (14,112,3,6,'Bluetooth Phone Headset','AVAILABLE',20,0,'images/14.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (15,106,3,4,'Ipod Speakers','AVAILABLE',35,6,'images/15.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (16,106,3,4,'Creative Zen Vision W 60 GB','AVAILABLE',290,6,'images/16.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (17,126,3,4,'Ipod Video 80Gb','AVAILABLE',200,6,'images/17.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (18,123,3,4,'Ipod Shuffle 1Gb','AVAILABLE',45,6,'images/18.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (19,114,3,4,'Ipod Video 30Gb','AVAILABLE',125,6,'images/19.gif');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (20,112,3,4,'Ipod Video 60Gb','AVAILABLE',175,6,'images/20.gif');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (21,123,3,4,'Ipod Nano 1Gb','AVAILABLE',90,6,'images/21.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (22,126,3,4,'Ipod Nano 2Gb','AVAILABLE',100,6,'images/22.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (23,106,3,4,'Ipod Nano 4Gb','AVAILABLE',150,6,'images/23.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (24,103,2,12,'17-Inch iMac','AVAILABLE',400,6,'images/24.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (25,101,2,12,'20-Inch iMac','AVAILABLE',1000,12,'images/25.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (26,103,2,12,'Mini Mac Computer','AVAILABLE',400,12,'images/26.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (27,107,2,12,'17-Inch Powerbook','AVAILABLE',2500,12,'images/27.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (28,102,2,12,'15-Inch MacBook Pro','AVAILABLE',1000,12,'images/28.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (29,106,3,4,'LCD HD Television','AVAILABLE',600,12,'images/29.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (30,123,3,5,'MPEG4 Camcorder','AVAILABLE',200,3,'images/30.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (31,106,3,5,'7 Megapixel Digital Camera','AVAILABLE',300,3,'images/31.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (32,114,3,5,'Internet Camera','AVAILABLE',200,3,'images/32.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (33,106,3,6,'Chocolate Phone','AVAILABLE',300,6,'images/33.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (34,114,3,5,'6 Megapixel Digital Camera','AVAILABLE',200,6,'images/34.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (35,123,3,6,'Blackberry 8100c','AVAILABLE',300,6,'images/35.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (36,105,3,7,'Nintendo Wii','AVAILABLE',470,12,'images/36.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (37,119,3,7,'Wii Remote','AVAILABLE',60,3,'images/37.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (38,104,1,8,'Beginning EJB Application Development','AVAILABLE',15,0,'images/38.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (39,113,1,8,'Pro EJB 3: Java Persistence API','AVAILABLE',15,0,'images/39.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (40,104,1,8,'The Oracle of Oracle','AVAILABLE',5,0,'images/40.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (41,113,1,8,'EJB3 In Action','AVAILABLE',9,0,'images/41.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (42,103,1,11,'Essential Bach','AVAILABLE',4,0,'images/42.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (43,121,1,11,'Beethoven Symphonies Collection','AVAILABLE',6,0,'images/43.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (44,109,1,11,'Essential Mozart','AVAILABLE',6,0,'images/44.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (45,107,1,11,'Chopin: Favorite Piano Works','AVAILABLE',7,0,'images/45.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (46,117,1,11,'Tchaikovsky''s Ballet','AVAILABLE',9,0,'images/46.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (47,110,1,11,'Dvorak''s Great Symphonies','AVAILABLE',7,0,'images/47.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (48,100,2,14,'Oracle Collaboration Suite (User Perpetual)','AVAILABLE',60,12,'images/48.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (49,102,2,14,'Oracle Application Server (Processor Perpetual)','AVAILABLE',5000,12,'images/49.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (50,108,2,14,'Oracle Database SE (Processor Perpetual)','AVAILABLE',4995,12,'images/50.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (51,101,2,14,'Oracle Database EE (Processor Perpetual)','AVAILABLE',40000,12,'images/51.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (52,103,2,14,'Oracle JDeveloper','AVAILABLE',0,12,'images/52.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (53,104,2,14,'Oracle Linux Premier Support','AVAILABLE',1999,12,'images/53.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (54,107,2,13,'Stapler','AVAILABLE',4,0,'images/54.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (55,103,2,13,'Red Swingline Stapler','AVAILABLE',15,12,'images/55.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (56,108,2,13,'7 port USB Hub','AVAILABLE',20,6,'images/56.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (57,101,2,13,'Multi-purpose Scissors','AVAILABLE',10,0,'images/57.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (58,109,2,13,'Roller Carrying Case','AVAILABLE',50,6,'images/58.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (59,103,2,13,'Contour Carrying Case','AVAILABLE',40,6,'images/59.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (60,104,1,8,'JavaServer Faces: The Complete Reference','AVAILABLE',18,0,'images/60.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (61,113,1,8,'Oracle JDeveloper for Forms and PL/SQL Developers','AVAILABLE',20,0,'images/61.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (62,103,1,9,'Rin Tin Tin Double Feature, Vol. 1 (1947)','AVAILABLE',3,3,'images/62.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (63,107,1,9,'Rin Tin Tin Double Feature, Vol. 2 (1947)','AVAILABLE',3,3,'images/63.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (64,101,1,9,'Sky King:Vol 1 TV Series (1958)','AVAILABLE',3,3,'images/64.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (65,104,1,9,'Cheyenne - The Complete First Season (1955)','AVAILABLE',3,3,'images/65.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (66,110,1,9,'Rawhide - The Complete First Season (1959)','AVAILABLE',3,3,'images/66.jpg');
Insert into PRODUCTS (PRODUCT_ID,SUPPLIER_ID,PARENT_CATEGORY_ID,CATEGORY_ID,PRODUCT_NAME,PRODUCT_STATUS,COST_PRICE,WARRANTY_PERIOD_MONTHS,EXTERNAL_URL) values (67,102,1,9,'Colt .45 / Tall Man Riding / Fort Worth (1950)','AVAILABLE',3,3,'images/67.jpg');

COMMIT;