package oracle.adfdi.demo.cf.model.errorhandler;

import oracle.adf.model.binding.DCErrorHandlerImpl;
import oracle.adf.model.BindingContext;
import oracle.adf.model.RegionBinding;

public class MyCustomErrorHandler extends DCErrorHandlerImpl {
    public MyCustomErrorHandler(boolean b) {
        super(b);
    }

    public MyCustomErrorHandler() {
        super(false);
    }

    /**
     * Overrides the base class getDetailedDisplayMessage to call custom error message class using which we format the error message to our choice
     * @param bindingContext
     * @param regionBinding
     * @param exception
     * @return
     */
    public oracle.adf.model.binding.DCErrorMessage getDetailedDisplayMessage(BindingContext bindingContext,
                                                                             RegionBinding regionBinding,
                                                                             Exception exception) {
        System.out.println("getDetailedDisplayMessage:");
        return new MyDCErrorMessage(regionBinding, exception);
    }
}
