package oracle.adfdi.demo.cf.model.service;

import oracle.adf.desktopintegration.model.ModelHelper;
import oracle.adf.share.ADFContext;

import oracle.adfdi.demo.cf.model.service.common.CFService;

import oracle.adfdi.demo.cf.model.vo.ProductsVORowImpl;

import oracle.jbo.AttributeList;
import oracle.jbo.JboException;
import oracle.jbo.NameValuePairs;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewCriteriaRow;
import oracle.jbo.ViewObject;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.ViewLinkImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowImpl;
// ---------------------------------------------------------------------
// ---    File generated by Oracle ADF Business Components Design Time.
// ---    Mon Feb 01 23:37:51 IST 2010
// ---    Custom code may be added to this class.
// ---    Warning: Do not modify method signatures of generated methods.
// ---------------------------------------------------------------------
public class CFServiceImpl extends ApplicationModuleImpl implements CFService {
    /**
     * This is the default constructor (do not remove).
     */
    public CFServiceImpl() {
    }

    /**
     * Container's getter for ProductsVO.
     * @return ProductsVO
     */
    public ViewObjectImpl getProductsVO() {
        return (ViewObjectImpl)findViewObject("ProductsVO");
    }

    /**
     * Container's getter for SuppliersVO.
     * @return SuppliersVO
     */
    public ViewObjectImpl getSuppliersVO() {
        return (ViewObjectImpl)findViewObject("SuppliersVO");
    }

    /**
     * Container's getter for SuppliersROVO1.
     * @return SuppliersROVO1
     */
    public ViewObjectImpl getSuppliersROVO() {
        return (ViewObjectImpl)findViewObject("SuppliersROVO");
    }    

    /**
     * Container's getter for ProductsVO1.
     * @return ProductsVO1
     */
    public ViewObjectImpl getProductsVOofSuppliers() {
        return (ViewObjectImpl)findViewObject("ProductsVOofSuppliers");
    }

    /**
     * Container's getter for ProductsSupplierFkLink1.
     * @return ProductsSupplierFkLink1
     */
    public ViewLinkImpl getProductsSupplierFkLink1() {
        return (ViewLinkImpl)findViewLink("ProductsSupplierFkLink1");
    }    
        
    public String sayHello(String name){
        return ("Hello "+ name+"!");
    }
    
    public String sayHelloOracle(){
        return "Hello Oracle!";
    }    
    
    public void assignSelectedSupplierToCurrentProductRow(){
        ViewObject productsVO = this.getProductsVO();
        ViewObject suppliersVO = this.getSuppliersVO();
        
        //Gets current row in the excel table
        Row productRow = productsVO.getCurrentRow();
        
        //Gets current row in the suppliers popup
        Row supplierRow = suppliersVO.getCurrentRow();
        
        //Assigns selected supplier to current product row in excel
        productRow.setAttribute("SupplierId", supplierRow.getAttribute("SupplierId"));
        
        System.out.println("\n********* Selected Supplier Id: "+supplierRow.getAttribute("SupplierId"));
    }
    
    public void searchProductsByName(String productName){
        System.out.println("\n********* searchProductsByName method is called - ProductName: "+productName);
        ViewObject productsVO = this.getProductsVO();
        ViewCriteria vc = productsVO.createViewCriteria();
        
        if(productName != null)
            productName.toUpperCase();
        
        ViewCriteriaRow vcr = vc.createViewCriteriaRow();        
        vcr.setAttribute("ProductName", productName);
        vcr.setUpperColumns(true);
        
        vc.add(vcr);
        
        productsVO.applyViewCriteria(vc);        
        productsVO.executeQuery();      
    }
    
    public void initializeSupplierRows(){
        System.out.println("\n********* initializeSupplierRows method is called");
        ViewObject suppliersVO = this.getSuppliersVO();
        suppliersVO.executeEmptyRowSet();
        
        //Following code creates new temporary records with default supplier name 
        ViewRowImpl supplierRow = (ViewRowImpl)suppliersVO.createRow();
        supplierRow.setAttribute("SupplierName","Sanz Creations");
        supplierRow.setNewRowState(oracle.jbo.Row.STATUS_INITIALIZED);
        suppliersVO.insertRow(supplierRow);
        
        supplierRow = (ViewRowImpl)suppliersVO.createRow();
        supplierRow.setAttribute("SupplierName","Impex Enterprises");
        supplierRow.setNewRowState(oracle.jbo.Row.STATUS_INITIALIZED);
        suppliersVO.insertRow(supplierRow);
    }
    
    /**
     * Takes Supplier name from user and assigns respective SupplierId to Product
     */
    public void assignSupplierIdForProductFromSupplierName()
    {
        ViewObjectImpl productVO = this.getProductsVO();
        ProductsVORowImpl currentProduct = (ProductsVORowImpl)productVO.getCurrentRow ();

        ViewRowImpl childSupplier = null;
        RowIterator childSupplierItr = currentProduct.getSuppliersROVO();

        // In case of insertion child row will not be available so, get ADFdi temporary product-category child row
        // (note: no actual row available since CategoryId on employee is null)
        if(childSupplierItr != null && childSupplierItr.getRowCount() > 0){
            childSupplier = (ViewRowImpl)childSupplierItr.first();
        }
        else{
            childSupplier = ModelHelper.getAdfdiTempChildRow(currentProduct, "SuppliersROVO");
        }

        // Step 1: Get Supplier name from temporary Product row
        String supplierName = (String)childSupplier.getAttribute ("SupplierName");
        // Supplier name not found
        if (supplierName == null)
            throw new JboException("Supplier Name is required");

        // Step 2: Find SupplierId for Supplier
        Object supplierId = findSupplierIdFromSupplierName(supplierName);
        // SupplierId not found
        if (supplierId == null)
            throw new JboException("Supplier with the given Supplier Name not found");

        // Step 3: Assign SupplierId to current product
        currentProduct.setAttribute ("SupplierId", supplierId);
    }

    /**
     * Gets Supplier Id for given Supplier Name
     * @param supplierName
     * @return supplierId
     */
    private Object findSupplierIdFromSupplierName(String supplierName){
        oracle.jbo.Row[] rows = this.getSuppliersROVO().getFilteredRows("SupplierName",supplierName);
        if(rows != null && rows.length > 0){
            ViewRowImpl supplierRow = (ViewRowImpl)rows[0];
            return supplierRow.getAttribute("SupplierId");
        }
    
        return null;
    }    
    
    /**
     * Method to filter products based on caterogyId
     * @param categoryId
     */
    public void fetchProductsByCategory(oracle.jbo.domain.Number categoryId){
        System.out.println("\n********* fetchProductsByCategory method is called: "+categoryId);
        ViewObject productsPVO = this.getProductsPVO();

        //Following code creates new View Criteria with categoryId and executes re-executes ProductsPVO
        ViewCriteria productVC = productsPVO.createViewCriteria();
        ViewCriteriaRow productVCRow = productVC.createViewCriteriaRow();
        productVCRow.setAttribute("CategoryId", categoryId);
        productVC.add(productVCRow);
        productsPVO.applyViewCriteria(productVC);
        productsPVO.executeQuery();
        
        //Set CategoryId value to session scope variable, needed for insertion
        ADFContext.getCurrent().getSessionScope().put("CategoryId", categoryId);            
    }    
    
    /* Method to insert records with discriminator field set*/

    /**
     * Method to insert records with discriminator field set with session value
     */
    public void insertProductWithDiscriminator(){
        System.out.println("\n********* insertProductWithDiscriminator method is called");
        ViewObject productsPVO = this.getProductsPVO();
        
        //get CategoryId value from session scope variable.
        AttributeList attrs = new NameValuePairs();
        attrs.setAttribute("CategoryId", ADFContext.getCurrent().getSessionScope().get("CategoryId"));
        
        //Following code creates records with discriminator field specific to categoryId
        ViewRowImpl productRow = (ViewRowImpl)productsPVO.createAndInitRow(attrs);
        productsPVO.insertRow(productRow);
    }


    /**
     * Container's getter for ProductsPVO1.
     * @return ProductsPVO1
     */
    public ViewObjectImpl getProductsPVO() {
        return (ViewObjectImpl)findViewObject("ProductsPVO");
    }


    /**
     * Container's getter for ChildSuppliersROVO.
     * @return ChildSuppliersROVO
     */
    public ViewObjectImpl getChildSuppliersROVO() {
        return (ViewObjectImpl)findViewObject("ChildSuppliersROVO");
    }

    /**
     * Container's getter for ProductSupplierVL.
     * @return ProductSupplierVL
     */
    public ViewLinkImpl getProductSupplierVL() {
        return (ViewLinkImpl)findViewLink("ProductSupplierVL");
    }

    /**
     * Container's getter for CategoriesROVO.
     * @return CategoriesROVO
     */
    public ViewObjectImpl getCategoriesROVO() {
        return (ViewObjectImpl)findViewObject("CategoriesROVO");
    }
}
