package adf.sample.bean;

import oracle.adf.view.rich.component.rich.data.RichTable;

import oracle.adf.view.rich.context.AdfFacesContext;

import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUCtrlHierBinding;

import org.apache.myfaces.trinidad.model.CollectionModel;

public class EmployeesBackingBean {
    private RichTable employeesTable;

    public EmployeesBackingBean() {
        super();
    }

    public void reQueryEmployeestable(oracle.jbo.domain.Number deptId){
        //get access to the ViewObject through the table's ADF tree binding. Note that this
        //approach assumes ADF BC as the business service because ViewObjects don't exist
        //elsewhere
        CollectionModel model = (CollectionModel) this.getEmployeesTable().getValue();
        JUCtrlHierBinding adfBinding = (JUCtrlHierBinding) model.getWrappedData();
        ViewObject employeesViewObject = adfBinding.getViewObject();        
        //set the bind variable in the query to the value of the department
        VariableValueManager vmanager = employeesViewObject.getVariableManager();
        vmanager.setVariableValue("deptId",deptId);        
        employeesViewObject.executeQuery();
        //refresh the table to show the result of the query
        AdfFacesContext adfFacesCtx = AdfFacesContext.getCurrentInstance();
        adfFacesCtx.addPartialTarget(this.getEmployeesTable());
    }

    //table reference
    public void setEmployeesTable(RichTable employeesTable) {
        this.employeesTable = employeesTable;
    }

    public RichTable getEmployeesTable() {
        return employeesTable;
    }
}
