package adf.sample.events;


import adf.sample.bean.EmployeesBackingBean;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;

import oracle.adf.view.faces.bi.event.ClickEvent;

import oracle.dss.dataView.DataComponentHandle;

import oracle.jbo.Key;


public class EventReceiver {
    public EventReceiver() {
        super();
    }
       
    /**
     * handle the event and receive the payload object. The payload object is of
     * the event type raising the contextual event, for example a JSF value change 
     * event or action event, or an ADF binding event
     * @param payload
     */
    public void handleEvent(Object payload){
        //cast the payload to the ClickEvent. Note that the ctx event handler
        //could have used a typed argument instead of "Object", in which case
        //a) an error would be raised if the value in the payload is of a wrong 
        //type and b) a casting in the method is not required. 
        //
        //There are good arguments for the use of both approaches. The one using 
        //an Object argument for example allows you to gracefully handle possible 
        //type cast exceptions instead of handling it using the configured ADF or 
        //ADFc exception handlers.
        ClickEvent clickEvent = (ClickEvent) payload;
        if (clickEvent.getComponentHandle() instanceof DataComponentHandle){
            DataComponentHandle dch = (DataComponentHandle) clickEvent.getComponentHandle();          
            //get the selected row key from the graph (click event)
            Key rwKey = (Key) dch.getValue(DataComponentHandle.ROW_KEY);
            EmployeesBackingBean employeesBean = getEmployeesBean();
            employeesBean.reQueryEmployeestable((oracle.jbo.domain.Number)rwKey.getKeyValues()[0]);
        }        
    }
    
    private EmployeesBackingBean getEmployeesBean() {
        FacesContext fctx = FacesContext.getCurrentInstance();
        ELContext elctx = fctx.getELContext();
        Application jsfApp = fctx.getApplication();
        ExpressionFactory exprFactory = jsfApp.getExpressionFactory();
        ValueExpression ve = null;
        //access the backing bean, which is configured in the employees task 
        //flow. Its configured to be in backing bean scope
        ve = exprFactory.createValueExpression( 
                       elctx,               
                       "#{backingBeanScope.EmployeesBackingBean}",
                       Object.class);  
        return (EmployeesBackingBean) ve.getValue(elctx);
    }
}
