package adf.sample;

import java.util.ArrayList;
import java.util.List;

import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;

import oracle.adf.view.rich.component.rich.data.RichTreeTable;
import oracle.adf.view.rich.context.AdfFacesContext;

import oracle.jbo.uicli.binding.JUCtrlHierBinding;
import oracle.jbo.uicli.binding.JUCtrlHierNodeBinding;

import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.model.RowKeySetImpl;


public class TreeSampleBacking {
    public TreeSampleBacking() {
    }

    public void beforeRenderOnViewLoad(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId() == PhaseId.RENDER_RESPONSE){
          FacesContext fctx = FacesContext.getCurrentInstance();
          AdfFacesContext adfFacesContext = AdfFacesContext.getCurrentInstance();
          
          //make sure this code is executed on the initial page request only
          boolean isInitialRequest = !adfFacesContext.isPartialRequest(fctx);
          if (isInitialRequest) {
                UIViewRoot viewRoot = fctx.getViewRoot();
                UIComponent treeTable = viewRoot.findComponent("pc1:tt1");

                if (treeTable != null) {

                    CollectionModel model =  (CollectionModel)((RichTreeTable)treeTable).getValue();
                    JUCtrlHierBinding treeBinding = (JUCtrlHierBinding)model.getWrappedData();
                    JUCtrlHierNodeBinding rootNode = treeBinding.getRootNodeBinding();

                    RowKeySet rks = (((RichTreeTable)treeTable).getDisclosedRowKeys());
                    if (rks == null) {
                        rks = new RowKeySetImpl();
                    }

                    if (rks.getSize()==0) {
                        List<JUCtrlHierNodeBinding> firstLevelChildren =
                            rootNode.getChildren();
                        for (JUCtrlHierNodeBinding node : firstLevelChildren) {
                            ArrayList l = new ArrayList();
                            l.add(node.getRowKey());
                            rks.add(l);
                        }
                      ((RichTreeTable)treeTable).setDisclosedRowKeys(rks);
                    }
                }
            }
                                                                                        
        }
    }
}
