/*
 * Decompiled with CFR 0.152.
 */
package oracle.reports.utility;

import java.applet.Applet;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import netscape.javascript.JSObject;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.ID;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.VBean;
import oracle.reports.utility.RwUtility;

public class FrmReportsInteg608
extends VBean {
    public static final ID pAddUserid = ID.registerProperty((String)"ADD_USERID");
    public static final ID pWriteUseridCookie = ID.registerProperty((String)"WRITE_USERID_COOKIE");
    public static final ID pAdjustTime = ID.registerProperty((String)"ADJUST_TIMEZONE_DIFFERENCE");
    public static final ID pSetEncryptionKey = ID.registerProperty((String)"SET_ENCRYPTION_KEY");
    public static final ID pSetDomain = ID.registerProperty((String)"SET_COOKIE_DOMAIN");
    public static final ID pSetCookieExpiry = ID.registerProperty((String)"SET_COOKIE_EXPIRY");
    public static final ID pRwAuthMessage = ID.registerProperty((String)"RWAUTH_MESSAGE");
    public static final ID eRwAuthEvent = ID.registerProperty((String)"RWAUTH_EVENT");
    public static final ID pLogOutput = ID.registerProperty((String)"WRITE_LOGOUTPUT");
    public static final ID pSetCookiePath = ID.registerProperty((String)"SET_COOKIE_PATH");
    private final String CLASSNAME = this.getDefaultName();
    private boolean m_debug = false;
    private String _key = "Beats Crystal Info 4.5!";
    private String vConnects = "";
    private int cookieExpiryInDays = 0;
    private String cookieDomain = " ";
    private String cookiePath = "/";
    private String _host;
    private URL FormsURL;
    private long timzoneAdjustment = 0L;
    JSObject m_window = null;
    JSObject m_document = null;
    Applet m_applet;
    IHandler m_handler;
    boolean isMSIE = false;

    public final void init(IHandler handler) {
        try {
            super.init(handler);
            this.m_handler = handler;
            this.m_applet = this.m_handler.getApplet();
            this.FormsURL = this.m_applet.getDocumentBase();
            this._host = this.FormsURL.getHost();
            if (this._host.indexOf(46) != -1) {
                this.cookieDomain = this._host.substring(this._host.indexOf(46));
            }
            this.m_window = JSObject.getWindow(this.m_applet);
            JSObject navigator = (JSObject)this.m_window.getMember("navigator");
            String thisBrowser = (String)navigator.getMember("appVersion");
            System.out.println(thisBrowser);
            if (thisBrowser.indexOf("MSIE") > -1) {
                this.isMSIE = true;
                this.log("The Browser used is Internet Explorer");
            } else {
                this.log("The Browser used is Netscape or other");
                this.isMSIE = false;
            }
            this.m_document = (JSObject)this.m_window.getMember("document");
        }
        catch (Exception e) {
            System.out.println("Error Initialising CookieHander Bean");
            System.out.println(e.toString());
            System.out.println("Stack Trace\n-----------------------");
            e.printStackTrace();
        }
    }

    public final boolean setProperty(ID _ID, Object _args) {
        if (_ID == pAddUserid) {
            this.log(String.valueOf(String.valueOf("Adding new userid string \"").concat(String.valueOf((String)_args))).concat(String.valueOf("\"")));
            this.addAuthString((String)_args);
            return true;
        }
        if (_ID == pWriteUseridCookie) {
            this.log(String.valueOf("Default cookie domain: ").concat(String.valueOf(this.cookieDomain)));
            this.setAuthidCookie("databaseid", this._key);
            return true;
        }
        if (_ID == pSetEncryptionKey) {
            if (_args != null && ((String)_args).length() > 0) {
                this.log(String.valueOf("set SET_ENCRYPTION_KEY to ").concat(String.valueOf(_args.toString())));
                this._key = (String)_args;
            } else {
                this.log("set SET_ENCRYPTION_KEY failed due to null value argument passed");
            }
            return true;
        }
        if (_ID == pSetDomain) {
            if (_args != null) {
                String arg = (String)_args;
                if ("RESET".equalsIgnoreCase(arg)) {
                    this.log("re-setting cookie domain");
                    this._host = this.FormsURL.getHost();
                    if (this._host.indexOf(46) != -1) {
                        this.cookieDomain = this._host.substring(this._host.indexOf(46));
                    }
                } else {
                    this.log(String.valueOf("Setting domain to ").concat(String.valueOf((String)_args)));
                    this.setCookieDomain((String)_args);
                }
            }
            return true;
        }
        if (_ID == pAdjustTime) {
            if (_args != null && ((String)_args).length() > 0) {
                try {
                    long timeAdjust = new Long((String)_args);
                    this.timzoneAdjustment = timeAdjust * (long)60000;
                    this.log(String.valueOf("Adjusting time to ").concat(String.valueOf((String)_args)));
                }
                catch (NullPointerException nfe) {
                    this.log("The argument to ADJUST_TIMEZONE_DIFFERENCE does not specify a valid number format");
                }
            }
            return true;
        }
        if (_ID == pSetCookiePath) {
            if (_args != null) {
                String arg = (String)_args;
                if ("RESET".equalsIgnoreCase(arg)) {
                    this.log("Re-stting cookie path");
                    this.cookiePath = " ";
                } else {
                    this.log(String.valueOf("Setting cookie path to ").concat(String.valueOf(arg)));
                    this.cookiePath = arg;
                }
            }
            return true;
        }
        if (_ID == pSetCookieExpiry) {
            this.cookieExpiryInDays = new Integer((String)_args);
            this.log(String.valueOf("Setting cookie expiry time to ").concat(String.valueOf(new Integer((String)_args))));
            return true;
        }
        if (_ID == pLogOutput) {
            this.m_debug = _args.toString().equalsIgnoreCase("true");
            this.log(String.valueOf("Debugging ").concat(String.valueOf(this.m_debug)));
            return true;
        }
        return super.setProperty(_ID, _args);
    }

    private final void setAuthidCookie(String cookieName, String encryptionKey) {
        String[] cookieString = new String[2];
        String key = encryptionKey;
        this.log(String.valueOf("Arguments: encryptionKey=").concat(String.valueOf(encryptionKey)));
        cookieString = this.bakeCookie(cookieName, key);
        this.log(String.valueOf("Generated databaseid Cookie String: ").concat(String.valueOf(cookieString[0])));
        this.log(String.valueOf("Generated lastuserid Cookie String: ").concat(String.valueOf(cookieString[1])));
        if (cookieString[0] != null && cookieString[0] != "" && this.isMSIE) {
            this.m_document.setMember("cookie", cookieString[0]);
            this.m_document.setMember("cookie", cookieString[1]);
            this.log("IE Cookie Set");
        } else if (cookieString[0] != null && cookieString[0] != "") {
            this.m_document.eval(String.valueOf(String.valueOf("document.cookie=\"").concat(String.valueOf(cookieString[0]))).concat(String.valueOf("\"")));
            this.m_document.eval(String.valueOf(String.valueOf("document.cookie=\"").concat(String.valueOf(cookieString[1]))).concat(String.valueOf("\"")));
            this.log("NS Cookie Set");
        } else {
            this.log("=============================");
            this.log("Cookie auth value returned empty! No cookie set.\n \nUse ADD_CONNECT_INFO in Forms to define connect information \nto be stored in the Reports auth cookie.\n");
            this.log("=============================");
        }
    }

    private final String[] bakeCookie(String cName, String encKey) {
        String cookieName = cName;
        String[] cookieString = new String[2];
        String[] cookieValue = new String[2];
        String encCookieValue = "";
        String cookieExpiry = "";
        try {
            try {
                cookieValue = this.getCookieValue();
                this.log(String.valueOf("Authentication Cookie value is: ").concat(String.valueOf(cookieValue[0].trim())));
                this.log(String.valueOf("Lastuserid cookie value is: ").concat(String.valueOf(cookieValue[1].trim())));
                encCookieValue = RwUtility.encrypt(encKey, cookieValue[0]);
                cookieString[0] = String.valueOf(String.valueOf(cookieName).concat(String.valueOf("="))).concat(String.valueOf(encCookieValue));
                cookieString[1] = String.valueOf("lastuserid=").concat(String.valueOf(RwUtility.encrypt(encKey, cookieValue[1])));
                this.log(String.valueOf("Complete databaseid cookie string is: ").concat(String.valueOf(cookieString[0])));
                this.log(String.valueOf("Complete lastuserid cookie string is: ").concat(String.valueOf(cookieString[1])));
                cookieExpiry = this.getExpiryString(this.cookieExpiryInDays);
                if (cookieExpiry != null && cookieExpiry.length() > 0) {
                    this.log(String.valueOf("Added expiry to expire on ").concat(String.valueOf(cookieExpiry)));
                    cookieString[0] = String.valueOf(cookieString[0]).concat(String.valueOf(String.valueOf("; ").concat(String.valueOf(cookieExpiry))));
                    cookieString[1] = String.valueOf(cookieString[1]).concat(String.valueOf(String.valueOf("; ").concat(String.valueOf(cookieExpiry))));
                }
                if (this.cookieDomain.length() > 0) {
                    cookieString[0] = String.valueOf(cookieString[0]).concat(String.valueOf(String.valueOf("; domain=").concat(String.valueOf(this.cookieDomain))));
                    cookieString[1] = String.valueOf(cookieString[1]).concat(String.valueOf(String.valueOf("; domain=").concat(String.valueOf(this.cookieDomain))));
                    this.log(String.valueOf(String.valueOf("Added domain \"").concat(String.valueOf(this.cookieDomain))).concat(String.valueOf("\" to cookies")));
                }
                if (this.cookiePath.length() > 0) {
                    cookieString[0] = String.valueOf(cookieString[0]).concat(String.valueOf(String.valueOf("; path=").concat(String.valueOf(this.cookiePath))));
                    cookieString[1] = String.valueOf(cookieString[1]).concat(String.valueOf(String.valueOf("; path=").concat(String.valueOf(this.cookiePath))));
                }
                String[] stringArray = cookieString;
                Object var10_10 = null;
                this.vConnects = new String("");
                return stringArray;
            }
            catch (Exception e) {
                this.log(String.valueOf("Could not encrypt and set authid cookie: ").concat(String.valueOf(e.getMessage())));
                this.dispatchErrors("Failure when encrypting authid cookie. No cookie set");
                Object var10_11 = null;
                this.vConnects = new String("");
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.vConnects = new String("");
            throw throwable;
        }
        return null;
    }

    private final void addAuthString(String cs) {
        StringTokenizer st = new StringTokenizer(cs.trim(), "/");
        if (st.countTokens() < 1 || st.countTokens() > 2) {
            this.log(String.valueOf("Not a valid argument in call to ADD_REPORTS_CONNECT: ").concat(String.valueOf(cs)));
            return;
        }
        this.vConnects = cs;
    }

    private final String[] getCookieValue() {
        String[] cs6i = new String[2];
        String currentTimeStr = "";
        Calendar cal = Calendar.getInstance();
        System.out.println(cal.getTime());
        currentTimeStr = new Long((cal.getTime().getTime() + this.timzoneAdjustment) / (long)1000).toString();
        cs6i[0] = String.valueOf(String.valueOf(this.vConnects).concat(String.valueOf(";"))).concat(String.valueOf(currentTimeStr));
        this.log(String.valueOf("cookie value returned by bakeCookie: ").concat(String.valueOf(cs6i[0])));
        String database = "";
        int indxOfAt = this.vConnects.indexOf(64);
        if (indxOfAt > -1) {
            database = this.vConnects.substring(indxOfAt);
        }
        cs6i[1] = String.valueOf(this.vConnects.substring(0, this.vConnects.indexOf(47))).concat(String.valueOf(database));
        this.log(String.valueOf("lastuserid cookie value is: ").concat(String.valueOf(cs6i[1])));
        return cs6i;
    }

    private final void setCookieDomain(String domain) {
        String cDomain = domain;
        int firstPeriodPos = 0;
        if (cDomain != null && !cDomain.equalsIgnoreCase("")) {
            this.log("Domain provided is not empty and is evaluated right now");
            firstPeriodPos = cDomain.indexOf(".");
            this.log(String.valueOf("First period found at ").concat(String.valueOf(firstPeriodPos)));
            if (firstPeriodPos >= 0) {
                if (cDomain.indexOf(".", firstPeriodPos + 1) == -1) {
                    this.log("Provided domain String is not valid (missing second period)");
                } else {
                    this.log(String.valueOf("Second period found at ").concat(String.valueOf(cDomain.indexOf(".", firstPeriodPos + 1))));
                    this.cookieDomain = cDomain;
                    this.log(String.valueOf("Cookie domain now is: ").concat(String.valueOf(cDomain)));
                }
            } else {
                this.log("Provided domain String is invalid valid. String syntax misses periods like in \".oracle.com\"");
            }
        } else {
            this.cookieDomain = "";
        }
    }

    private final String getExpiryString(int expiryInDays) {
        String cookieExpry = "";
        if (expiryInDays > 0) {
            this.log(String.valueOf(String.valueOf("Expiry in ").concat(String.valueOf(expiryInDays))).concat(String.valueOf(" days.")));
            Date today = new Date();
            long longToday = today.getTime();
            long longExpryOffset = expiryInDays * 1000 * 60 * 60 * 24;
            long expiryDateLong = longToday + longExpryOffset;
            this.log(String.valueOf("Expiry data in long: ").concat(String.valueOf(expiryDateLong)));
            Date expiryDate = new Date(expiryDateLong);
            SimpleDateFormat expireDateFormat = new SimpleDateFormat("EE, dd MMM yyyy hh:mm:ss");
            cookieExpry = this.isMSIE ? String.valueOf(String.valueOf("expires='").concat(String.valueOf(expireDateFormat.format(expiryDate)))).concat(String.valueOf(" UTC'")) : String.valueOf(String.valueOf(" expires='").concat(String.valueOf(expireDateFormat.format(expiryDate)))).concat(String.valueOf(" GMT'"));
        } else {
            cookieExpry = null;
        }
        return cookieExpry;
    }

    private final void dispatchErrors(String message) {
        this.log(message);
        try {
            CustomEvent ce = new CustomEvent((Object)this.m_handler, eRwAuthEvent);
            this.m_handler.setProperty(pRwAuthMessage, (Object)message);
            this.dispatchCustomEvent(ce);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void log(String msg) {
        if (this.m_debug) {
            System.out.println(String.valueOf(String.valueOf(this.CLASSNAME).concat(String.valueOf(": "))).concat(String.valueOf(msg)));
        }
    }
}

