/*
 * Decompiled with CFR 0.152.
 */
package oracle.reports.utility;

public class RwUtility {
    private static final int READ_BLOCK_SIZE = 8192;
    private static final char[] BASE64_CHR = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};
    private static final int BASE64_INVALID = 100;
    private static final int MAX_KEY_LEN = 256;
    private static final String DEFAULT_KEY = "Jasmine";

    public static int encodeBase64(boolean encode, byte[] ip, int ins, byte[] op) {
        int i;
        if (ins <= 0) {
            return ins;
        }
        if (encode) {
            int first = 0;
            int sec = 0;
            int third = 0;
            int fourth = 0;
            int left = ins;
            int cur = 0;
            int opsize = 0;
            while (left >= 3) {
                first = ip[cur] >>> 2 & 0x3F;
                sec = (ip[cur] & 3) << 4 | ip[cur + 1] >>> 4 & 0xF;
                third = (ip[cur + 1] & 0xF) << 2 | ip[cur + 2] >>> 6 & 3;
                fourth = ip[cur + 2] & 0x3F;
                op[opsize++] = (byte)BASE64_CHR[first];
                op[opsize++] = (byte)BASE64_CHR[sec];
                op[opsize++] = (byte)BASE64_CHR[third];
                op[opsize++] = (byte)BASE64_CHR[fourth];
                left -= 3;
                cur += 3;
            }
            if (left == 0) {
                op[opsize] = 0;
                return opsize;
            }
            if (left == 1) {
                first = ip[cur] >>> 2 & 0x3F;
                sec = (ip[cur] & 3) << 4;
                fourth = 64;
                third = 64;
            } else if (left == 2) {
                first = ip[cur] >>> 2 & 0x3F;
                sec = (ip[cur] & 3) << 4 | ip[cur + 1] >>> 4 & 0xF;
                third = (ip[cur + 1] & 0xF) << 2;
                fourth = 64;
            }
            op[opsize++] = (byte)BASE64_CHR[first];
            op[opsize++] = (byte)BASE64_CHR[sec];
            op[opsize++] = (byte)BASE64_CHR[third];
            op[opsize++] = (byte)BASE64_CHR[fourth];
            op[opsize] = 0;
            return opsize;
        }
        byte[] tmp = new byte[4];
        int left = ins;
        int cur = 0;
        int ops = 0;
        int posn = 0;
        byte[] val = new byte[4];
        while (left >= 4 && ip[cur + 3] != 61) {
            i = 0;
            while (i < 4) {
                val[i] = RwUtility.GetVal64(ip[cur]);
                if (val[i] == 100) {
                    return -1;
                }
                ++i;
                ++cur;
            }
            op[ops++] = (byte)(val[0] << 2 | val[1] >>> 4 & 0xF);
            op[ops++] = (byte)(val[1] << 4 | val[2] >>> 2 & 0x2F);
            op[ops++] = (byte)(val[2] << 6 | val[3]);
            left -= 4;
            if ((posn += 4) == 64) {
                posn = 0;
                while (RwUtility.GetVal64(ip[cur]) == 100) {
                    ++cur;
                    if (--left != 0) continue;
                    op[ops] = 0;
                    return ops;
                }
            }
            if (left != 0) continue;
            op[ops] = 0;
            return ops;
        }
        if (left < 4) {
            return -1;
        }
        if (ip[cur + 2] == 61) {
            i = 0;
            while (i < 2) {
                val[i] = RwUtility.GetVal64(ip[cur]);
                if (val[i] == 100) {
                    return -1;
                }
                ++i;
                ++cur;
            }
            op[ops++] = (byte)(val[0] << 2 | val[1] >>> 4 & 0xF);
        } else {
            i = 0;
            while (i < 3) {
                val[i] = RwUtility.GetVal64(ip[cur]);
                if (val[i] == 100) {
                    return -1;
                }
                ++i;
                ++cur;
            }
            op[ops++] = (byte)(val[0] << 2 | val[1] >>> 4 & 0xF);
            op[ops++] = (byte)(val[1] << 4 | val[2] >>> 2 & 0x3F);
        }
        op[ops] = 0;
        return ops;
    }

    private static byte GetVal64(byte alphabet) {
        if (alphabet >= 65 && alphabet <= 73) {
            return (byte)(alphabet - 65);
        }
        if (alphabet >= 74 && alphabet <= 82) {
            return (byte)(alphabet - 74 + 9);
        }
        if (alphabet >= 83 && alphabet <= 90) {
            return (byte)(alphabet - 83 + 18);
        }
        if (alphabet >= 97 && alphabet <= 105) {
            return (byte)(alphabet - 97 + 26);
        }
        if (alphabet >= 106 && alphabet <= 114) {
            return (byte)(alphabet - 106 + 35);
        }
        if (alphabet >= 115 && alphabet <= 122) {
            return (byte)(alphabet - 115 + 44);
        }
        if (alphabet >= 48 && alphabet <= 57) {
            return (byte)(alphabet - 48 + 52);
        }
        if (alphabet == 43) {
            return 62;
        }
        if (alphabet == 47) {
            return 63;
        }
        return 100;
    }

    public static void encryptMem(String keyText, byte[] inBuffer, int bufLen, byte[] outBuffer) {
        if (bufLen <= 0) {
            return;
        }
        Rc4Key key = new Rc4Key(keyText);
        RwUtility.enDecipher(key, inBuffer, bufLen, outBuffer);
    }

    public static String encrypt(String key, String buf) throws Exception {
        byte[] inBuf = buf.getBytes();
        byte[] outBuf = null;
        int size = 0;
        String retval = "";
        try {
            RwUtility.encryptMem(key, inBuf, inBuf.length, inBuf);
            outBuf = new byte[inBuf.length * 3 + 2];
            size = RwUtility.encodeBase64(true, inBuf, inBuf.length, outBuf);
            retval = new String(outBuf, 0, size);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return retval;
    }

    private static void enDecipher(Rc4Key key, byte[] inBuffer, int bufLen, byte[] outBuffer) {
        int ii = key.idxi;
        int jj = key.idxj;
        for (int sidx = 0; sidx < bufLen; ++sidx) {
            ii = (ii + 1) % 256;
            jj = (key.sbuf[ii] + jj) % 256;
            int tempchr = key.sbuf[ii];
            key.sbuf[ii] = key.sbuf[jj];
            key.sbuf[jj] = tempchr;
            int xoridx = (key.sbuf[ii] + key.sbuf[jj]) % 256;
            outBuffer[sidx] = (byte)(inBuffer[sidx] ^ (byte)key.sbuf[xoridx]);
        }
        key.idxi = ii;
        key.idxj = jj;
    }

    static /* synthetic */ int access$1000071() {
        return 256;
    }

    private static class Rc4Key {
        int[] sbuf = new int[RwUtility.access$1000071()];
        int sidx = 0;
        int idxi = 0;
        int idxj = 0;

        Rc4Key(String keyText) {
            int keyLen;
            if (keyText == null || keyText.length() == 0) {
                keyText = DEFAULT_KEY;
            }
            if ((keyLen = keyText.length()) > RwUtility.access$1000071()) {
                keyLen = RwUtility.access$1000071();
            }
            this.sidx = 0;
            while (this.sidx < RwUtility.access$1000071()) {
                this.sbuf[this.sidx] = this.sidx;
                ++this.sidx;
            }
            int idx1 = 0;
            int idx2 = 0;
            this.sidx = 0;
            while (this.sidx < RwUtility.access$1000071() && (idx2 = (idx2 + keyText.charAt(idx1) + this.sbuf[this.sidx]) % RwUtility.access$1000071()) >= 0) {
                int tempchr = this.sbuf[this.sidx];
                this.sbuf[this.sidx] = this.sbuf[idx2];
                this.sbuf[idx2] = tempchr;
                idx1 = (idx1 + 1) % keyLen;
                ++this.sidx;
            }
        }
    }
}

