<%@ taglib uri="http://java.sun.com/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jstl/fmt" prefix="fmt"%>

<!-- Include file to create the header section of all the sample pages
     v 1.1 drmills 
     Dependencies
     ============
       Style Sheet (linked by the enclosing page):
         blaf-en-ie-6.css
       Images:
         welcome.jpg
         return.gif
         wwv_help.gif
         c-ghtl.gif
         c-ght.gif
         c-ghtr.gif
         c-ghct.gif
         c-ghb.gif
         c-ghbr.gif
      String Resources for Link labels etc:
         view.resources.AppSampleResources.properties
     API
     ===
     The following parameters can be set in the c:import tag
         sampleTitle (required - Title to display for this sample)
         sampleHelpURL (required - URL to show the help screen for this sample)
         sampleContentAlignment (optional defaults to Center)
         sampleReturnURL (optional - if present a return to menu icon & link will be shown)
         sampleReturnLabel (optional override the default "menu" label for the return link)
         sampleReturnAltText (optional override the default alt text/title for the return icon)           
-->         

<!-- Define the String resources for the various labels and alt texts-->
<fmt:bundle basename="view.resources.AppSampleResources" prefix="header.">

<!-- Set up the content Alignment -->
<c:choose>
  <c:when test="${empty param.sampleContentAlignment}">
    <c:set var="contentAlignment" value="center"/>
  </c:when>
  <c:otherwise>
    <c:set var="contentAlignment" value="${param.sampleContentAlignment}"/>
  </c:otherwise>
</c:choose>

<!-- Set up Strings for the return icon and link if required -->
<c:if test="${not empty param.sampleReturnURL}">
  <c:choose>
    <c:when test="${not empty param.sampleReturnLabel}">
      <c:set var="menuLabel" value="${param.sampleReturnLabel}"/>
    </c:when>
    <c:otherwise>
      <c:set var="menuLabel">
        <fmt:message key='menu.label'/>
      </c:set>  
    </c:otherwise>
  </c:choose>
  <c:choose>
    <c:when test="${not empty param.sampleReturnAltText}">
      <c:set var="menuAltText" value="${param.sampleReturnAltText}"/> 
      <c:set var="menuTitle" value="${param.sampleReturnAltText}"/> 
    </c:when>
    <c:otherwise>
      <c:set var="menuAltText">
        <fmt:message key='menu.altText'/>
      </c:set>  
      <c:set var="menuTitle">
        <fmt:message key='menu.title'/>
      </c:set>        
    </c:otherwise>
  </c:choose>
</c:if>

<!-- Now the body of the header -->
<TABLE cellSpacing=0 cellPadding=0 width="100%" summary="" border=0>
  <TBODY>
  <TR>
    <TD vAlign=top rowSpan=2>
        <IMG src="appsample_files/10gwelcome.gif" 
             alt="<fmt:message key='welcome.altText'/>"
             title="<fmt:message key='welcome.title'/>"
             border=0 width="230" height="80">
        <IMG src="appsample_files/samples.gif" 
             alt="<fmt:message key='sample.altText'/>"
             title="<fmt:message key='sample.title'/>"
             width="113" height="33">
    </TD>
    <TD align=right>
      <TABLE cellSpacing=0 cellPadding=0 summary="" border=0>
        <TBODY>
        <TR>
          <TD vAlign=bottom>
            <TABLE cellSpacing=0 cellPadding=2 summary="" border=0>
              <TBODY>
              <TR>
                <c:if test="${not empty param.sampleReturnURL}">
                  <TD align="center">
                    <A href="<c:out value='${param.sampleReturnURL}'/>">
                    <IMG alt="<c:out value='${menuAltText}'/>"
                         title="<c:out value='${menuTitle}'/>"
                         src="appsample_files/return.gif" 
                         border=0 
                         width="32" 
                         height="32">
                    </A>
                  </TD> 
                </c:if>
                <TD align="center">
                  <A href="<c:out value='${param.sampleHelpURL}'/>">
                    <IMG src="appsample_files/wwv_help.gif" 
                         alt="<fmt:message key='help.altText'/>"
                         title="<fmt:message key='help.title'/>"
                         border=0 
                         width="32" 
                         height="32">
                  </A>
                </TD>
              </TR>
              <TR>
                <c:if test="${not empty param.sampleReturnURL}">
                  <TD align="center">
                    <A href="<c:out value='${param.sampleReturnURL}'/>">
                      <SPAN class=xp>
                        <c:out value="${menuLabel}"/>
                      </SPAN>
                    </A>
                  </TD>
                </c:if>
                <TD align="center">
                  <A href="<c:out value='${param.sampleHelpURL}'/>">
                    <SPAN class=xp>
                      <fmt:message key="help.label" />
                    </SPAN>
                  </A>
                </TD>
            </TR>
          </TBODY>
        </TABLE>
      </TD>
    </TR>
  </TBODY>
  </TABLE>
  </TD>
  </TR>
  <TR>
    <TD vAlign=bottom align=right>&nbsp;</TD>
    <TD>&nbsp; </TD>
  </TR>
  <TR>
    <TD width="100%" colSpan=3>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" summary="" border=0>
        <TBODY>
        <TR>
          <TD width=4 colSpan=4 height=4><IMG height=4 alt="" 
            src="appsample_files/c-ghtl.gif" width=4></TD>
          <TD colSpan=4>
            <TABLE cellSpacing=0 cellPadding=0 width="100%" summary="" 
            background=appsample_files/c-ght.gif border=0>
              <TBODY>
              <TR>
                <TD height=4></TD></TR></TBODY></TABLE></TD>
          <TD class=x1 vAlign=top rowSpan=2>
            <TABLE cellSpacing=0 cellPadding=0 width="100%" summary="" 
            background=appsample_files/c-ght.gif border=0>
              <TBODY>
              <TR>
                <TD height=4></TD></TR></TBODY></TABLE></TD>
          <TD width=4 colSpan=4 height=4><IMG height=4 alt="" 
            src="appsample_files/c-ghtr.gif" width=4></TD></TR>
        <TR>
          <TD class=x7 rowSpan=3></TD>
          <TD class=x6 rowSpan=3></TD>
          <TD class=x5 rowSpan=3></TD>
          <TD class=x1 rowSpan=3></TD>
          <TD class=x1 rowSpan=3>&nbsp; </TD>
          <TD class=x1 rowSpan=3></TD>
          <TD class=x1 rowSpan=2></TD>
          <TD class=x1 rowSpan=2><SPAN style="FONT-SIZE: 5pt">&nbsp;</SPAN></TD>
          <TD class=x1 rowSpan=2></TD>
          <TD class=x5 rowSpan=2></TD>
          <TD class=x6 rowSpan=2></TD>
          <TD class=x7 rowSpan=2></TD></TR>
        <TR>
          <TD class=x1 width="100%"></TD></TR>
        <TR>
          <TD vAlign=top><IMG height=20 alt="" 
            src="appsample_files/c-ghct.gif" width=25></TD>
          <TD vAlign=top colSpan=2 class="OraHeader">
            <TABLE cellSpacing=0 cellPadding=0 width="100%" summary="" 
            background=appsample_files/c-ghb.gif border=0>
              <TBODY>
                <TR>
                  <TD height=4></TD>
                </TR>
              </TBODY>
            </TABLE>
            <c:out value="${param.sampleTitle}"/>
          </TD>
          <TD vAlign=top colSpan=4><IMG height=20 alt="" 
            src="appsample_files/c-ghbr.gif" width=4></TD></TR>
   </TBODY></TABLE></TD></TR></TBODY></TABLE>
   </fmt:bundle>
<DIV>

<DIV></DIV>
  <DIV></DIV>
  <TABLE cellSpacing=0 cellPadding=0 width="100%" summary="" border=0>
    <TBODY> 
    <TR>
      <TD colSpan=3 align="center">&nbsp;</TD>
    </TR>

   <TR>
      <TD colSpan=3 align="<c:out value='${contentAlignment}'/>">
        <table border="0">
          <tr><td>