<%@ taglib uri="http://java.sun.com/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jstl/fmt" prefix="fmt"%>

<!-- Include file to create the header section of all the sample pages
     v 1.1 drmills 
     Dependencies
     ============
       Images:
         return.gif
      String Resources for Link labels etc:
         view.resources.AppSampleResources.properties
     API
     ===
     The following parameters can be set in the c:import tag
         helpTitle (required) - The title of this help page
         returnURL (required) - The page/url that called this help to return to
-->         

<!-- Define the String resources for the various labels and alt texts-->
<fmt:bundle basename="view.resources.AppSampleResources">

<!-- Now the body of the header -->
<TABLE cellSpacing=0 cellPadding=0 width="100%" border=0>
  <TR>
    <TD vAlign="bottom" >
      <h1>
       <c:out value="${param.helpTitle}"/>
      </h1>
    </TD>
    <TD align="right" vAlign="bottom">
      <h1>
        <A href="<c:out value='${param.returnURL}'/>"
        <IMG alt="<fmt:message key='help.graphic.altText'/>"
             title="<fmt:message key='help.graphic.title'/>"
             src="appsample_files/return.gif" 
             border=0 
             width="32" 
             height="32">
        </A>
      </h1>
    </TD>
    <TD vAlign="bottom">
      <h1>
        &nbsp;
      </h1>
    </TD>    
  </TR>
</TABLE>
 </fmt:bundle>
