package view;
import oracle.adf.controller.struts.actions.DataForwardAction;
import oracle.adf.controller.struts.actions.DataActionContext;
import oracle.adf.model.binding.DCUtil;
import oracle.jbo.uicli.binding.JUCtrlValueBindingRef;
import org.apache.struts.action.DynaActionForm;

public class MultiRowEditAction extends DataForwardAction 
{
  //The changes Flag
  private boolean mHasChanges = false;
  
  protected void processUpdateModel(DataActionContext actionContext)
  {
    DynaActionForm updateForm = (DynaActionForm)actionContext.getActionForm();
    UpdateRowBean[] updatedRows = (UpdateRowBean[])updateForm.get("Row");
    
    java.util.List origRows = (java.util.List)DCUtil.findSpelObject(
                                    actionContext.getBindingContainer(),
                                    "EmployeesView.rangeSet");
                                    
    for (int i=0;i<origRows.size();i++ ) 
    {
      String theRowKey = updatedRows[i].getRowKeyStr();
      
      JUCtrlValueBindingRef oldRow = (JUCtrlValueBindingRef)origRows.get(i);
      
      if (oldRow.get(JUCtrlValueBindingRef.RANGESET_ROW_KEY_STR).equals(theRowKey))
      {
       this.updateIfRequired(oldRow,"Salary",updatedRows[i].getSalary());
       this.updateIfRequired(oldRow,"CommissionPct",updatedRows[i].getCommissionPct());
      }
    }
  }
  
  protected void validateModelUpdates(DataActionContext actionContext)
  {
    if (isDirty())
    {
      actionContext.getBindingContainer().getDataControl().validate();
      setDirty(false);
    }
  }
  
  private void updateIfRequired(JUCtrlValueBindingRef baseRow, String attr, String newValue)
  {
    Object baseAttrValue = baseRow.get("attr");
    if ((baseAttrValue == null && (newValue == null||newValue.length() == 0))
        ||((baseAttrValue != null && baseAttrValue.equals(newValue))))
    {
        // no need to push the change
        return;
    }
    
    baseRow.put(attr, newValue);
    setDirty(true);
  }
  
  private void setDirty(boolean state)
  {
    mHasChanges = state;
  }
  
  private boolean isDirty()
  {
    return mHasChanges;
  }
  
  
}