-- Generated by Oracle SQL Developer Data Modeler 3.0.0.660.660
--   at:        2011-01-07 13:09:07 GMT
--   site:      Oracle Database 11g
--   type:      Oracle Database 11g



CREATE USER HR 
    IDENTIFIED BY  
    ACCOUNT UNLOCK 
;

CREATE USER OE 
    IDENTIFIED BY  
    PROFILE DEFAULT 
    ACCOUNT UNLOCK 
;

GRANT QUERY REWRITE, UNLIMITED TABLESPACE, CREATE SYNONYM, CREATE MATERIALIZED VIEW, CREATE DATABASE LINK, CREATE VIEW, CREATE SESSION TO OE 
;

CREATE USER SYS 
    IDENTIFIED BY  
    ACCOUNT UNLOCK 
;



CREATE OR REPLACE TYPE ACTIONS_T 
;
/




CREATE OR REPLACE TYPE ACTION_T 
;
/




CREATE OR REPLACE TYPE CATALOG_TYP 
;
/




CREATE OR REPLACE TYPE CATEGORY_TYP 
;
/




CREATE OR REPLACE TYPE COMPOSITE_CATEGORY_TYP 
;
/




CREATE OR REPLACE TYPE CORPORATE_CUSTOMER_TYP 
;
/




CREATE OR REPLACE TYPE CUSTOMER_TYP 
;
/




CREATE OR REPLACE TYPE CUST_ADDRESS_TYP 
;
/




CREATE OR REPLACE TYPE INVENTORY_TYP 
;
/




CREATE OR REPLACE TYPE LEAF_CATEGORY_TYP 
;
/




CREATE OR REPLACE TYPE LINEITEMS_T 
;
/




CREATE OR REPLACE TYPE LINEITEM_T 
;
/




CREATE OR REPLACE TYPE ORDER_ITEM_TYP 
;
/




CREATE OR REPLACE TYPE ORDER_TYP 
;
/




CREATE OR REPLACE TYPE PART_T 
;
/




CREATE OR REPLACE TYPE PRODUCT_INFORMATION_TYP 
;
/




CREATE OR REPLACE TYPE PURCHASEORDER_T 
;
/




CREATE OR REPLACE TYPE REJECTION_T 
;
/




CREATE OR REPLACE TYPE SHIPPING_INSTRUCTIONS_T 
;
/




CREATE OR REPLACE TYPE WAREHOUSE_TYP 
;
/




CREATE OR REPLACE TYPE ACTION_V 
    IS VARRAY ( 4 ) OF UNKNOWN 
;
/




CREATE OR REPLACE TYPE INVENTORY_LIST_TYP 
    IS TABLE OF UNKNOWN 
;
/




CREATE OR REPLACE TYPE LINEITEM_V 
    IS VARRAY ( 2147483647 ) OF UNKNOWN 
;
/




CREATE OR REPLACE TYPE ORDER_ITEM_LIST_TYP 
    IS TABLE OF UNKNOWN 
;
/




CREATE OR REPLACE TYPE ORDER_LIST_TYP 
    IS TABLE OF UNKNOWN 
;
/




CREATE OR REPLACE TYPE PHONE_LIST_TYP 
    IS VARRAY ( 5 ) OF UNKNOWN 
;
/




CREATE OR REPLACE TYPE PRODUCT_REF_LIST_TYP 
    IS TABLE OF UNKNOWN 
;
/




CREATE OR REPLACE TYPE SDO_ELEM_INFO_ARRAY 
    IS VARRAY ( 1048576 ) OF UNKNOWN 
;
/




CREATE OR REPLACE TYPE SDO_ORDINATE_ARRAY 
    IS VARRAY ( 1048576 ) OF UNKNOWN 
;
/




CREATE OR REPLACE TYPE SUBCATEGORY_REF_LIST_TYP 
    IS TABLE OF UNKNOWN 
;
/




CREATE OR REPLACE TYPE XDB$RAW_LIST_T 
    IS VARRAY ( 1000 ) OF UNKNOWN 
;
/




CREATE OR REPLACE TYPE ACTIONS_T 
    AS OBJECT 
    ( 
        SYS_XDBPD$ XDB$RAW_LIST_T , 
        ACTION ACTION_V 
    ) NOT FINAL 
;
/




CREATE OR REPLACE TYPE ACTION_T 
    AS OBJECT 
    ( 
        SYS_XDBPD$ XDB$RAW_LIST_T , 
        ACTIONED_BY VARCHAR2 (10) , 
        DATE_ACTIONED DATE 
    ) FINAL 
;
/




CREATE OR REPLACE TYPE CATALOG_TYP 
    UNDER COMPOSITE_CATEGORY_TYP ( 
        MEMBER FUNCTION GETCATALOGNAME 
        RETURN VARCHAR2 , 
        MEMBER FUNCTION CATEGORY_DESCRIBE 
        RETURN VARCHAR2 
    ) FINAL 
;
/



CREATE OR REPLACE TYPE BODY CATALOG_TYP 
    AS 
    MEMBER FUNCTION GETCATALOGNAME 
    RETURN VARCHAR 
    AS 
    BEGIN
    -- Return the category name from the supertype
    RETURN self.category_name;
  END; 
    MEMBER FUNCTION CATEGORY_DESCRIBE 
    RETURN VARCHAR 
    AS 
    BEGIN
    RETURN 'catalog_typ';
  END; 
    END 
;
/




CREATE OR REPLACE TYPE CATEGORY_TYP 
    AS OBJECT 
    ( 
        CATEGORY_NAME VARCHAR2 (50) , 
        CATEGORY_DESCRIPTION VARCHAR2 (1000) , 
        CATEGORY_ID NUMBER (2) , 
        PARENT_CATEGORY_ID NUMBER (2) , 
        MEMBER FUNCTION CATEGORY_DESCRIBE 
        RETURN VARCHAR2 
    ) NOT FINAL NOT INSTANTIABLE 
;
/



CREATE OR REPLACE TYPE BODY CATEGORY_TYP 
    AS 
    MEMBER FUNCTION CATEGORY_DESCRIBE 
    RETURN VARCHAR 
    AS 
    -- Empty PL/SQL Body 
    END 
;
/




CREATE OR REPLACE TYPE COMPOSITE_CATEGORY_TYP 
    UNDER CATEGORY_TYP ( 
        SUBCATEGORY_REF_LIST SUBCATEGORY_REF_LIST_TYP , 
        MEMBER FUNCTION CATEGORY_DESCRIBE 
        RETURN VARCHAR2 
    ) NOT FINAL 
;
/



CREATE OR REPLACE TYPE BODY COMPOSITE_CATEGORY_TYP 
    AS 
    MEMBER FUNCTION CATEGORY_DESCRIBE 
    RETURN VARCHAR 
    AS 
    BEGIN
      RETURN 'composite_category_typ';
    END;
    
    END 
;
/




CREATE OR REPLACE TYPE CORPORATE_CUSTOMER_TYP 
    UNDER CUSTOMER_TYP ( 
        ACCOUNT_MGR_ID NUMBER (6) 
    ) FINAL 
;
/




CREATE OR REPLACE TYPE CUSTOMER_TYP 
    AS OBJECT 
    ( 
        CUSTOMER_ID NUMBER (6) , 
        CUST_FIRST_NAME VARCHAR2 (20) , 
        CUST_LAST_NAME VARCHAR2 (20) , 
        CUST_ADDRESS CUST_ADDRESS_TYP , 
        PHONE_NUMBERS PHONE_LIST_TYP , 
        NLS_LANGUAGE VARCHAR2 (3) , 
        NLS_TERRITORY VARCHAR2 (30) , 
        CREDIT_LIMIT NUMBER (9,2) , 
        CUST_EMAIL VARCHAR2 (30) , 
        CUST_ORDERS ORDER_LIST_TYP 
    ) NOT FINAL 
;
/




CREATE OR REPLACE TYPE CUST_ADDRESS_TYP 
    AS OBJECT 
    ( 
        STREET_ADDRESS VARCHAR2 (40) , 
        POSTAL_CODE VARCHAR2 (10) , 
        CITY VARCHAR2 (30) , 
        STATE_PROVINCE VARCHAR2 (10) , 
        COUNTRY_ID CHAR (2) 
    ) FINAL 
;
/




CREATE OR REPLACE TYPE INVENTORY_TYP 
    AS OBJECT 
    ( 
        PRODUCT_ID NUMBER (6) , 
        WAREHOUSE WAREHOUSE_TYP , 
        QUANTITY_ON_HAND NUMBER (8) 
    ) FINAL 
;
/




CREATE OR REPLACE TYPE LEAF_CATEGORY_TYP 
    UNDER CATEGORY_TYP ( 
        PRODUCT_REF_LIST PRODUCT_REF_LIST_TYP , 
        MEMBER FUNCTION CATEGORY_DESCRIBE 
        RETURN VARCHAR2 
    ) FINAL 
;
/



CREATE OR REPLACE TYPE BODY LEAF_CATEGORY_TYP 
    AS 
    MEMBER FUNCTION CATEGORY_DESCRIBE 
    RETURN VARCHAR 
    AS 
    BEGIN
       RETURN  'leaf_category_typ';
    END;
    
    END 
;
/




CREATE OR REPLACE TYPE LINEITEMS_T 
    AS OBJECT 
    ( 
        SYS_XDBPD$ XDB$RAW_LIST_T , 
        LINEITEM LINEITEM_V 
    ) NOT FINAL 
;
/




CREATE OR REPLACE TYPE LINEITEM_T 
    AS OBJECT 
    ( 
        SYS_XDBPD$ XDB$RAW_LIST_T , 
        ITEMNUMBER NUMBER (38) , 
        DESCRIPTION VARCHAR2 (256) , 
        PART PART_T 
    ) NOT FINAL 
;
/




CREATE OR REPLACE TYPE ORDER_ITEM_TYP 
    AS OBJECT 
    ( 
        ORDER_ID NUMBER (12) , 
        LINE_ITEM_ID NUMBER (3) , 
        UNIT_PRICE NUMBER (8,2) , 
        QUANTITY NUMBER (8) , 
        PRODUCT_REF REF PRODUCT_INFORMATION_TYP 
    ) FINAL 
;
/




CREATE OR REPLACE TYPE ORDER_TYP 
    AS OBJECT 
    ( 
        ORDER_ID NUMBER (12) , 
        ORDER_MODE VARCHAR2 (8) , 
        CUSTOMER_REF REF CUSTOMER_TYP , 
        ORDER_STATUS NUMBER (2) , 
        ORDER_TOTAL NUMBER (8,2) , 
        SALES_REP_ID NUMBER (6) , 
        ORDER_ITEM_LIST ORDER_ITEM_LIST_TYP 
    ) FINAL 
;
/




CREATE OR REPLACE TYPE PART_T 
    AS OBJECT 
    ( 
        SYS_XDBPD$ XDB$RAW_LIST_T , 
        PART_NUMBER VARCHAR2 (14) , 
        QUANTITY NUMBER (8,4) , 
        UNITPRICE NUMBER (12,2) 
    ) NOT FINAL 
;
/




CREATE OR REPLACE TYPE PRODUCT_INFORMATION_TYP 
    AS OBJECT 
    ( 
        PRODUCT_ID NUMBER (6) , 
        PRODUCT_NAME VARCHAR2 (50) , 
        PRODUCT_DESCRIPTION VARCHAR2 (2000) , 
        CATEGORY_ID NUMBER (2) , 
        WEIGHT_CLASS NUMBER (1) , 
        WARRANTY_PERIOD INTERVAL YEAR TO MONTH , 
        SUPPLIER_ID NUMBER (6) , 
        PRODUCT_STATUS VARCHAR2 (20) , 
        LIST_PRICE NUMBER (8,2) , 
        MIN_PRICE NUMBER (8,2) , 
        CATALOG_URL VARCHAR2 (50) , 
        INVENTORY_LIST INVENTORY_LIST_TYP 
    ) FINAL 
;
/




CREATE OR REPLACE TYPE PURCHASEORDER_T 
    AS OBJECT 
    ( 
        SYS_XDBPD$ XDB$RAW_LIST_T , 
        REFERENCE VARCHAR2 (30) , 
        ACTIONS ACTIONS_T , 
        REJECTION REJECTION_T , 
        REQUESTOR VARCHAR2 (128) , 
        USERID VARCHAR2 (10) , 
        COST_CENTER VARCHAR2 (4) , 
        SHIPPING_INSTRUCTIONS SHIPPING_INSTRUCTIONS_T , 
        SPECIAL_INSTRUCTIONS VARCHAR2 (2048) , 
        LINEITEMS LINEITEMS_T 
    ) NOT FINAL 
;
/




CREATE OR REPLACE TYPE REJECTION_T 
    AS OBJECT 
    ( 
        SYS_XDBPD$ XDB$RAW_LIST_T , 
        REJECTED_BY VARCHAR2 (10) , 
        DATE_REJECTED DATE , 
        REASON_REJECTED VARCHAR2 (2048) 
    ) NOT FINAL 
;
/




CREATE OR REPLACE TYPE SHIPPING_INSTRUCTIONS_T 
    AS OBJECT 
    ( 
        SYS_XDBPD$ XDB$RAW_LIST_T , 
        SHIP_TO_NAME VARCHAR2 (20) , 
        SHIP_TO_ADDRESS VARCHAR2 (256) , 
        SHIP_TO_PHONE VARCHAR2 (24) 
    ) NOT FINAL 
;
/




CREATE OR REPLACE TYPE WAREHOUSE_TYP 
    AS OBJECT 
    ( 
        WAREHOUSE_ID NUMBER (3) , 
        WAREHOUSE_NAME VARCHAR2 (35) , 
        LOCATION_ID NUMBER (4) 
    ) FINAL 
;
/


CREATE TABLE OE.CATEGORIES_TAB 
    OF CATEGORY_TYP 
    SUBSTITUTABLE AT ALL LEVELS 
    ( 
    CONSTRAINT SYS_C005389 PRIMARY KEY ( CATEGORY_ID ) 
    ) 
    OBJECT IDENTIFIER IS PRIMARY KEY LOGGING 
;




CREATE TABLE OE.CUSTOMERS 
    ( 
     CUSTOMER_ID NUMBER (6)  NOT NULL , 
     CUST_FIRST_NAME VARCHAR2 (20 BYTE)  NOT NULL , 
     CUST_LAST_NAME VARCHAR2 (20 BYTE)  NOT NULL , 
     CUST_ADDRESS CUST_ADDRESS_TYP , 
     PHONE_NUMBERS PHONE_LIST_TYP , 
     NLS_LANGUAGE VARCHAR2 (3 BYTE) , 
     NLS_TERRITORY VARCHAR2 (30 BYTE) , 
     CREDIT_LIMIT NUMBER (9,2) , 
     CUST_EMAIL VARCHAR2 (30 BYTE) , 
     ACCOUNT_MGR_ID NUMBER (6) , 
     CUST_GEO_LOCATION DECIMAL , 
     DATE_OF_BIRTH DATE , 
     MARITAL_STATUS VARCHAR2 (20 BYTE) , 
     GENDER VARCHAR2 (1 BYTE) , 
     INCOME_LEVEL VARCHAR2 (20 BYTE) 
    ) LOGGING 
;



ALTER TABLE OE.CUSTOMERS 
    ADD CONSTRAINT CUSTOMER_ID_MIN 
    CHECK ( customer_id > 0) 
;


ALTER TABLE OE.CUSTOMERS 
    ADD CONSTRAINT CUSTOMER_CREDIT_LIMIT_MAX 
    CHECK ( credit_limit <= 5000) 
;


COMMENT ON COLUMN OE.CUSTOMERS.CUSTOMER_ID IS 'Primary key column.' 
;

COMMENT ON COLUMN OE.CUSTOMERS.CUST_FIRST_NAME IS 'NOT NULL constraint.' 
;

COMMENT ON COLUMN OE.CUSTOMERS.CUST_LAST_NAME IS 'NOT NULL constraint.' 
;

COMMENT ON COLUMN OE.CUSTOMERS.CUST_ADDRESS IS 'Object column of type address_typ.' 
;

COMMENT ON COLUMN OE.CUSTOMERS.PHONE_NUMBERS IS 'Varray column of type phone_list_typ' 
;

COMMENT ON COLUMN OE.CUSTOMERS.CREDIT_LIMIT IS 'Check constraint.' 
;

COMMENT ON COLUMN OE.CUSTOMERS.ACCOUNT_MGR_ID IS 'References hr.employees.employee_id.' 
;

COMMENT ON COLUMN OE.CUSTOMERS.CUST_GEO_LOCATION IS 'SDO (spatial) column.' 
;
CREATE INDEX OE.CUST_UPPER_NAME_IX ON OE.CUSTOMERS 
    ( 
     UPPER("CUST_LAST_NAME"),UPPER("CUST_FIRST_NAME")
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;
CREATE INDEX OE.CUST_ACCOUNT_MANAGER_IX ON OE.CUSTOMERS 
    ( 
     ACCOUNT_MGR_ID ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;
CREATE INDEX OE.CUST_LNAME_IX ON OE.CUSTOMERS 
    ( 
     CUST_LAST_NAME ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;
CREATE INDEX OE.CUST_EMAIL_IX ON OE.CUSTOMERS 
    ( 
     CUST_EMAIL ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;

ALTER TABLE OE.CUSTOMERS 
    ADD CONSTRAINT CUSTOMERS_PK PRIMARY KEY ( CUSTOMER_ID ) ;


CREATE TABLE OE.INVENTORIES 
    ( 
     PRODUCT_ID NUMBER (6)  NOT NULL , 
     WAREHOUSE_ID NUMBER (3)  NOT NULL , 
     QUANTITY_ON_HAND NUMBER (8)  NOT NULL 
    ) LOGGING 
;



COMMENT ON COLUMN OE.INVENTORIES.PRODUCT_ID IS 'Part of concatenated primary key, references product_information.product_id.' 
;

COMMENT ON COLUMN OE.INVENTORIES.WAREHOUSE_ID IS 'Part of concatenated primary key, references warehouses.warehouse_id.' 
;
CREATE INDEX OE.INVENTORY_IX ON OE.INVENTORIES 
    ( 
     WAREHOUSE_ID ASC , 
     PRODUCT_ID ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;
CREATE INDEX OE.INV_PRODUCT_IX ON OE.INVENTORIES 
    ( 
     PRODUCT_ID ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;

ALTER TABLE OE.INVENTORIES 
    ADD CONSTRAINT INVENTORY_PK PRIMARY KEY ( PRODUCT_ID, WAREHOUSE_ID ) ;


CREATE TABLE OE.ORDERS 
    ( 
     ORDER_ID NUMBER (12)  NOT NULL , 
     ORDER_DATE TIMESTAMP WITH LOCAL TIME ZONE  NOT NULL , 
     ORDER_MODE VARCHAR2 (8 BYTE) , 
     CUSTOMER_ID NUMBER (6)  NOT NULL , 
     ORDER_STATUS NUMBER (2) , 
     ORDER_TOTAL NUMBER (8,2) , 
     SALES_REP_ID NUMBER (6) , 
     PROMOTION_ID NUMBER (6) 
    ) LOGGING 
;



ALTER TABLE OE.ORDERS 
    ADD CONSTRAINT ORDER_MODE_LOV 
    CHECK ( order_mode in ('direct','online')) 
;


ALTER TABLE OE.ORDERS 
    ADD CONSTRAINT ORDER_TOTAL_MIN 
    CHECK ( order_total >= 0) 
;


COMMENT ON COLUMN OE.ORDERS.ORDER_ID IS 'PRIMARY KEY column.' 
;

COMMENT ON COLUMN OE.ORDERS.ORDER_DATE IS 'TIMESTAMP WITH LOCAL TIME ZONE column, NOT NULL constraint.' 
;

COMMENT ON COLUMN OE.ORDERS.ORDER_MODE IS 'CHECK constraint.' 
;

COMMENT ON COLUMN OE.ORDERS.ORDER_STATUS IS '0: Not fully entered, 1: Entered, 2: Canceled - bad credit, -
3: Canceled - by customer, 4: Shipped - whole order, -
5: Shipped - replacement items, 6: Shipped - backlog on items, -
7: Shipped - special delivery, 8: Shipped - billed, 9: Shipped - payment plan,-
10: Shipped - paid' 
;

COMMENT ON COLUMN OE.ORDERS.ORDER_TOTAL IS 'CHECK constraint.' 
;

COMMENT ON COLUMN OE.ORDERS.SALES_REP_ID IS 'References hr.employees.employee_id.' 
;

COMMENT ON COLUMN OE.ORDERS.PROMOTION_ID IS 'Sales promotion ID. Used in SH schema' 
;
CREATE INDEX OE.ORD_SALES_REP_IX ON OE.ORDERS 
    ( 
     SALES_REP_ID ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;
CREATE INDEX OE.ORD_CUSTOMER_IX ON OE.ORDERS 
    ( 
     CUSTOMER_ID ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;
CREATE INDEX OE.ORD_ORDER_DATE_IX ON OE.ORDERS 
    ( 
     ORDER_DATE ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;

ALTER TABLE OE.ORDERS 
    ADD CONSTRAINT ORDER_PK PRIMARY KEY ( ORDER_ID ) ;


CREATE TABLE OE.ORDER_ITEMS 
    ( 
     ORDER_ID NUMBER (12)  NOT NULL , 
     LINE_ITEM_ID NUMBER (3)  NOT NULL , 
     PRODUCT_ID NUMBER (6)  NOT NULL , 
     UNIT_PRICE NUMBER (8,2) , 
     QUANTITY NUMBER (8) 
    ) LOGGING 
;



COMMENT ON COLUMN OE.ORDER_ITEMS.ORDER_ID IS 'Part of concatenated primary key, references orders.order_id.' 
;

COMMENT ON COLUMN OE.ORDER_ITEMS.LINE_ITEM_ID IS 'Part of concatenated primary key.' 
;

COMMENT ON COLUMN OE.ORDER_ITEMS.PRODUCT_ID IS 'References product_information.product_id.' 
;
CREATE UNIQUE INDEX OE.ORDER_ITEMS_UK ON OE.ORDER_ITEMS 
    ( 
     ORDER_ID ASC , 
     PRODUCT_ID ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;
CREATE INDEX OE.ITEM_ORDER_IX ON OE.ORDER_ITEMS 
    ( 
     ORDER_ID ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;
CREATE INDEX OE.ITEM_PRODUCT_IX ON OE.ORDER_ITEMS 
    ( 
     PRODUCT_ID ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;

ALTER TABLE OE.ORDER_ITEMS 
    ADD CONSTRAINT ORDER_ITEMS_PK PRIMARY KEY ( ORDER_ID, LINE_ITEM_ID ) ;


CREATE TABLE OE.PRODUCT_DESCRIPTIONS 
    ( 
     PRODUCT_ID NUMBER (6)  NOT NULL , 
     LANGUAGE_ID VARCHAR2 (3 BYTE)  NOT NULL , 
     TRANSLATED_NAME NVARCHAR2 (50)  NOT NULL , 
     TRANSLATED_DESCRIPTION NVARCHAR2 (2000)  NOT NULL 
    ) LOGGING 
;



COMMENT ON COLUMN OE.PRODUCT_DESCRIPTIONS.PRODUCT_ID IS 'Primary key column.' 
;

COMMENT ON COLUMN OE.PRODUCT_DESCRIPTIONS.LANGUAGE_ID IS 'Primary key column.' 
;
CREATE UNIQUE INDEX OE.PRD_DESC_PK ON OE.PRODUCT_DESCRIPTIONS 
    ( 
     PRODUCT_ID ASC , 
     LANGUAGE_ID ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;
CREATE INDEX OE.PROD_NAME_IX ON OE.PRODUCT_DESCRIPTIONS 
    ( 
     TRANSLATED_NAME ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;

ALTER TABLE OE.PRODUCT_DESCRIPTIONS 
    ADD CONSTRAINT PRODUCT_DESCRIPTIONS_PK PRIMARY KEY ( PRODUCT_ID, LANGUAGE_ID ) ;


CREATE TABLE OE.PRODUCT_INFORMATION 
    ( 
     PRODUCT_ID NUMBER (6)  NOT NULL , 
     PRODUCT_NAME VARCHAR2 (50 BYTE) , 
     PRODUCT_DESCRIPTION VARCHAR2 (2000 BYTE) , 
     CATEGORY_ID NUMBER (2) , 
     WEIGHT_CLASS NUMBER (1) , 
     WARRANTY_PERIOD INTERVAL YEAR TO MONTH , 
     SUPPLIER_ID NUMBER (6) , 
     PRODUCT_STATUS VARCHAR2 (20 BYTE) , 
     LIST_PRICE NUMBER (8,2) , 
     MIN_PRICE NUMBER (8,2) , 
     CATALOG_URL VARCHAR2 (50 BYTE) 
    ) LOGGING 
;



ALTER TABLE OE.PRODUCT_INFORMATION 
    ADD CONSTRAINT PRODUCT_STATUS_LOV 
    CHECK ( product_status in ('orderable'
                                                  ,'planned'
                                                  ,'under development'
                                                  ,'obsolete')) 
;


COMMENT ON COLUMN OE.PRODUCT_INFORMATION.PRODUCT_ID IS 'Primary key column.' 
;

COMMENT ON COLUMN OE.PRODUCT_INFORMATION.PRODUCT_DESCRIPTION IS 'Primary language description corresponding to translated_description in
oe.product_descriptions, added to provide non-NLS text columns for OC views
to accss.' 
;

COMMENT ON COLUMN OE.PRODUCT_INFORMATION.CATEGORY_ID IS 'Low cardinality column, can be used for bitmap index.
Schema SH uses it as foreign key' 
;

COMMENT ON COLUMN OE.PRODUCT_INFORMATION.WEIGHT_CLASS IS 'Low cardinality column, can be used for bitmap index.' 
;

COMMENT ON COLUMN OE.PRODUCT_INFORMATION.WARRANTY_PERIOD IS 'INTERVAL YEAER TO MONTH column, low cardinality, can be used for bitmap
index.' 
;

COMMENT ON COLUMN OE.PRODUCT_INFORMATION.SUPPLIER_ID IS 'Offers possibility of extensions outside Common Schema.' 
;

COMMENT ON COLUMN OE.PRODUCT_INFORMATION.PRODUCT_STATUS IS 'Check constraint. Appropriate for complex rules, such as &quot;All products in
status PRODUCTION must have at least one inventory entry.&quot; Also appropriate
for a trigger auditing status change.' 
;
CREATE INDEX OE.PROD_SUPPLIER_IX ON OE.PRODUCT_INFORMATION 
    ( 
     SUPPLIER_ID ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;

ALTER TABLE OE.PRODUCT_INFORMATION 
    ADD CONSTRAINT PRODUCT_INFORMATION_PK PRIMARY KEY ( PRODUCT_ID ) ;


CREATE TABLE OE.PROMOTIONS 
    ( 
     PROMO_ID NUMBER (6)  NOT NULL , 
     PROMO_NAME VARCHAR2 (20 BYTE) 
    ) LOGGING 
;



ALTER TABLE OE.PROMOTIONS 
    ADD CONSTRAINT PROMO_ID_PK PRIMARY KEY ( PROMO_ID ) ;


CREATE TABLE OE.PURCHASEORDER 
    
    ) LOGGING 
;



ALTER TABLE OE.PURCHASEORDER 
    ADD CONSTRAINT Oid_PK_PURCHASEORDER PRIMARY KEY ( Oid ) ;


CREATE TABLE OE.WAREHOUSES 
    ( 
     WAREHOUSE_ID NUMBER (3)  NOT NULL , 
     WAREHOUSE_SPEC XMLTYPE , 
     WAREHOUSE_NAME VARCHAR2 (35 BYTE) , 
     LOCATION_ID NUMBER (4) , 
     WH_GEO_LOCATION DECIMAL 
    ) LOGGING 
    XMLTYPE WAREHOUSE_SPEC STORE AS CLOB 
    ( 
        STORAGE ( 
            PCTINCREASE 0 
            MINEXTENTS 1 
            MAXEXTENTS UNLIMITED 
            FREELISTS 1 
            BUFFER_POOL DEFAULT 
        ) 
        RETENTION 
        ENABLE STORAGE IN ROW
        CACHE 
    ) 
;



COMMENT ON COLUMN OE.WAREHOUSES.WAREHOUSE_ID IS 'Primary key column.' 
;

COMMENT ON COLUMN OE.WAREHOUSES.WH_GEO_LOCATION IS 'Primary key column, references hr.locations.location_id.' 
;
CREATE INDEX OE.WHS_LOCATION_IX ON OE.WAREHOUSES 
    ( 
     LOCATION_ID ASC 
    ) 
    LOGGING 
    NOCOMPRESS 
    NOPARALLEL 
;

ALTER TABLE OE.WAREHOUSES 
    ADD CONSTRAINT WAREHOUSES_PK PRIMARY KEY ( WAREHOUSE_ID ) ;



ALTER TABLE OE.INVENTORIES 
    ADD CONSTRAINT INVENTORIES_PRODUCT_ID_FK FOREIGN KEY 
    ( 
     PRODUCT_ID
    ) 
    REFERENCES OE.PRODUCT_INFORMATION 
    ( 
     PRODUCT_ID
    ) 
    NOT DEFERRABLE 
;


ALTER TABLE OE.INVENTORIES 
    ADD CONSTRAINT INVENTORIES_WAREHOUSES_FK FOREIGN KEY 
    ( 
     WAREHOUSE_ID
    ) 
    REFERENCES OE.WAREHOUSES 
    ( 
     WAREHOUSE_ID
    ) 
    NOT DEFERRABLE 
;


ALTER TABLE OE.ORDERS 
    ADD CONSTRAINT ORDERS_CUSTOMER_ID_FK FOREIGN KEY 
    ( 
     CUSTOMER_ID
    ) 
    REFERENCES OE.CUSTOMERS 
    ( 
     CUSTOMER_ID
    ) 
    ON DELETE SET NULL 
    NOT DEFERRABLE 
;


ALTER TABLE OE.ORDER_ITEMS 
    ADD CONSTRAINT ORDER_ITEMS_ORDER_ID_FK FOREIGN KEY 
    ( 
     ORDER_ID
    ) 
    REFERENCES OE.ORDERS 
    ( 
     ORDER_ID
    ) 
    ON DELETE CASCADE 
    NOT DEFERRABLE 
;


ALTER TABLE OE.ORDER_ITEMS 
    ADD CONSTRAINT ORDER_ITEMS_PRODUCT_ID_FK FOREIGN KEY 
    ( 
     PRODUCT_ID
    ) 
    REFERENCES OE.PRODUCT_INFORMATION 
    ( 
     PRODUCT_ID
    ) 
    NOT DEFERRABLE 
;


ALTER TABLE OE.PRODUCT_DESCRIPTIONS 
    ADD CONSTRAINT PD_PRODUCT_ID_FK FOREIGN KEY 
    ( 
     PRODUCT_ID
    ) 
    REFERENCES OE.PRODUCT_INFORMATION 
    ( 
     PRODUCT_ID
    ) 
    NOT DEFERRABLE 
;

CREATE OR REPLACE VIEW OE.ACCOUNT_MANAGERS AS 
SELECT          c.account_mgr_id                ACCT_MGR,
                cr.region_id                    REGION,
                c.cust_address.country_id       COUNTRY,
                c.cust_address.state_province   PROVINCE,
                count(*)                        NUM_CUSTOMERS
FROM            customers c, countries cr
WHERE           c.cust_address.country_id = cr.country_id
GROUP BY ROLLUP (c.account_mgr_id,
                 cr.region_id,
                 c.cust_address.country_id,
                 c.cust_address.state_province) ;



CREATE OR REPLACE VIEW OE.BOMBAY_INVENTORY AS 
SELECT p.product_id
,      p.product_name
,      i.quantity_on_hand
FROM   inventories i
,      warehouses  w
,      products    p
WHERE  p.product_id = i.product_id
AND    i.warehouse_id = w.warehouse_id
AND    w.warehouse_name = 'Bombay' ;



CREATE OR REPLACE VIEW OE.CUSTOMERS_VIEW AS 
SELECT
  c.customer_id,
  c.cust_first_name,
  c.cust_last_name,
  c.cust_address.street_address street_address,
  c.cust_address.postal_code postal_code,
  c.cust_address.city city,
  c.cust_address.state_province state_province,
  co.country_id,
  co.country_name,
  co.region_id,
  c.nls_language,
  c.nls_territory,
  c.credit_limit,
  c.cust_email,
  substr(get_phone_number_f(1,phone_numbers),1,25) Primary_Phone_number,
  substr(get_phone_number_f(2,phone_numbers),1,25) Phone_number_2,
  substr(get_phone_number_f(3,phone_numbers),1,25) Phone_number_3,
  substr(get_phone_number_f(4,phone_numbers),1,25) Phone_number_4,
  substr(get_phone_number_f(5,phone_numbers),1,25) Phone_number_5,
  c.account_mgr_id,
  c.cust_geo_location.sdo_gtype location_gtype,
  c.cust_geo_location.sdo_srid location_srid,
  c.cust_geo_location.sdo_point.x location_x,
  c.cust_geo_location.sdo_point.y location_y,
  c.cust_geo_location.sdo_point.z location_z
FROM
  countries co,
  customers c
WHERE
  c.cust_address.country_id = co.country_id(+) ;



CREATE OR REPLACE VIEW OE.OC_CUSTOMERS 
 OF CUSTOMER_TYP WITH OBJECT IDENTIFIER ( customer_id ) ( CUSTOMER_ID,
    CUST_FIRST_NAME,
    CUST_LAST_NAME,
    CUST_ADDRESS,
    PHONE_NUMBERS,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    CREDIT_LIMIT,
    CUST_EMAIL,
    CUST_ORDERS )
 AS SELECT
    CUSTOMER_ID CUSTOMER_ID,
    CUST_FIRST_NAME CUST_FIRST_NAME,
    CUST_LAST_NAME CUST_LAST_NAME,
    CUST_ADDRESS CUST_ADDRESS,
    PHONE_NUMBERS PHONE_NUMBERS,
    NLS_LANGUAGE NLS_LANGUAGE,
    NLS_TERRITORY NLS_TERRITORY,
    CREDIT_LIMIT CREDIT_LIMIT,
    CUST_EMAIL CUST_EMAIL,
    CUST_ORDERS CUST_ORDERS ;



CREATE OR REPLACE VIEW OE.OC_INVENTORIES 
 OF INVENTORY_TYP WITH OBJECT IDENTIFIER ( product_id ) ( PRODUCT_ID,
    WAREHOUSE,
    QUANTITY_ON_HAND )
 AS SELECT
    PRODUCT_ID PRODUCT_ID,
    WAREHOUSE WAREHOUSE,
    QUANTITY_ON_HAND QUANTITY_ON_HAND ;



CREATE OR REPLACE VIEW OE.OC_ORDERS 
 OF ORDER_TYP WITH OBJECT IDENTIFIER ( order_id ) ( ORDER_ID,
    ORDER_MODE,
    CUSTOMER_REF,
    ORDER_STATUS,
    ORDER_TOTAL,
    SALES_REP_ID,
    ORDER_ITEM_LIST )
 AS SELECT
    ORDER_ID ORDER_ID,
    ORDER_MODE ORDER_MODE,
    CUSTOMER_REF CUSTOMER_REF,
    ORDER_STATUS ORDER_STATUS,
    ORDER_TOTAL ORDER_TOTAL,
    SALES_REP_ID SALES_REP_ID,
    ORDER_ITEM_LIST ORDER_ITEM_LIST ;



CREATE OR REPLACE VIEW OE.OC_PRODUCT_INFORMATION 
 OF PRODUCT_INFORMATION_TYP WITH OBJECT IDENTIFIER ( product_id ) ( PRODUCT_ID,
    PRODUCT_NAME,
    PRODUCT_DESCRIPTION,
    CATEGORY_ID,
    WEIGHT_CLASS,
    WARRANTY_PERIOD,
    SUPPLIER_ID,
    PRODUCT_STATUS,
    LIST_PRICE,
    MIN_PRICE,
    CATALOG_URL,
    INVENTORY_LIST )
 AS SELECT
    PRODUCT_ID PRODUCT_ID,
    PRODUCT_NAME PRODUCT_NAME,
    PRODUCT_DESCRIPTION PRODUCT_DESCRIPTION,
    CATEGORY_ID CATEGORY_ID,
    WEIGHT_CLASS WEIGHT_CLASS,
    WARRANTY_PERIOD WARRANTY_PERIOD,
    SUPPLIER_ID SUPPLIER_ID,
    PRODUCT_STATUS PRODUCT_STATUS,
    LIST_PRICE LIST_PRICE,
    MIN_PRICE MIN_PRICE,
    CATALOG_URL CATALOG_URL,
    INVENTORY_LIST INVENTORY_LIST ;



CREATE OR REPLACE VIEW OE.ORDERS_VIEW AS 
SELECT
  order_id,
  TO_DATE(TO_CHAR(order_date,'DD-MON-YY HH:MI:SS'),'DD-MON-YY HH:MI:SS') ORDER_DATE,
  order_mode,
  customer_id,
  order_status,
  order_total,
  sales_rep_id,
  promotion_id
FROM orders ;



CREATE OR REPLACE VIEW OE.PRODUCTS AS 
SELECT i.product_id
,      d.language_id
,      CASE WHEN d.language_id IS NOT NULL
            THEN d.translated_name
            ELSE TRANSLATE(i.product_name USING NCHAR_CS)
       END    AS product_name
,      i.category_id
,      CASE WHEN d.language_id IS NOT NULL
            THEN d.translated_description
            ELSE TRANSLATE(i.product_description USING NCHAR_CS)
       END    AS product_description
,      i.weight_class
,      i.warranty_period
,      i.supplier_id
,      i.product_status
,      i.list_price
,      i.min_price
,      i.catalog_url
FROM   product_information  i
,      product_descriptions d
WHERE  d.product_id  (+) = i.product_id
AND    d.language_id (+) = sys_context('USERENV','LANG') ;



CREATE OR REPLACE VIEW OE.PRODUCT_PRICES AS 
SELECT category_id
,      COUNT(*)        as "#_OF_PRODUCTS"
,      MIN(list_price) as low_price
,      MAX(list_price) as high_price
FROM   product_information
GROUP BY category_id ;



CREATE OR REPLACE VIEW OE.SYDNEY_INVENTORY AS 
SELECT p.product_id
,      p.product_name
,      i.quantity_on_hand
FROM   inventories i
,      warehouses  w
,      products    p
WHERE  p.product_id = i.product_id
AND    i.warehouse_id = w.warehouse_id
AND    w.warehouse_name = 'Sydney' ;



CREATE OR REPLACE VIEW OE.TORONTO_INVENTORY AS 
SELECT p.product_id
,      p.product_name
,      i.quantity_on_hand
FROM   inventories i
,      warehouses  w
,      products    p
WHERE  p.product_id = i.product_id
AND    i.warehouse_id = w.warehouse_id
AND    w.warehouse_name = 'Toronto' ;



CREATE OR REPLACE VIEW OE.OC_CORPORATE_CUSTOMERS 
 OF CORPORATE_CUSTOMER_TYP UNDER OE.OC_CUSTOMERS ( CUSTOMER_ID,
    CUST_FIRST_NAME,
    CUST_LAST_NAME,
    CUST_ADDRESS,
    PHONE_NUMBERS,
    NLS_LANGUAGE,
    NLS_TERRITORY,
    CREDIT_LIMIT,
    CUST_EMAIL,
    CUST_ORDERS,
    ACCOUNT_MGR_ID )
 AS SELECT
    CUSTOMER_ID CUSTOMER_ID,
    CUST_FIRST_NAME CUST_FIRST_NAME,
    CUST_LAST_NAME CUST_LAST_NAME,
    CUST_ADDRESS CUST_ADDRESS,
    PHONE_NUMBERS PHONE_NUMBERS,
    NLS_LANGUAGE NLS_LANGUAGE,
    NLS_TERRITORY NLS_TERRITORY,
    CREDIT_LIMIT CREDIT_LIMIT,
    CUST_EMAIL CUST_EMAIL,
    CUST_ORDERS CUST_ORDERS,
    ACCOUNT_MGR_ID ACCOUNT_MGR_ID ;



CREATE SEQUENCE OE.ORDERS_SEQ 
    INCREMENT BY 1 
    MAXVALUE 9999999999999999999999999999 
    MINVALUE 1 
    NOCACHE 
;

CREATE SYNONYM OE.COUNTRIES 
FOR HR.COUNTRIES
;
CREATE SYNONYM OE.DEPARTMENTS 
FOR HR.DEPARTMENTS
;
CREATE SYNONYM OE.EMPLOYEES 
FOR HR.EMPLOYEES
;
CREATE SYNONYM OE.JOBS 
FOR HR.JOBS
;
CREATE SYNONYM OE.JOB_HISTORY 
FOR HR.JOB_HISTORY
;
CREATE SYNONYM OE.LOCATIONS 
FOR HR.LOCATIONS
;
CREATE OR REPLACE TRIGGER OE.INSERT_ORD_LINE 
    BEFORE INSERT ON OE.ORDER_ITEMS 
    FOR EACH ROW 
DECLARE
    new_line number;
  BEGIN
    SELECT (NVL(MAX(line_item_id),0)+1) INTO new_line
      FROM order_items
      WHERE order_id = :new.order_id;
    :new.line_item_id := new_line;
  END; 
/


CREATE OR REPLACE TRIGGER OE.PURCHASEORDER$xd 
    AFTER UPDATE OR DELETE ON OE.PURCHASEORDER 
    FOR EACH ROW 
BEGIN  IF (deleting) THEN xdb.xdb_pitrig_pkg.pitrig_del('OE','PURCHASEORDER', :old.sys_nc_oid$, '9B7F4EF578894592B5E48A3BC249FB5F' ); END IF;   IF (updating) THEN xdb.xdb_pitrig_pkg.pitrig_upd('OE','PURCHASEORDER', :old.sys_nc_oid$, '9B7F4EF578894592B5E48A3BC249FB5F', user ); END IF; END; 
/



CREATE OR REPLACE FUNCTION OE.get_phone_number_f
  (p_in INTEGER, p_phonelist phone_list_typ)
RETURN VARCHAR2 AS
  TYPE phone_list IS VARRAY(5) OF VARCHAR2(25);
  phone_out varchar2(25) := null;
  v_size INTEGER;
BEGIN
    IF p_phonelist.FIRST IS NULL OR
       p_in > (p_phonelist.LAST + 1) - p_phonelist.FIRST THEN
      RETURN phone_out;
    ELSE
      phone_out := p_phonelist(p_in);
      RETURN phone_out;
    END IF;
END;
/

























-- Oracle SQL Developer Data Modeler Summary Report: 
-- 
-- CREATE TABLE                            10
-- CREATE INDEX                            16
-- ALTER TABLE                             20
-- CREATE VIEW                             13
-- CREATE PACKAGE                           0
-- CREATE PACKAGE BODY                      0
-- CREATE PROCEDURE                         0
-- CREATE FUNCTION                          1
-- CREATE TRIGGER                           2
-- CREATE STRUCTURED TYPE                  20
-- CREATE COLLECTION TYPE                  11
-- CREATE CLUSTER                           0
-- CREATE CONTEXT                           0
-- CREATE DATABASE                          0
-- CREATE DIMENSION                         0
-- CREATE DIRECTORY                         0
-- CREATE DISK GROUP                        0
-- CREATE ROLE                              0
-- CREATE ROLLBACK SEGMENT                  0
-- CREATE SEQUENCE                          1
-- CREATE MATERIALIZED VIEW                 0
-- CREATE SYNONYM                           6
-- CREATE TABLESPACE                        0
-- CREATE USER                              3
-- 
-- DROP TABLESPACE                          0
-- DROP DATABASE                            0
-- 
-- ERRORS                                   0
-- WARNINGS                                 0
