-- Generated by Oracle SQL Developer Data Modeler Version: 2.0.0 Build: 570
--   at:        2009-06-29 12:10:00
--   site:      Oracle Database 11g
--   type:      Oracle Database 11g





CREATE OR REPLACE TYPE CUST_ADDRESS_TYP 
;
/




CREATE OR REPLACE TYPE PHONE_LIST_TYP 
    IS VARRAY ( 5 ) OF VARCHAR2 (25) 
;



CREATE OR REPLACE TYPE CUST_ADDRESS_TYP 
    AS OBJECT 
    ( 
        CITY VARCHAR2 (30) , 
        POSTAL_CODE VARCHAR2 (10) , 
        COUNTRY_ID CHAR (2) , 
        STATE_PROVINCE VARCHAR2 (10) , 
        STREET_ADDRESS VARCHAR2 (40) 
    ) FINAL 
;
/


CREATE TABLE CATEGORIES 
    ( 
     CATEGORY_NAME VARCHAR2 (50 BYTE) , 
     CATEGORY_DESCRIPTION VARCHAR2 (1000 BYTE) , 
     CATEGORY_ID NUMBER (2)  NOT NULL 
    ) 
;



ALTER TABLE CATEGORIES 
    ADD CONSTRAINT CATEGORIES_PK1 PRIMARY KEY ( CATEGORY_ID ) ;


CREATE TABLE CUSTOMERS 
    ( 
     CUSTOMER_ID NUMBER (6)  NOT NULL , 
     CUST_FIRST_NAME VARCHAR2 (20 BYTE)  NOT NULL , 
     CUST_LAST_NAME VARCHAR2 (20 BYTE)  NOT NULL , 
     CUST_ADDRESS CUST_ADDRESS_TYP , 
     PHONE_NUMBERS PHONE_LIST_TYP , 
     NLS_LANGUAGE VARCHAR2 (3 BYTE) , 
     NLS_TERRITORY VARCHAR2 (30 BYTE) , 
     CREDIT_LIMIT NUMBER (9,2) , 
     CUST_EMAIL VARCHAR2 (30 BYTE) , 
     ACCOUNT_MGR_ID NUMBER (6) , 
     CUST_GEO_LOCATION MDSYS.SDO_GEOMETRY , 
     DATE_OF_BIRTH DATE , 
     MARITAL_STATUS VARCHAR2 (20 BYTE) , 
     GENDER VARCHAR2 (1 BYTE) , 
     INCOME_LEVEL VARCHAR2 (20 BYTE) 
    ) 
;


CREATE INDEX CUST_LNAME_IX ON CUSTOMERS 
    ( 
     CUST_LAST_NAME ASC 
    ) 
;
CREATE INDEX CUST_ACCOUNT_MANAGER_IX ON CUSTOMERS 
    ( 
     ACCOUNT_MGR_ID ASC 
    ) 
;
CREATE INDEX CUST_UPPER_NAME_IX ON CUSTOMERS 
    ( 
     UPPER("CUST_LAST_NAME"),UPPER("CUST_FIRST_NAME")
    ) 
;
CREATE INDEX CUST_EMAIL_IX ON CUSTOMERS 
    ( 
     CUST_EMAIL ASC 
    ) 
;

ALTER TABLE CUSTOMERS 
    ADD CONSTRAINT CUSTOMERS_PK PRIMARY KEY ( CUSTOMER_ID ) ;


CREATE TABLE INVENTORIES 
    ( 
     PRODUCT_ID NUMBER (6)  NOT NULL , 
     WAREHOUSE_ID NUMBER (3)  NOT NULL , 
     QUANTITY_ON_HAND NUMBER (8)  NOT NULL 
    ) 
;


CREATE INDEX INV_WAREHOUSE_IX ON INVENTORIES 
    ( 
     WAREHOUSE_ID ASC 
    ) 
;
CREATE INDEX INV_PRODUCT_IX ON INVENTORIES 
    ( 
     PRODUCT_ID ASC 
    ) 
;

ALTER TABLE INVENTORIES 
    ADD CONSTRAINT INVENTORY_PK PRIMARY KEY ( PRODUCT_ID, WAREHOUSE_ID ) ;


CREATE TABLE ORDERS 
    ( 
     ORDER_ID NUMBER (12)  NOT NULL , 
     ORDER_DATE TIMESTAMP WITH LOCAL TIME ZONE  NOT NULL , 
     ORDER_MODE VARCHAR2 (8 BYTE) , 
     CUSTOMER_ID NUMBER (6)  NOT NULL , 
     ORDER_STATUS NUMBER (2) , 
     ORDER_TOTAL NUMBER (8,2) , 
     SALES_REP_ID NUMBER (6) , 
     PROMOTION_ID NUMBER (6) 
    ) 
;


CREATE INDEX ORD_ORDER_DATE_IX ON ORDERS 
    ( 
     ORDER_DATE ASC 
    ) 
;
CREATE INDEX ORD_CUSTOMER_IX ON ORDERS 
    ( 
     CUSTOMER_ID ASC 
    ) 
;
CREATE INDEX ORD_SALES_REP_IX ON ORDERS 
    ( 
     SALES_REP_ID ASC 
    ) 
;

ALTER TABLE ORDERS 
    ADD CONSTRAINT ORDER_PK PRIMARY KEY ( ORDER_ID ) ;


CREATE TABLE ORDER_ITEMS 
    ( 
     ORDER_ID NUMBER (12)  NOT NULL , 
     LINE_ITEM_ID NUMBER (3)  NOT NULL , 
     PRODUCT_ID NUMBER (6)  NOT NULL , 
     UNIT_PRICE NUMBER (8,2) , 
     QUANTITY NUMBER (8) 
    ) 
;


CREATE UNIQUE INDEX ORDER_ITEMS_UK ON ORDER_ITEMS 
    ( 
     ORDER_ID ASC , 
     PRODUCT_ID ASC 
    ) 
;
CREATE INDEX ITEM_PRODUCT_IX ON ORDER_ITEMS 
    ( 
     PRODUCT_ID ASC 
    ) 
;
CREATE INDEX ITEM_ORDER_IX ON ORDER_ITEMS 
    ( 
     ORDER_ID ASC 
    ) 
;

ALTER TABLE ORDER_ITEMS 
    ADD CONSTRAINT ORDER_ITEMS_PK PRIMARY KEY ( ORDER_ID, LINE_ITEM_ID ) ;


CREATE TABLE PRODUCT_DESCRIPTIONS 
    ( 
     PRODUCT_ID NUMBER (6)  NOT NULL , 
     LANGUAGE_ID VARCHAR2 (3 BYTE)  NOT NULL , 
     TRANSLATED_NAME NVARCHAR2 (50)  NOT NULL , 
     TRANSLATED_DESCRIPTION NVARCHAR2 (2000)  NOT NULL 
    ) 
;


CREATE UNIQUE INDEX PRD_DESC_PK ON PRODUCT_DESCRIPTIONS 
    ( 
     PRODUCT_ID ASC , 
     LANGUAGE_ID ASC 
    ) 
;
CREATE INDEX PROD_NAME_IX ON PRODUCT_DESCRIPTIONS 
    ( 
     TRANSLATED_NAME ASC 
    ) 
;

ALTER TABLE PRODUCT_DESCRIPTIONS 
    ADD CONSTRAINT PRODUCT_DESCRIPTIONS_PK PRIMARY KEY ( PRODUCT_ID, LANGUAGE_ID ) ;


CREATE TABLE PRODUCT_INFORMATION 
    ( 
     PRODUCT_ID NUMBER (6)  NOT NULL , 
     PRODUCT_NAME VARCHAR2 (50 BYTE) , 
     PRODUCT_DESCRIPTION VARCHAR2 (2000 BYTE) , 
     CATEGORY_ID NUMBER (2) , 
     WEIGHT_CLASS NUMBER (1) , 
     WARRANTY_PERIOD INTERVAL YEAR TO MONTH , 
     SUPPLIER_ID NUMBER (6) , 
     PRODUCT_STATUS VARCHAR2 (20 BYTE) , 
     LIST_PRICE NUMBER (8,2) , 
     MIN_PRICE NUMBER (8,2) , 
     CATALOG_URL VARCHAR2 (50 BYTE) 
    ) 
;


CREATE INDEX PROD_SUPPLIER_IX ON PRODUCT_INFORMATION 
    ( 
     SUPPLIER_ID ASC 
    ) 
;

ALTER TABLE PRODUCT_INFORMATION 
    ADD CONSTRAINT PRODUCT_INFORMATION_PK PRIMARY KEY ( PRODUCT_ID ) ;


CREATE TABLE WAREHOUSES 
    ( 
     WAREHOUSE_ID NUMBER (3)  NOT NULL , 
     WAREHOUSE_SPEC XMLTYPE , 
     WAREHOUSE_NAME VARCHAR2 (35 BYTE) , 
     LOCATION_ID NUMBER (4) , 
     WH_GEO_LOCATION MDSYS.SDO_GEOMETRY 
    ) 
;


CREATE INDEX WHS_LOCATION_IX ON WAREHOUSES 
    ( 
     LOCATION_ID ASC 
    ) 
;

ALTER TABLE WAREHOUSES 
    ADD CONSTRAINT WAREHOUSES_PK PRIMARY KEY ( WAREHOUSE_ID ) ;



ALTER TABLE INVENTORIES 
    ADD CONSTRAINT INVENTORIES_PRODUCT_ID_FK FOREIGN KEY 
    ( 
     PRODUCT_ID
    ) 
    REFERENCES PRODUCT_INFORMATION 
    ( 
     PRODUCT_ID
    ) 
;


ALTER TABLE INVENTORIES 
    ADD CONSTRAINT INVENTORIES_WAREHOUSES_FK FOREIGN KEY 
    ( 
     WAREHOUSE_ID
    ) 
    REFERENCES WAREHOUSES 
    ( 
     WAREHOUSE_ID
    ) 
;


ALTER TABLE ORDERS 
    ADD CONSTRAINT ORDERS_CUSTOMER_ID_FK FOREIGN KEY 
    ( 
     CUSTOMER_ID
    ) 
    REFERENCES CUSTOMERS 
    ( 
     CUSTOMER_ID
    ) 
    ON DELETE SET NULL 
;


ALTER TABLE ORDER_ITEMS 
    ADD CONSTRAINT ORDER_ITEMS_ORDER_ID_FK FOREIGN KEY 
    ( 
     ORDER_ID
    ) 
    REFERENCES ORDERS 
    ( 
     ORDER_ID
    ) 
    ON DELETE CASCADE 
;


ALTER TABLE ORDER_ITEMS 
    ADD CONSTRAINT ORDER_ITEMS_PRODUCT_ID_FK FOREIGN KEY 
    ( 
     PRODUCT_ID
    ) 
    REFERENCES PRODUCT_INFORMATION 
    ( 
     PRODUCT_ID
    ) 
;


ALTER TABLE PRODUCT_INFORMATION 
    ADD CONSTRAINT PRODUCT_INFO_CATEGORY_FK FOREIGN KEY 
    ( 
     CATEGORY_ID
    ) 
    REFERENCES CATEGORIES 
    ( 
     CATEGORY_ID
    ) 
;

CREATE OR REPLACE VIEW BOMBAY_INVENTORY
AS 
SELECT p.product_id
,      p.product_name
,      i.quantity_on_hand
FROM   inventories i
,      warehouses  w
,      products    p   
WHERE  p.product_id = i.product_id
AND    i.warehouse_id = w.warehouse_id
AND    w.warehouse_name = 'Bombay' ;

CREATE OR REPLACE VIEW PRODUCTS
AS 
SELECT i.product_id
,      d.language_id
,      CASE WHEN d.language_id IS NOT NULL
            THEN d.translated_name
            ELSE TRANSLATE(i.product_name USING NCHAR_CS)
       END    AS product_name
,      i.category_id
,      CASE WHEN d.language_id IS NOT NULL
            THEN d.translated_description
            ELSE TRANSLATE(i.product_description USING NCHAR_CS)
       END    AS product_description
,      i.weight_class
,      i.warranty_period
,      i.supplier_id
,      i.product_status
,      i.list_price
,      i.min_price
,      i.catalog_url
FROM   product_information  i
,      product_descriptions d
WHERE  d.product_id  (+) = i.product_id
AND    d.language_id (+) = sys_context('USERENV','LANG') ;

CREATE OR REPLACE VIEW PRODUCT_PRICES
AS 
SELECT category_id
,      COUNT(*)        as "#_OF_PRODUCTS"
,      MIN(list_price) as low_price
,      MAX(list_price) as high_price
FROM   product_information
GROUP BY category_id ;

CREATE OR REPLACE VIEW SYDNEY_INVENTORY
AS 
SELECT p.product_id
,      p.product_name
,      i.quantity_on_hand
FROM   inventories i
,      warehouses  w
,      products    p  
WHERE  p.product_id = i.product_id
AND    i.warehouse_id = w.warehouse_id
AND    w.warehouse_name = 'Sydney' ;

CREATE OR REPLACE VIEW TORONTO_INVENTORY
AS 
SELECT p.product_id
,      p.product_name
,      i.quantity_on_hand
FROM   inventories i
,      warehouses  w
,      products    p
WHERE  p.product_id = i.product_id
AND    i.warehouse_id = w.warehouse_id
AND    w.warehouse_name = 'Toronto' ;


    
    
    
    
    
    
    
    

-- Oracle SQL Developer Data Modeler Summary Report: 
-- 
-- CREATE TABLE                             8
-- CREATE INDEX                            16
-- ALTER TABLE                              6
-- CREATE VIEW                              5
-- CREATE PROCEDURE                         0
-- CREATE TRIGGER                           0
-- CREATE STRUCTURED TYPE                   1
-- CREATE COLLECTION TYPE                   1
-- CREATE CLUSTER                           0
-- CREATE CONTEXT                           0
-- CREATE DATABASE                          0
-- CREATE DIMENSION                         0
-- CREATE DIRECTORY                         0
-- CREATE DISK GROUP                        0
-- CREATE ROLE                              0
-- CREATE ROLLBACK SEGMENT                  0
-- CREATE SEQUENCE                          0
-- CREATE SNAPSHOT                          0
-- CREATE SYNONYM                           0
-- CREATE TABLESPACE                        0
-- CREATE USER                              0
-- 
-- DROP TABLESPACE                          0
-- DROP DATABASE                            0
-- 
-- ERRORS                                   0
-- WARNINGS                                 0
