package wlsejb;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class WLSSessionFacadeClientACICF {
    public static void main(String [] args) {
        try {
            final Context ctx = getInitialContext();
            WLSSessionFacade wLSSessionFacade = (WLSSessionFacade) ctx.lookup("WLSSessionFacade#wlsejb.WLSSessionFacade");
            // Call any of the Remote methods below to access the EJB
            System.out.println( wLSSessionFacade.getAppServer1(  ) );
            System.out.println( wLSSessionFacade.getAppServer2(  ) );
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static Context getInitialContext() throws NamingException {
        Hashtable env = new Hashtable();
        // WebLogic Server 9.x connection details
        // Make sure a library containing 'weblogic.jar' has been defined and added to your project
        env.put( Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory" );
        env.put( Context.SECURITY_PRINCIPAL, "weblogic" );
        env.put( Context.SECURITY_CREDENTIALS, "weblogic" );
        env.put(Context.PROVIDER_URL, "t3://localhost:7001");
        return new InitialContext( env );
    }
}
