package com.bea.iot.sh;

/**
 * @author sgioia Stefano Gioia (sgioia@bea.com)
 * @version 1.0
 */

public class Constants {
	// Use it for get/set from HttpSession
	public static final String USER_NAME 				= "userName";
	public static final String SERVICE_INDICATION 		= "serviceIndication";
	public static final String SERVICE_VALUE 			= "serviceValue";
	public static final String SERVICE_DATA 			= "serviceData";
	public static final String SERVER_NAME 				= "serverName";
	public static final String DOMAIN_TYPE 				= "domainType";
	public static final String REQUEST_TYPE 			= "requestType";
	public static final String DIAMETER_RESULT_CODE 	= "diameterRc";
	public static final String NEXT_PAGE 				= "nextPage";
	public static final String HSS_RESPONSE 			= "hssResponse";
	public static final String SIPAS_OUTPUT 			= "sipAsOutput";
	public static final String DOC_SELECTOR 			= "docSelector";
	public static final String SAVE						= "saveData";
	
	// Data Type
	public static final int SH_REPOSITORY_DATA 			= 0;
	public static final int SH_IMS_PUBLIC_IDENTITY 		= 10;
	public static final int SH_IMS_USER_STATE 			= 11;
	public static final int SH_S_CSCF_NAME 				= 12;
	public static final int SH_INITIAL_FILTER_CRITERIA 	= 13;
	public static final int SH_LOCATION_INFO 			= 14;
	public static final int SH_USER_STATE 				= 15;
	public static final int SH_CHARGING_INFO 			= 16;
	public static final int SH_MSISDN					= 17;
	
	// Circuit/Packet Domain
	public static final int SH_PS_DOMAIN				= 0;
	public static final int SH_CS_DOMAIN				= 1;
	
	public static final String IOT_SH_SERVER_NAME		= "serverName";
	public static final String IOT_SH_SERVICE_NAME		= "serviceIndication";
	
	// Used in IOT Test. Use in the Sessions
	public static final String IOT_SH_PULL_REPOSITORY_DATA			= "IOTRP";
	public static final String IOT_SH_PULL_PUBLIC_IDENTITY			= "IOTPI";
	public static final String IOT_SH_PULL_IMS_USER_STATE			= "IOTIMSUS";
	public static final String IOT_SH_PULL_S_CSCF_NAME				= "IOTSCSCF";
	public static final String IOT_SH_PULL_INITIAL_FILTER_CRITERIA	= "IOTIFC";
	public static final String IOT_SH_PULL_CHARGING_INFO			= "IOTCI";
	public static final String IOT_SH_PULL_MSISDN					= "IOTMSIDN";
	public static final String IOT_SH_PULL_USER_STATE				= "IOTUS";
	public static final String IOT_SH_PULL_LOCATION_INFO			= "IOTLI";
	
	public static final String IOT_MSG_SUBSCRIBE					= "SUBSCRIBE";
	public static final String IOT_MSG_UN_SUBSCRIBE					= "UNSUBSCRIBE";
	

}