package com.bea.iot.sh;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import com.bea.wcp.profile.ProfileService;
import org.apache.log4j.Logger;

public class DiameterBaseServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;
	
	protected ProfileService ps;
	protected SipFactory theSipFactory;
	
    protected String 	serviceIndication,
    					serverName,
    					userName,
    					requestType,
    					serviceData,
    					serviceValue;
    protected int domainType = -1;
    protected HttpSession httpSession = null;
    
    protected static Logger logger = Logger.getLogger(DiameterBaseServlet.class.getName());
	
    /**
	 * Generic Init method where ProfileService will be initialized
	 */
	 public void init() throws ServletException 
	 {
	    ServletContext sc = getServletContext();
	    theSipFactory = (SipFactory) getServletContext().getAttribute(SipServlet.SIP_FACTORY);
	    
	    ps = (ProfileService) sc.getAttribute(ProfileService.PROFILE_SERVICE);
	    if (ps == null) {
	    	logger.debug("Profile service not found");
	    	throw new ServletException("Profile service not found");
	    }
	    if (theSipFactory == null) {
	    	logger.debug("The SIPFactory is null");
	    	throw new ServletException("The SIPFactory is null");
	    }
	    serverName 	= getServletContext().getInitParameter(Constants.IOT_SH_SERVER_NAME);
	    serviceIndication = getServletContext().getInitParameter(Constants.IOT_SH_SERVICE_NAME);
	    
	    logger.debug("Using serverName=" + serverName + ", and serviceName=" + serviceIndication);
	 }
	
	/**
	 * Simply redirect to doget()
	 * 
	 * @param req The Http Request
	 * @param res The Http Response
	 */
	protected void doPost(HttpServletRequest arg0, HttpServletResponse arg1) 
										throws ServletException, IOException 
	{
		this.doGet(arg0, arg1);
	}
			
	/**
	 * 
	 * @param req The HTTPServletRequest
	 */ 
	protected void getDataFromTheRequest(HttpServletRequest req)
	{
		// Get the session object fro mthe request
		httpSession = req.getSession();
		// Setting attribute
		httpSession.setAttribute(Constants.USER_NAME, req.getParameter(Constants.USER_NAME));
		// Eventually the service name
		serviceIndication = req.getParameter(Constants.SERVICE_INDICATION);
		// Eventually the serverName for Initial Filter Criteria
		serverName = req.getParameter(Constants.SERVER_NAME); 
		// Eventually the domainType (Circuit/Packet)
		try 
		{
			domainType = Integer.parseInt(req.getParameter(Constants.DOMAIN_TYPE)); 
		} catch (NumberFormatException nfe ) {
			logger.error("Parameter " + Constants.DOMAIN_TYPE + " was not found in the request." 
						+ "Using default value: 1");
			domainType = 1;
		}
		
			//	Get the Username
		userName = req.getParameter(Constants.USER_NAME);
		// Get the requested type
		requestType = req.getParameter(Constants.REQUEST_TYPE);
		serviceData = req.getParameter(Constants.SERVICE_DATA);
		serviceValue = req.getParameter(Constants.SERVICE_VALUE);
		
		logger.debug( "\n-----------[ BEGIN DEBUG PARAMS FROM REQUEST ]------------"
					  + "\n  serviceName: " + serviceIndication
					  + "\n  serverName: " + serverName
					  + "\n  domainType: " + domainType
					  + "\n  userName: " + userName
					  + "\n  requestType: " + requestType
					  + "\n  serviceData: " + serviceData
					  + "\n  serviceValue: " + serviceValue 
					  + "\n----------------------------------------------------------");	
	}
	

}