package com.bea.iot.sh;

/**
 * @author sgioia Stefano Gioia (sgioia@bea.com)
 * @version 1.0
 */

import java.io.StringWriter;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class DiameterHelper {
	
	private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
	static Logger logger = Logger.getLogger(DiameterHelper.class.getName());
	
	/**
	 * 
	 * @param requestType the type of request based on Diameter Sh Specs
	 * @param userName the username 
	 * @param ServiceName the service name (eventually...)
	 * @param domainType CS or PS domain (eventually...)
	 * @param serverName the server name of Initial Filter Criteria (eventually...)
	 * @return the Sh String request
	 */
	public static String buildShRequest(int requestType, String userName, 
										String ServiceName, int domainType,
										String serverName )
	  {
		  
		  logger.debug("Building Sh String request with the following params: RequestType:" + requestType
				  				+ ", UserName:" + userName
				  				+ ", ServiceName:" + ServiceName
				  				+ ", ServerName:" + serverName
				  				+ ", domainType:" + domainType);
		  
		  String docSelector = "sh://";
		  // Adding the userName
		  docSelector += userName;
		  
		  switch(requestType)
		  {
			  case Constants.SH_REPOSITORY_DATA:
				  docSelector += "/RepositoryData/" + ServiceName;
				  break;
			  case Constants.SH_MSISDN:
				  docSelector += "/MSISDN/";
				  break;
			  case Constants.SH_IMS_PUBLIC_IDENTITY:
				  docSelector += "/IMSPublicIdentity/";
				  break;
			  case Constants.SH_CHARGING_INFO:
				  docSelector += "/ChargingInformation/";
				  break;
			  case Constants.SH_USER_STATE:
				  docSelector += (domainType == Constants.SH_PS_DOMAIN)? "/UserState/PS-Domain/":"/UserState/CS-Domain/";
				  break;
			  case Constants.SH_IMS_USER_STATE:
				  docSelector += "/IMSUserState/";
				  break;
			  case Constants.SH_S_CSCF_NAME:
				  docSelector += "/S-CSCFName/";
				  break;
			  case Constants.SH_INITIAL_FILTER_CRITERIA:
				  docSelector += "/InitialFilterCriteria/" + serverName;
				  break;
			  case Constants.SH_LOCATION_INFO:
				  docSelector += (domainType == Constants.SH_PS_DOMAIN)? "/LocationInformation/PS-Domain/":"/LocationInformation/CS-Domain/";
				  break;  
		  }
		  logger.debug("Selected Data Reference Type: " + docSelector);
		  return docSelector;
	  }
	
	
	  /**
	   * 
	   * @return
	   * @throws TransformerException
	   */
	  public static Transformer newTransformer() throws TransformerException 
	  {
	    synchronized (TRANSFORMER_FACTORY) 
	    {
	      Transformer t = TRANSFORMER_FACTORY.newTransformer();
	      t.setOutputProperty("indent", "yes");
	      return t;
	    }
	  }
	  
	 /**
	  * 
	  * @param node
	  * @return
	  * @throws TransformerException
	  */
	  public static String toString(Node node) throws TransformerException 
	  {
	    StringWriter sw = new StringWriter();
	    newTransformer().transform(new DOMSource(node), new StreamResult(sw));
	    return sw.toString();
	  }

}