package com.bea.iot.sh;

import java.io.StringWriter;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {

	
	private static final TransformerFactory TRANSFORMER_FACTORY =
		 TransformerFactory.newInstance();
	  
	 /**
	  * 
	  * @param node
	  * @return
	  * @throws TransformerException
	  */
	  public static String toString(Node node) throws TransformerException {
	    StringWriter sw = new StringWriter();
	    newTransformer().transform(new DOMSource(node), new StreamResult(sw));
	    return sw.toString();
	  }
	  
	  /**
	   * 
	   * @return A transformer
	   * @throws TransformerException
	   */
	  public static Transformer newTransformer() throws TransformerException {
		    synchronized (TRANSFORMER_FACTORY) {
		      Transformer t = TRANSFORMER_FACTORY.newTransformer();
		      t.setOutputProperty("indent", "yes");
		      return t;
		    }
		  }
	
	
	  /**
	   * 
	   * @param doc
	   * @param name
	   * @param value
	   * @return
	   */
	  public static Element createTextElement(Document doc, String name, String value) 
	  {
	    Element e = doc.createElement(name);
	    Node n = doc.createTextNode(value);
	    e.appendChild(n);
	    return e;
	  }
	  

	 static  public class RepDataWrapper {
	    Document doc;
	    private int sequenceNumber;
	    private boolean increment;

	    public RepDataWrapper(Document doc) {
	      this.doc = doc;
	      String serviceIndication = getTextValue("ServiceIndication");
	      sequenceNumber = -1;
	      try {
	        sequenceNumber = Integer.parseInt(getTextValue("SequenceNumber"));
	      } catch (NumberFormatException e) {
	        // Fall through
	      } catch (NullPointerException e) {
	        // Fall through
	      }
	      if (serviceIndication == null || sequenceNumber == -1) {
	        throw new IllegalArgumentException("Invalid RepositoryData document");
	      }
	      // If service data exists or sequence number is non-zero, then we
	      // must increment the sequence number the first time the service data
	      // is updated.
	      if (sequenceNumber > 0 || getElement("ServiceData") != null) {
	        increment = true;
	      }
	    }
	    /**
	     * 
	     * @return the XML Document
	     */
	    public Document getDocument() {
	      return doc;
	    }
	    
	    /**
	     * 
	     * @return the XML Root Element
	     */
	    private Element getRoot() {
	      Element e = getElement(doc.getDocumentElement(), "RepositoryData");
	      if (e == null) {
	        throw new IllegalStateException("Missing RepositoryData element");
	      }
	      return e;
	    }
	    /**
	     * Set the Service Data and update the sequence number
	     * @param newData
	     */
	    public void setServiceData(Element newData) {
	      Element e = getElement("ServiceData");
	      if (e == null) {
	        e = createElement("ServiceData");
	      } else {
	        removeChildren(e);
	      }
	      e.appendChild(newData);
	      updateSequence();
	    }
	    
	    /**
	     * Use it to remove ServiceData Element when you 
	     * want to remove the data from the HSS
	     */
	    public void removeServiceData()
	    {
	    	Element e = getElement("ServiceData");
	    	e.getParentNode().removeChild(e);
	    	updateSequence();
	    }
	    
	    /**
	     * 
	     * @param name The Element Name
	     * @return the XML Element
	     */
	    private Element getElement(String name) {
	      return getElement(getRoot(), name);
	    }

	    /**
	     * 
	     * @param e
	     * @param path
	     * @return
	     */
	    public static Element getElement(Element e, String path) {
	      String[] ps = path.split("/+");
	      for (int i = 0; i < ps.length && e != null; i++) {
	        e = getChild(e, ps[i]);
	      }
	      return e;
	    }

	    /**
	     * 
	     * @param e
	     * @param tagName
	     * @return
	     */
	    public static Element getChild(Element e, String tagName) {
	      if (tagName.length() == 0) return e;
	      NodeList nodes = e.getChildNodes();
	      for (int i = 0; i < nodes.getLength(); i++) {
	        Node node = nodes.item(i);
	        if (node.getNodeType() == Node.ELEMENT_NODE &&
	            node.getNodeName().equals(tagName)) {
	          return (Element) node;
	        }
	      }
	      return null;
	    }
	    
	    /**
	     * Use it to update the sequence number of Sh Document
	     *
	     */
	    private void updateSequence() {
	      if (!increment) return;
	      sequenceNumber = (sequenceNumber + 1) & 0xffff;
	      Element e = getElement("SequenceNumber");
	      if (e == null) {
	        throw new IllegalStateException("Missing SequenceNumber element");
	      }
	      setTextValue(e, String.valueOf(sequenceNumber));
	      increment = false;
	  }
	    
	    /**
	     * Create an XML element
	     * @param name
	     * @return
	     */
	    private Element createElement(String name) {
	      Element e = doc.createElement(name);
	      getRoot().appendChild(e);
	      return e;
	    }
	    /**
	     * 
	     * @param name
	     * @return
	     */
	    private String getTextValue(String name) {
	       Element e = getElement(name);
	       return e != null ? getTextValue(e) : null;
	    }
	    /**
	     * 
	     * @param e
	     * @return
	     */
	    public static String getTextValue(Element e) {
	      StringBuffer sb = new StringBuffer();
	      NodeList nodes = e.getChildNodes();
	      for (int i = 0; i < nodes.getLength(); i++) {
	        Node node = nodes.item(i);
	        if (node.getNodeType() == Node.TEXT_NODE) sb.append(node.getNodeValue());
	      }
	      return sb.toString();
	    }
	    /**
	     * 
	     * @param e
	     * @param s
	     */
	    public static void setTextValue(Element e, String s) {
	      NodeList nl = e.getChildNodes();
	      if (nl.getLength() == 1) {
	        nl.item(0).setNodeValue(s);
	      } else {
	        if (nl.getLength() > 1) removeChildren(e);
	        e.appendChild(e.getOwnerDocument().createTextNode(s));
	      }
	    }
	    /**
	     * 
	     * @param e
	     */
	    public static void removeChildren(Element e) {
	      Node child;
	      while ((child = e.getFirstChild()) != null) {
	        e.removeChild(child);
	      }
	    }
	  }
}
