package com.bea.iot.sh.pur;

/**
 * @author sgioia Stefano Gioia (sgioia@bea.com)
 * @version 1.0
 */

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.transform.TransformerException;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;

import com.bea.iot.sh.Constants;
import com.bea.iot.sh.DiameterHelper;
import com.bea.iot.sh.XMLUtils;
import com.bea.wcp.diameter.MessageException;
import com.bea.wcp.diameter.ResultCode;
import com.bea.wcp.profile.ProfileException;
import com.bea.wcp.profile.ProfileService;

public class ShPURHandler {
	
	String		shRequestString,
				serviceName,
				serverName,
				newData,
				newValue;
	
	int			domainType;
	
	Document 	shRequest;
	protected static Logger logger = Logger.getLogger(ShPURHandler.class.getName());
	ProfileService ps = null;
	HttpSession session = null;
	HttpServletRequest request = null;
	
	/**
	 * 
	 * @param aPS the ProfileService
	 * @param theSession the HTTP Session
	 * @param aServiceName the ServiceName used to query HSS while requesting RepositoryData
	 * @param aServerName the ServerName used to query HSS while requesting InitialFilterCriteria
	 */
	public ShPURHandler(ProfileService aPS, HttpSession theSession, String aServiceName, 
			String aServerName, int aDomainType) 
	{ 
		ps = aPS;
		session = theSession;
		serverName = aServerName;
		serviceName = aServiceName;
		domainType = aDomainType;
	}
	
	/**
	 * Execute the scheduled test
	 * @param userName the username used to retreive data from the HSS
	 */
	public void runTest(String userName, String requestedInfo, String newData, String newValue)
	{	
		int requestType = Integer.parseInt(requestedInfo); 
		
		shRequestString = DiameterHelper.buildShRequest( requestType, userName, serviceName, 
							domainType, serverName);
		
		session.setAttribute(Constants.DOC_SELECTOR, shRequestString);
		session.setAttribute( Constants.HSS_RESPONSE, executeTest(shRequestString, newData, newValue) ); 
	}
	
	
	
	
	/**
	 * 
	 * @param theShRequest the SH request
	 * @return a string with the response from HSS
	 */
	private String executeTest(String theShRequest, String newData, String newValue) 
	{
		String response = null;
		try {
			logger.debug("Sh Request: " + theShRequest );
			Document originalDoc = ps.getDocument(theShRequest);
			
			// Preparing to modify the document
			logger.debug("Going to prepare document");

			// Modifying original document
			Document modifiedDocument = this.saveDoc((Document)originalDoc.cloneNode(true),newData, newValue);
				
			// Storing using Profile
			ps.putDocument(theShRequest, modifiedDocument);
			logger.debug("Saving data into HSS");
				
			// Store in session the SIP SH Output Request
			session.setAttribute(Constants.SIPAS_OUTPUT, DiameterHelper.toString(modifiedDocument));

			response = DiameterHelper.toString(originalDoc.getDocumentElement());
			logger.debug("HSS Response: \n				" + response);
		} catch (ProfileException e) {
			MessageException me = (MessageException)e.getCause();                                                     
			ResultCode rc = me.getResultCode();       
			session.setAttribute(Constants.DIAMETER_RESULT_CODE, rc.toString());
			session.setAttribute("Exception", e.getMessage());
			logger.debug("Exception - Diameter Result Code is: " + rc.toString() );
		} catch (Exception e) {
			response = e.getMessage();
			session.setAttribute("Exception", e.getMessage());
			logger.debug("Exception: " + response);
		} 
		return response;
	}

	
	 /**
	  * 
	  * @param clonedDoc the cloned version of orginal HSS Doc
	  * @param newData the new serviceData submitted by the user
	  * @param newValue the new serviceValue submitted by the user
	  * @return the new Document to use it by the Profile
	  * @throws TransformerException
	  */ 
	 private Document saveDoc(Document clonedDoc, String newData, String newValue) throws TransformerException
	 {	
		 // Create a Data Wrapper
		 XMLUtils.RepDataWrapper rd = new XMLUtils.RepDataWrapper(clonedDoc); 
		 // If the data received is null or empty, go and remove from HSS the serviceData
		 if(newData == null || newData.equals("")) {
			 logger.debug("New data not found! Going to remove the orginal ServiceData and ServiceValue");
			 rd.removeServiceData();
		 } else {
			 // Store the new Data and Value
			 rd.setServiceData(XMLUtils.createTextElement( rd.getDocument(),newData,newValue));
		 }
		 logger.debug("New Document is: \n	" + DiameterHelper.toString(rd.getDocument()));    
		 return rd.getDocument();
	 }
	



}
