package com.bea.iot.sh.snr;


/**
 * @author sgioia Stefano Gioia (sgioia@bea.com)
 * @version 1.0
 */

import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;

import com.bea.iot.sh.DiameterHelper;
import com.bea.wcp.profile.ProfileService;
import com.bea.wcp.profile.ProfileSubscription;

import javax.servlet.sip.SipApplicationSession;

public class ShSNRHandler {
	
	String		shRequest,
				serviceName,
				serverName,
				callId;
	
	Document 	shRepositoryData, 
				shIMSUsetState,
				shSCSCFName, 
				shInitialFilertCriteria,
				genericDoc;
	
	ProfileService ps = null;
	HttpSession session = null;
	SipApplicationSession theSipAppplicationSession = null;
	protected static Logger logger = Logger.getLogger(ShSNRHandler.class.getName());
	
	/**
	 * 
	 * @param aPS the ProfileService
	 * @param theSession the HTTP Session
	 * @param aServiceName the ServiceName used to query HSS while requesting RepositoryData
	 * @param aServerName the ServerName used to query HSS while requesting InitialFilterCriteria
	 */
	public ShSNRHandler(ProfileService aPS, HttpSession theSession, 
								String aServiceName, String aServerName, 
								SipApplicationSession sipAsSession, String theCallId) 
	{ 
		ps = aPS;
		session = theSession;
		serverName = aServerName;
		serviceName = aServiceName;
		theSipAppplicationSession = sipAsSession;
		callId = theCallId;

	}
	
	
	public ShSNRHandler() {}
	
	/**
	 * Execute the scheduled test. As specified, an AS can subscribe only
	 * to RepositoryData, IMSUserState, S-CSCFName, and InitialFilterCriteria
	 * @param userName the username used to retreive data from the HSS
	 */
	public String runTest(String userName, String subscribeTo) throws Exception
	{
		int requestType = Integer.parseInt(subscribeTo);
		
		// Creating the Sh Request String
		shRequest = DiameterHelper.buildShRequest(requestType, userName, serviceName, -1, serverName);		
		// Execute the test
		return executeTest(shRequest);

	}
	
	
	
	
	/**
	 * 
	 * @param theShRequest the SH request
	 * @return a string with the response from HSS
	 */
	private String executeTest(String theShRequest) throws Exception
	{
		logger.info("Going to execute a subscribe with Sh Request: " + theShRequest );
		// Subscribe to profile data. 
		ProfileSubscription subscription = ps.subscribe( theSipAppplicationSession, theShRequest, callId );
		return subscription.getInfo().toString();
	}
}