package com.bea.iot.sh.snr;


/**
 * @author sgioia Stefano Gioia (sgioia@bea.com)
 * @version 1.0
 */




import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;

import com.bea.iot.sh.Constants;
import com.bea.iot.sh.DiameterBaseServlet;
import com.bea.iot.sh.DiameterHelper;
import com.bea.wcp.diameter.MessageException;
import com.bea.wcp.diameter.ResultCode;
import com.bea.wcp.profile.ProfileException;
import com.bea.wcp.profile.ProfileListener;
import com.bea.wcp.profile.ProfileSubscription;

import java.io.IOException;


public class ShSNRServlet  extends DiameterBaseServlet  implements ProfileListener {
	protected static Logger logger = Logger.getLogger(ShSNRServlet.class.getName());
	private static final long serialVersionUID = 1L;
	
	/**
	 * Generic init method
	 */
	 public void init() throws ServletException {
		 super.init();
	    logger.info(" initi");    	
	}

	 /** 
	  * @param req The Http Request
	  * @param res The Http Response
	  * @throws IOException 
	  */
	protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException 
	{
		getDataFromTheRequest(req);
		
		ShSNRHandler shSNR = new ShSNRHandler( ps, 
											   httpSession, 
											   serviceIndication, 
											   serverName,
											   theSipFactory.createApplicationSession(),
											   String.valueOf(serialVersionUID) );
	
		
		try {
			shSNR.runTest( req.getParameter(Constants.USER_NAME),
					   req.getParameter(Constants.REQUEST_TYPE) );
		} catch (ProfileException e) {
			MessageException me = (MessageException)e.getCause();                                                     
			ResultCode rc = me.getResultCode();       
			httpSession.setAttribute(Constants.DIAMETER_RESULT_CODE, rc.toString());
			httpSession.setAttribute("Exception", e.getMessage());
			logger.error("Exception - Diameter Result Code is: " + rc.toString() );
		
		} catch (Exception e) {
			logger.error("Generic Error: " + e.getMessage());
			e.printStackTrace();
		}
		String theNextPage = req.getParameter(Constants.NEXT_PAGE);
		logger.debug("Redirect to the nextPage: " + theNextPage);
		res.sendRedirect(theNextPage);
		
	}      
	
	/**
	 * @param ps The ProfileSubscription
	 * @param doc The XML document sent by HSS
	 */
	public void update(ProfileSubscription ps, Document document) 
	{        
		try {
			logger.info("State updated:\n " + DiameterHelper.toString(document) );
			logger.info("Going to unsubscribe...");
			//ps.cancel();
		} catch (TransformerException e) {
			logger.debug(e.getMessage());
			e.printStackTrace();
		}      
	}
}