package com.bea.iot.sh.snr;
/**
 * @author sgioia Stefano Gioia (sgioia@bea.com)
 * @version 1.0
 */

import com.bea.iot.sh.Constants;
import com.bea.iot.sh.DiameterHelper;
import com.bea.wcp.diameter.MessageException;
import com.bea.wcp.diameter.ResultCode;
import com.bea.wcp.profile.*;    
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;    
import javax.servlet.sip.SipServlet;    
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;    
import java.io.IOException;    



public class SipSNRPNRServlet extends SipServlet //implements ProfileListener 
{      

	private static final long serialVersionUID = 1L;
	protected static Logger logger = Logger.getLogger(SipSNRPNRServlet.class.getName());
	private ProfileService psvc;    
	private SipApplicationSession sipAppSession;
	
	private String serverName;
	private String serviceName;
	
	public void init() 
	{   
		psvc 		= (ProfileService) getServletContext().getAttribute(ProfileService.PROFILE_SERVICE);      
		serverName 	= getServletContext().getInitParameter(Constants.IOT_SH_SERVER_NAME);
	    serviceName = getServletContext().getInitParameter(Constants.IOT_SH_SERVICE_NAME);
	    log("Using serverName=" + serverName + ", and serviceName=" + serviceName);
	}      
	    

	/**
	 * Generic method
	 * @param req The SipServletRequest
	 * @throws IOException
	 */
	protected void doMessage(SipServletRequest req) throws IOException 
	{   
		String reason = "";
		
		SipServletResponse res = req.createResponse(SipServletResponse.SC_OK);
		res.setExpires(3500);
		res.send();
		
		sipAppSession = req.getApplicationSession();
		
		ShSNRHandler notifier = new ShSNRHandler( psvc,
												  null,
												  serviceName,
												  serverName, 
												  sipAppSession, 
												  req.getApplicationSession().getId() );
		try {
			if( req.getExpires() > 0 ) 
			{
				logger.debug("Subscription requested. Selected user is " +  req.getTo().toString()
						+ ", and expires header is " + req.getExpires() );
	
				notifier.runTest( req.getTo().toString(), req.getHeader("Subject") );
			}
			else if( req.getExpires() <= 0 )
			{
				
				logger.debug("Un-Subscription requested: expires header is " + req.getExpires() );
				logger.debug("*************** NOT YET IMPLEMENTED ***************");
			}
		} catch (ProfileException e) {
			MessageException me = (MessageException)e.getCause();                                                     
			ResultCode rc = me.getResultCode();       
			logger.debug("Exception - Diameter Result Code is: " + rc.toString() ); 
			reason = rc.toString();
		} catch (Exception e) {
			logger.debug("Exception: " + e.getMessage());
			reason =  e.getMessage();
		} finally {
			SipServletResponse badResponse = req.createResponse(SipServletResponse.SC_BAD_REQUEST);
			badResponse.setHeader("Reason:",reason );
			badResponse.send();
		}
		
	}	
	
	
	/**
	 * Update method
	 * @param ps the ProfileSubscription
	 * @param document the updated profile form HSS
	 */
	public void update(ProfileSubscription ps, Document document) {        
		try 
		{
			logger.debug("The Profile is updated. More info:" + ps.getInfo().toString() ); 
			logger.debug("Received document: \n" + DiameterHelper.toString(document.getDocumentElement()) );
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}	
}