package com.bea.iot.sh.snr;

import com.bea.iot.sh.DiameterHelper;
import com.bea.wcp.profile.*;    
import javax.servlet.sip.SipServletRequest;    
import javax.servlet.sip.SipServlet;    
import javax.xml.transform.TransformerException;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;    
import java.io.IOException;    

public class SubscribeServlet extends SipServlet implements ProfileListener 
{      
	private static final long serialVersionUID = 1L;
	private ProfileService psvc;      
	protected static Logger logger = Logger.getLogger(SubscribeServlet.class.getName());
		
	public void init() 
	{        
		psvc = (ProfileService) getServletContext().getAttribute(ProfileService.PROFILE_SERVICE);      
	}      
	
	/**
	 * @param req The SIP Request
	 * @throws IOException
	 */
	protected void doMessage(SipServletRequest req) throws IOException 
	{        
		String docSel = "sh://" + req.getTo() + "/RepositoryData/IOTService";
		String docSel2 = "sh://" + req.getTo() + "/IMSUserState/";
		String docSel3 = "sh://" + req.getTo() + "/S-CSCFName/";
		if( req.getExpires() > 0 ) 
		{
			logger.info("Subscription requested. Selected user is " +  req.getTo().toString()
						+ ", and expires header is " + req.getExpires() );
			ProfileSubscription profSub = psvc.subscribe(req.getApplicationSession(), docSel, null );
			logger.info("ps.getDocumentSelector(): " + profSub.getDocumentSelector() );
			
			ProfileSubscription profSub2 = psvc.subscribe(req.getApplicationSession(), docSel2, null );
			logger.info("ps.getDocumentSelector(): " + profSub2.getDocumentSelector() );
			
			ProfileSubscription profSub3 = psvc.subscribe(req.getApplicationSession(), docSel3, null );
			logger.info("ps.getDocumentSelector(): " + profSub3.getDocumentSelector() );
			
		}
	}      
	
	/**
	 * @param ps The ProfileSubscription
	 * @param doc The XML document sent by HSS
	 */
	public void update(ProfileSubscription ps, Document document) 
	{        
		try {
			System.out.println("State updated:\n " + DiameterHelper.toString(document) );
			System.out.println("Going to unsubscribe...");
			ps.cancel();
		} catch (TransformerException e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
		}      
	}    
}