package com.bea.iot.sh.udr;
/**
 * @author sgioia Stefano Gioia (sgioia@bea.com)
 * @version 1.0
 */

import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;

import com.bea.iot.sh.Constants;
import com.bea.iot.sh.DiameterHelper;
import com.bea.wcp.diameter.MessageException;
import com.bea.wcp.diameter.ResultCode;
import com.bea.wcp.profile.ProfileException;
import com.bea.wcp.profile.ProfileService;

public class ShProfileViewerHandler {
	
	protected static Logger logger = Logger.getLogger(ShProfileViewerHandler.class.getName());
	
	String		shRequestRepositoryData,
				shRequestPublicIdentifiers, 
				shRequestIMSUserStateCS,
				shRequestIMSUserStatePS,
				shRequestSCSCFName, 
				shRequestInitialFilertCriteria,
				shRequestCharchingInformation,
				shRequestMSISDN,
				shRequestLocationInfo,
				shRequestUserState,
				serviceName,
				serverName;
	
	Document 	shRepositoryData, 
				shPublicIdentifiers, 
				shIMSUsetStateCS,
				shIMSUsetStatePS,
				shSCSCFName, 
				shInitialFilertCriteria,
				shCharchingInformation,
				shMSISDN,
				shLocationInfo,
				shUserState,
				genericDoc;
	
	ProfileService ps = null;
	HttpSession session = null;
	
	/**
	 * 
	 * @param aPS the ProfileService
	 * @param theSession the HTTP Session
	 * @param aServiceName the ServiceName used to query HSS while requesting RepositoryData
	 * @param aServerName the ServerName used to query HSS while requesting InitialFilterCriteria
	 */
	public ShProfileViewerHandler(ProfileService aPS, HttpSession theSession, String aServiceName, String aServerName) 
	{ 
		ps = aPS;
		session = theSession;
		serverName = aServerName;
		serviceName = aServiceName;
	}
	
	/**
	 * Execute the scheduled test
	 * @param userName the username used to retreive data from the HSS
	 */
	public void runTest(String userName)
	{

		shRequestRepositoryData = DiameterHelper.buildShRequest(Constants.SH_REPOSITORY_DATA,
													userName, serviceName,
														 -1, null);
		
		shRequestPublicIdentifiers = DiameterHelper.buildShRequest(Constants.SH_IMS_PUBLIC_IDENTITY,
				 									userName, null,-1, null);
		
		
		shRequestIMSUserStatePS = DiameterHelper.buildShRequest(Constants.SH_IMS_USER_STATE,
				userName, null, Constants.SH_PS_DOMAIN, null);
		
		shRequestSCSCFName = DiameterHelper.buildShRequest(Constants.SH_S_CSCF_NAME,
													userName, null,-1, null);
		
		shRequestInitialFilertCriteria = DiameterHelper.buildShRequest(Constants.SH_INITIAL_FILTER_CRITERIA,
				userName, null,-1, serverName);	
		
		shRequestCharchingInformation = DiameterHelper.buildShRequest(Constants.SH_CHARGING_INFO,
				userName, null,-1, null);			
		
		shRequestMSISDN = DiameterHelper.buildShRequest(Constants.SH_MSISDN,
				userName, null,-1, null);
		
		shRequestLocationInfo = DiameterHelper.buildShRequest(Constants.SH_LOCATION_INFO,
				userName, null, Constants.SH_CS_DOMAIN, null);
		
		shRequestUserState = DiameterHelper.buildShRequest(Constants.SH_USER_STATE,
				userName, null, -1, null);
		
		logger.debug("\nPrinting Sh request:" + 
				"\n		shRequestRepositoryData: " + shRequestRepositoryData + 
				"\n		shRequestPublicIdentifiers: " + shRequestPublicIdentifiers + 
				"\n		shRequestIMSUsetStateCS: " + shRequestIMSUserStateCS + 
				"\n		shRequestIMSUsetStatePS: " + shRequestIMSUserStatePS +
				"\n		shRequestSCSCFName: " + shRequestSCSCFName + 
				"\n		shRequestInitialFilertCriteria: " + shRequestInitialFilertCriteria + 
				"\n		shRequestCharchingInformation: " + shRequestCharchingInformation + 
				"\n		shRequestMSISDN: " + shRequestMSISDN + 
				"\n		shRequestLocationInfo: " + shRequestLocationInfo +
				"\n		shRequestUserState: " + shRequestUserState + "\n\n" );
		
		
		session.setAttribute(Constants.IOT_SH_PULL_REPOSITORY_DATA, executeTest(shRequestRepositoryData) );
		session.setAttribute(Constants.IOT_SH_PULL_PUBLIC_IDENTITY, executeTest(shRequestPublicIdentifiers) );
		session.setAttribute(Constants.IOT_SH_PULL_IMS_USER_STATE, executeTest(shRequestIMSUserStatePS) );
		session.setAttribute(Constants.IOT_SH_PULL_S_CSCF_NAME, executeTest(shRequestSCSCFName) );
		session.setAttribute(Constants.IOT_SH_PULL_INITIAL_FILTER_CRITERIA, executeTest(shRequestInitialFilertCriteria) );
		session.setAttribute(Constants.IOT_SH_PULL_CHARGING_INFO, executeTest(shRequestCharchingInformation));
		session.setAttribute(Constants.IOT_SH_PULL_MSISDN, executeTest(shRequestMSISDN));
		session.setAttribute(Constants.IOT_SH_PULL_LOCATION_INFO, executeTest(shRequestLocationInfo));
		session.setAttribute(Constants.IOT_SH_PULL_USER_STATE, executeTest(shRequestUserState));
	}
	
	
	
	
	/**
	 * 
	 * @param theShRequest the SH request
	 * @return a string with the response from HSS
	 */
	private String executeTest(String theShRequest) 
	{
		String response = null;
		try {
			logger.debug("Sh Request: " + theShRequest );
			genericDoc = ps.getDocument(theShRequest);
			response = DiameterHelper.toString(genericDoc.getDocumentElement());
			logger.debug("HSS Response: \n				" + response);
		} catch (ProfileException e) {
			MessageException me = (MessageException)e.getCause();                                                     
			ResultCode rc = me.getResultCode();       
			response = rc.toString();
		} catch (Exception e) {
			response = e.getMessage();
			logger.debug("Exception: " + response);
		} 
		return response;
	}
}