package com.bea.iot.sh.udr;

/**
 * @author sgioia Stefano Gioia (sgioia@bea.com)
 * @version 1.0
 */

import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;

import com.bea.iot.sh.Constants;
import com.bea.iot.sh.DiameterHelper;
import com.bea.wcp.diameter.MessageException;
import com.bea.wcp.diameter.ResultCode;
import com.bea.wcp.profile.ProfileException;
import com.bea.wcp.profile.ProfileService;

public class ShUDRHandler {
	
	String		shRequestString,
				serviceName,
				serverName;
	
	int			domainType;
	
	Document 	shRequest;
	
	ProfileService ps = null;
	HttpSession session = null;
	protected static Logger logger = Logger.getLogger(ShUDRHandler.class.getName());
	
	/**
	 * 
	 * @param aPS the ProfileService
	 * @param theSession the HTTP Session
	 * @param aServiceName the ServiceName used to query HSS while requesting RepositoryData
	 * @param aServerName the ServerName used to query HSS while requesting InitialFilterCriteria
	 */
	public ShUDRHandler( ProfileService aPS, 
						 HttpSession theSession,
						 String aServiceName,
						 String aServerName,
						 int aDomainType) 
	{ 
		ps = aPS;
		session = theSession;
		serverName = aServerName;
		serviceName = aServiceName;
		domainType = aDomainType;
		
		
	}
	
	/**
	 * Execute the scheduled test
	 * @param userName the username used to retreive data from the HSS
	 */
	public void runTest(String userName, String requestedInfo)
	{
		int requestType = Integer.parseInt(requestedInfo);
		shRequestString = DiameterHelper.buildShRequest(requestType,
						userName, serviceName, domainType, serverName);
		session.setAttribute( Constants.DOC_SELECTOR, shRequestString );
		session.setAttribute( Constants.HSS_RESPONSE, executeTest(shRequestString) );  
	}
	
	
	
	
	/**
	 * 
	 * @param theShRequest the SH request
	 * @return a string with the response from HSS
	 */
	private String executeTest(String theShRequest) 
	{
		String response = null;
		try {
			logger.debug("Sh Request: " + theShRequest );
			Document genericDoc = ps.getDocument(theShRequest);
			response = DiameterHelper.toString(genericDoc.getDocumentElement());
			logger.debug("HSS Response: \n				" + response);
		} catch (ProfileException e) {
			MessageException me = (MessageException)e.getCause();                                                     
			ResultCode rc = me.getResultCode();       
			session.setAttribute(Constants.DIAMETER_RESULT_CODE, rc.toString());
			session.setAttribute("Exception", e.getMessage());
			logger.error("Exception - Diameter Result Code is: " + rc.toString() );
		} catch (Exception e) {
			response = e.getMessage();
			session.setAttribute("Exception", e.getMessage());
			logger.error("Exception: " + response);
		} 
		return response;
	}
}
