package enterquoteui.backing;

import java.util.List;

import javax.faces.event.ValueChangeEvent;

import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCBindingContainer;

import oracle.adf.model.binding.DCIteratorBinding;

import oracle.adfinternal.view.faces.model.binding.FacesCtrlHierBinding;

import oracle.adfinternal.view.faces.model.binding.FacesCtrlHierNodeBinding;

import oracle.jbo.AttributeDef;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.format.Formatter;

import org.apache.myfaces.trinidad.model.CollectionModel;

public class DiscountHelper {
    private Double grossRevenue = null;
    private Double netRevenue;
    
    public DiscountHelper() {
        super();
    }
    public Double getNetRevenue() {
        //System.out.println ("getNetRevenue Called");
        calculate ();
        //System.out.println ("getNetRevenue Returns " + netRevenue);
        setBindingVal ("TotalNetRevenue", netRevenue);
        return netRevenue;
    }
    public Double getEffectiveDiscount () {
        // Avoid unnecessary duplication
        if (grossRevenue == null) calculate ();
        
        //double d = netRevenue.doubleValue();
        //d = d / grossRevenue.doubleValue();
        double d = grossRevenue.doubleValue();
        d = (d == 0) ? 1 : netRevenue.doubleValue() / d;
        
        grossRevenue = null;        
        Double ret = new Double (1 - d);
        setBindingVal ("EffectiveDiscount", ret);
        
        return ret;
    }
    private void calculate () {
        double gross = 0;
        double net = 0;

        DCBindingContainer bc = (DCBindingContainer) BindingContext.getCurrent().getCurrentBindingsEntry();
        if (bc == null) {
            System.out.println ("**** Got NULL Binding Container");
            return;            
        }
        FacesCtrlHierBinding cb = (FacesCtrlHierBinding) bc.getControlBinding("ProductItem");
        if (cb == null) {
            System.out.println ("**** Got NULL ProductItem binding");
            return;
        }
        CollectionModel cm = cb.getCollectionModel();
        if (cm == null) {
            return;
        }
        for (int i = 0; i < cm.getRowCount(); i++) {
            FacesCtrlHierNodeBinding rData = (FacesCtrlHierNodeBinding) cm.getRowData(i);
            Number list = getNumberAttr(rData, "ListPrice");
            Number disc = getNumberAttr(rData, "RequestedDiscount");
            Number qty = getNumberAttr(rData, "Quantity");
            
            double rGross = list.doubleValue() * qty.doubleValue();
            gross += rGross;
            
            double rNet = (1 - disc.doubleValue()) * rGross;
            net += rNet;
            
            //System.out.println ("Discount Helper - Row [" + i + "] : " + rNet + ", list: " + list + 
            //                    ", discount: " + disc + ", quantity: " + qty);

        }
        grossRevenue = new Double (gross);
        netRevenue = new Double (net);
    }
    private Number getNumberAttr (FacesCtrlHierNodeBinding rData, String attrName) {
        try {
            Number attrVal = (Number) rData.getAttribute(attrName);
            return (attrVal == null) ? new Double (0) : attrVal;
        } catch (Exception ex) {
            System.out.println ("Exception getting attr as number - " + ex.getMessage());
            return new Double (0);
        }        
    }
    private void setBindingVal (String attr, Double val) {
        DCBindingContainer bc = (DCBindingContainer) BindingContext.getCurrent().getCurrentBindingsEntry();
        DCIteratorBinding dcib = bc.findIteratorBinding("SummaryIterator");        
        //System.out.println("After get iterator binding - " + dcib);
        
        RowSetIterator iter = dcib.getRowSetIterator();
        //System.out.println("After get row iterator - " + iter);
        Row row = iter.getRowAtRangeIndex(0);
        
        //System.out.println ("After get row " + row);
        
        if (val != null) row.setAttribute(attr, val);
        //System.out.println ("Successfully set attr " + attr + " to value " + val);
    }

}
