package enterquoteui.backing;

import java.util.List;

import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.binding.DCIteratorBindingDef;
import oracle.adf.view.rich.datatransfer.DataFlavor;
import oracle.adf.view.rich.dnd.DnDAction;
import oracle.adf.view.rich.event.DropEvent;

import oracle.adfinternal.view.faces.model.binding.FacesCtrlHierBinding;

import oracle.adfinternal.view.faces.model.binding.FacesCtrlHierNodeBinding;

import oracle.binding.BindingContainer;

import oracle.binding.ControlBinding;

import oracle.binding.OperationBinding;

import oracle.jbo.AttributeDef;
import oracle.jbo.Row;

import oracle.jbo.RowSetIterator;

import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySet;
import oracle.jbo.domain.Number;
import oracle.jbo.format.Formatter;

public class DropProduct {
    public DropProduct() {
        super();
    }
    
    public DnDAction HandleDrop(DropEvent dropEvent) {
        //System.out.println ("In Handle Drop");
        try {  
            DataFlavor<RowKeySet> df = DataFlavor.getDataFlavor(RowKeySet.class); 
            RowKeySet droppedValue = dropEvent.getTransferable().getData(df);  
        
            
             if (droppedValue == null) {  
                return DnDAction.NONE;  
            } else {     
                Object[] keys = droppedValue.toArray();  
                DCBindingContainer bc = (DCBindingContainer) BindingContext.getCurrent().getCurrentBindingsEntry();
                 
                FacesCtrlHierBinding cb = (FacesCtrlHierBinding) bc.getControlBinding("ProductView1");
                 
                //AttributeDef atdef = cb.findAttributeDef("ListPrice");
                //Formatter formatter = atdef.getUIHelper().getFormatter(BindingContext.getCurrent().getLocaleContext());
                               
                CollectionModel cm = cb.getCollectionModel();
                 for (int i = 0; i < keys.length; i++) {
                     cm.setRowKey((List)keys[i]);

                     FacesCtrlHierNodeBinding rData = (FacesCtrlHierNodeBinding) cm.getRowData();
                     //System.out.println("After get data " + rData);
                     Number id = (Number) rData.getAttribute("Id");
                     String name = (String) rData.getAttribute("Name");
                     
                     //Number list = parseNumber((String) rData.getAttribute("ListPrice"), formatter);
                     Number list = (Number) rData.getAttribute("ListPrice");
                         
                     Number preDisc = (Number) rData.getAttribute("PreApprovedDiscount");
                     String restricted = (String) rData.getAttribute("Restricted");
                     Number minQty = (Number) rData.getAttribute("MinQty");
                     if (minQty == null || minQty.compareTo(1) == -1) minQty = new Number (1);
                     
                     //System.out.println ("Dropped Data - id: " + id + ", name: " + name + ", list: " + list +
                     //                    ", pre approved discount: " + preDisc + ", restricted: " + restricted);
                    
                    addItem (id, name, list, preDisc, restricted, minQty);
                 }

            }  
            return DnDAction.COPY;  
        } catch (Exception ex) {  
            System.out.println("drop failed with : " + ex.getMessage());  
            return DnDAction.NONE;  
        }  
    } 
    private Number parseNumber (String str, Formatter formatter) 
    {
        try {
            Object tmp = formatter.parseObject(str);
            //if (tmp != null) System.out.println ("Parsed Object Type is " + tmp.getClass());
            long lng = (Long) formatter.parseObject(str);
            return new Number (lng);
        } catch (Exception ex) {
            System.out.println("Could not parse '" + str + "' as Number: "+ ex.getMessage());  
            return new Number (0);
        }
    }
    /*
    private void addItem (Number id, String name, Number list, Number preApprovedDiscount, String restricted,
                          Number minQty) {
        DCBindingContainer bc = (DCBindingContainer) BindingContext.getCurrent().getCurrentBindingsEntry();
        DCIteratorBinding dcib = bc.findIteratorBinding("ProductItemIterator");        
        System.out.println("After get iterator - " + dcib);
        
        RowSetIterator iter = dcib.getRowSetIterator();
        Row newRow = iter.createRow();
        newRow.setAttribute("ProductName", name);
        newRow.setAttribute("ProductID", id);
        newRow.setAttribute("ListPrice", list);
        newRow.setAttribute("PreApprovedDiscount",preApprovedDiscount);
        newRow.setAttribute("RestrictedItem", restricted);
        newRow.setAttribute("Quantity", minQty);
        iter.insertRowAtRangeIndex(iter.getRowCount(), newRow);
        
    } 
*/
    private void addItem (Number id, String name, Number list, Number preApprovedDiscount, String restricted,
                          Number minQty) {
        DCBindingContainer bc = (DCBindingContainer) BindingContext.getCurrent().getCurrentBindingsEntry();
        DCIteratorBinding dcib = bc.findIteratorBinding("ProductItemIterator");        
        //System.out.println("After get iterator - " + dcib);
        
        RowSetIterator iter = dcib.getRowSetIterator();
        Row newRow = iter.createRow();
        //System.out.println("Setting ProductName " + name);
        newRow.setAttribute("ProductName", name);
        //System.out.println("Setting ProductID " + id.toString());
        if (id != null) newRow.setAttribute("ProductID", id.toString());
        //System.out.println("Setting ListPrice " + list);
        if (list != null) newRow.setAttribute("ListPrice", getBpelDouble(list));
        //System.out.println("Setting PreApprovedDiscount " + preApprovedDiscount);
        if (preApprovedDiscount != null) newRow.setAttribute("PreApprovedDiscount", getBpelDouble(preApprovedDiscount));
        //System.out.println("Setting RestrictedItem " + restricted);
        newRow.setAttribute("RestrictedItem", (restricted.compareToIgnoreCase("n") == 0) ? "false" : "true");
        //System.out.println("Setting Quantity " + minQty);
        newRow.setAttribute("Quantity", getBpelInteger(minQty));
        newRow.setAttribute("ControlledAvailability", "false");
        iter.insertRowAtRangeIndex(iter.getRowCount(), newRow);
    }
    private oracle.bpel.services.datacontrol.types.Number getBpelDouble (Number num) {
        Double dbl = new Double (num.getValue());
        return new oracle.bpel.services.datacontrol.types.Number (dbl.toString());
    }
    private oracle.bpel.services.datacontrol.types.Number getBpelInteger (Number num) {
        Double dbl = new Double (num.getValue());
        Integer intg = new Integer (dbl.intValue());
        return new oracle.bpel.services.datacontrol.types.Number (intg.toString());
    }
}
