package enterquoteui.backing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import oracle.jbo.Row;

import javax.el.ELResolver;

import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import oracle.adf.model.BindingContext;

import oracle.binding.ControlBinding;

import oracle.adfinternal.view.faces.model.binding.FacesCtrlHierBinding;
import oracle.adfinternal.view.faces.model.binding.FacesCtrlHierNodeBinding;

import oracle.adfinternal.view.faces.model.binding.FacesCtrlRangeBinding;

import oracle.binding.BindingContainer;

import oracle.jbo.uicli.binding.JUCtrlValueBindingRef;

import org.apache.myfaces.trinidad.model.CollectionModel;

public class TermChoices {
    private Map termChoicesCache = null;
    private List<SelectItem> categoryChoices = null;
    //private List<SelectItem> emptyChoices = null;
    
    public TermChoices() {
        super();
    }
    public List<SelectItem> getCategoryChoices() {
        if (termChoicesCache == null) loadCache();
        
        return categoryChoices;
    }
    public List<SelectItem> getTermTypeChoices() {
        if (termChoicesCache == null) loadCache();

        String category = getRowCategory ();
        
        if (category == null || !termChoicesCache.containsKey(category)) return null;
        
        return (List<SelectItem>) termChoicesCache.get(category);
    }
    private String getRowCategory () {

        FacesContext fctx = FacesContext.getCurrentInstance();
        ELResolver er = fctx.getApplication().getELResolver();
        FacesCtrlHierNodeBinding val = (FacesCtrlHierNodeBinding) er.getValue (fctx.getELContext(), null, "row");
        Row row = val.getRow();
        if (row == null) return null;
        //String [] attrs = row.getAttributeNames();
        String category = (String) row.getAttribute("Category");
        
        //System.out.println ("Category is " + category);
        
        return category;
    }

    private void loadCache () {
        if (termChoicesCache != null) return;
        termChoicesCache = new HashMap ();
        categoryChoices = new ArrayList<SelectItem>();
        //emptyChoices = new ArrayList<SelectItem>();    
        
        BindingContainer bc = BindingContext.getCurrent().getCurrentBindingsEntry();
        FacesCtrlRangeBinding tv = (FacesCtrlRangeBinding) bc.getControlBinding("TermView1");
        CollectionModel cm = tv.getCollectionModel();

        for (int i = 0; i < cm.getRowCount(); i++) {
            ArrayList<SelectItem> termChoices;
            
            JUCtrlValueBindingRef data = (JUCtrlValueBindingRef) cm.getRowData(i);
            String category = (String) data.getRow().getAttribute("Category");
            String term = (String) data.getRow().getAttribute("Type");
            
            if (!termChoicesCache.containsKey(category)) {
                termChoices = new ArrayList<SelectItem>();
                termChoicesCache.put(category, termChoices);
                
                categoryChoices.add(newSelectItem(category, category));
            } else {
                termChoices = (ArrayList<SelectItem>) termChoicesCache.get(category);
            }
            
            termChoices.add(newSelectItem (term, term));
        }
    }

    private SelectItem newSelectItem(String label, String value) {
        SelectItem item = new SelectItem();
        item.setLabel (label);
        item.setValue (value);
        return item;

    }
    
}
