DROP TABLE QUOTE.CONTACTS CASCADE CONSTRAINTS;



CREATE TABLE QUOTE.CONTACTS

(

  OPPORTUNITYID  NUMBER                         NOT NULL,

  CONTACTNAME    VARCHAR2(80 BYTE),

  PHONENUMBER    VARCHAR2(40 BYTE),

  EMAIL          VARCHAR2(40 BYTE),

  TITLE          VARCHAR2(40 BYTE)

);



ALTER TABLE QUOTE.CONTACTS ADD (

  CONSTRAINT CONTACTS_FK1 

 FOREIGN KEY (OPPORTUNITYID) 

 REFERENCES QUOTE.OPPORTUNITY (OPPORTUNITYID)

    ON DELETE CASCADE);



DROP TABLE QUOTE.HTMLDB_PLAN_TABLE CASCADE CONSTRAINTS;



CREATE TABLE QUOTE.HTMLDB_PLAN_TABLE

(

  STATEMENT_ID       VARCHAR2(30 BYTE),

  PLAN_ID            NUMBER,

  TIMESTAMP          DATE,

  REMARKS            VARCHAR2(4000 BYTE),

  OPERATION          VARCHAR2(30 BYTE),

  OPTIONS            VARCHAR2(255 BYTE),

  OBJECT_NODE        VARCHAR2(128 BYTE),

  OBJECT_OWNER       VARCHAR2(30 BYTE),

  OBJECT_NAME        VARCHAR2(30 BYTE),

  OBJECT_ALIAS       VARCHAR2(65 BYTE),

  OBJECT_INSTANCE    INTEGER,

  OBJECT_TYPE        VARCHAR2(30 BYTE),

  OPTIMIZER          VARCHAR2(255 BYTE),

  SEARCH_COLUMNS     NUMBER,

  ID                 INTEGER,

  PARENT_ID          INTEGER,

  DEPTH              INTEGER,

  POSITION           INTEGER,

  COST               INTEGER,

  CARDINALITY        INTEGER,

  BYTES              INTEGER,

  OTHER_TAG          VARCHAR2(255 BYTE),

  PARTITION_START    VARCHAR2(255 BYTE),

  PARTITION_STOP     VARCHAR2(255 BYTE),

  PARTITION_ID       INTEGER,

  OTHER              LONG,

  DISTRIBUTION       VARCHAR2(30 BYTE),

  CPU_COST           INTEGER,

  IO_COST            INTEGER,

  TEMP_SPACE         INTEGER,

  ACCESS_PREDICATES  VARCHAR2(4000 BYTE),

  FILTER_PREDICATES  VARCHAR2(4000 BYTE),

  PROJECTION         VARCHAR2(4000 BYTE),

  TIME               INTEGER,

  QBLOCK_NAME        VARCHAR2(30 BYTE)

);



ALTER TABLE QUOTE.OPPORTUNITY DROP PRIMARY KEY CASCADE;



DROP TABLE QUOTE.OPPORTUNITY CASCADE CONSTRAINTS;



CREATE TABLE QUOTE.OPPORTUNITY

(

  OPPORTUNITYID   NUMBER                        NOT NULL,

  ACCOUNTNAME     VARCHAR2(200 BYTE),

  NEWCUSTOMER     VARCHAR2(100 BYTE),

  CUSTOMERTYPE    VARCHAR2(200 BYTE),

  INDUSTRY        VARCHAR2(200 BYTE),

  STREET          VARCHAR2(40 BYTE),

  STATE           VARCHAR2(40 BYTE),

  ZIP             VARCHAR2(10 BYTE),

  COUNTRY         VARCHAR2(40 BYTE),

  CITY            VARCHAR2(40 BYTE),

  PURCHASETODATE  NUMBER(9,2)

);





CREATE UNIQUE INDEX QUOTE.OPPORTUNITY_PK ON QUOTE.OPPORTUNITY

(OPPORTUNITYID);





ALTER TABLE QUOTE.OPPORTUNITY ADD (

  CONSTRAINT OPPORTUNITY_PK

 PRIMARY KEY

 (OPPORTUNITYID));



ALTER TABLE QUOTE.PRODUCT DROP PRIMARY KEY CASCADE;



DROP TABLE QUOTE.PRODUCT CASCADE CONSTRAINTS;



CREATE TABLE QUOTE.PRODUCT

(

  ID                     NUMBER                 NOT NULL,

  NAME                   VARCHAR2(200 BYTE),

  DESCRIPTION            VARCHAR2(4000 BYTE),

  CATEGORY               VARCHAR2(4000 BYTE),

  LIST_PRICE             NUMBER,

  RESTRICTED             VARCHAR2(1 BYTE),

  MIN_QTY                NUMBER,

  IMAGEURL               VARCHAR2(4000 BYTE),

  PRE_APPROVED_DISCOUNT  NUMBER

);



CREATE UNIQUE INDEX QUOTE.PRODUCT_PK ON QUOTE.PRODUCT(ID);



ALTER TABLE QUOTE.PRODUCT ADD (

  CONSTRAINT PRODUCT_PK

 PRIMARY KEY

 (ID));



ALTER TABLE QUOTE.PS_TXN DROP PRIMARY KEY CASCADE;



DROP TABLE QUOTE.PS_TXN CASCADE CONSTRAINTS;



CREATE TABLE QUOTE.PS_TXN

(

  ID             NUMBER(20),

  PARENTID       NUMBER(20),

  COLLID         NUMBER(10),

  CONTENT        BLOB,

  CREATION_DATE  DATE                           DEFAULT sysdate

);



CREATE UNIQUE INDEX QUOTE.PS_TXN_PK ON QUOTE.PS_TXN

(COLLID, ID);



ALTER TABLE QUOTE.PS_TXN ADD (

  CONSTRAINT PS_TXN_PK

 PRIMARY KEY

 (COLLID, ID));



ALTER TABLE QUOTE.TERM DROP PRIMARY KEY CASCADE;



DROP TABLE QUOTE.TERM CASCADE CONSTRAINTS;



CREATE TABLE QUOTE.TERM

(

  ID        NUMBER                              NOT NULL,

  CATEGORY  VARCHAR2(60 BYTE)                   NOT NULL,

  TYPE      VARCHAR2(60 BYTE)                   NOT NULL

);



CREATE UNIQUE INDEX QUOTE.TERM_PK ON QUOTE.TERM(ID);



ALTER TABLE QUOTE.TERM ADD (

  CONSTRAINT TERM_PK

 PRIMARY KEY

 (ID));



Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (20, 'PriceHoldOptions', 'FutureProgramPriceHolds');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (21, 'PriceHoldOptions', 'FutureDiscountProvisions');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (22, 'PriceHoldOptions', 'PriceHoldOnEntirePriceList');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (23, 'NonStandardPricingAndCurrencyOptions', 'ModificationsToContractualPricing');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (24, 'NonStandardPricingAndCurrencyOptions', 'Currency');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (25, 'NonStandardPricingAndCurrencyOptions', 'PreferredCustomerProvisions');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (26, 'NonStandardPricingAndCurrencyOptions', 'WaivingOrLoweringPurchaseMinimums');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (27, 'LicenseManagementServicesOptions', 'AuditWaivers');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (28, 'NonStandardLicensingOptions', 'CancelAndReplace');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (29, 'NonStandardLicensingOptions', 'DirectOrderFromCompetitors');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (30, 'NonStandardLicensingOptions', 'ReciprocalTransaction');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (31, 'NonStandardLicensingOptions', 'Hosting');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (32, 'NonStandardLicensingOptions', 'HostingRights');

Insert into QUOTE.TERM

   (ID, CATEGORY, TYPE)

 Values

   (33, 'NonStandardLicensingOptions', 'NDA');

COMMIT;



Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (21, 'EBiz', 'EBusiness Suite', NULL, 200000, 

    'n', NULL, NULL, 0.3);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (22, 'SOA Suite', 'SOA Suite', NULL, 55000, 

    'n', NULL, NULL, 0.3);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (23, 'BPM Suite', 'BPM Suite', NULL, 115000, 

    'n', NULL, NULL, 0.25);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (24, 'WebCenter Suite', 'Web Center Suite', NULL, 90000, 

    'n', NULL, NULL, 0.25);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (25, 'IPM', 'Imaging and Process Management', NULL, 75000, 

    'n', NULL, NULL, 0.4);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (26, 'UCM', 'Universal Content Management Suite', NULL, 100000, 

    'n', NULL, NULL, 0.45);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (27, 'BPEL PM', 'BPEL Process Manager', NULL, 100000, 

    'n', NULL, NULL, 0.45);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (28, 'PEOPLESOFT', 'PeopleSoft', NULL, 200000, 

    'n', NULL, NULL, 0.45);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (29, 'SIEBEL', 'Siebel', NULL, 150000, 

    'n', NULL, NULL, 0.45);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (30, 'FINANCIALS', 'Oracle Financials', NULL, 150000, 

    'n', NULL, NULL, 0.45);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (31, 'IDENTITY_MGMT', 'Oracle Identity Management', NULL, 100000, 

    'n', NULL, NULL, 0.45);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (32, 'DATABASE_STD', 'Oracle Database Standard Edition', NULL, 15000, 

    'n', NULL, NULL, 0.45);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (33, 'DATABASE_ENT', 'Oracle Database Enterprise Edition', NULL, 20000, 

    'n', NULL, NULL, 0.45);

Insert into QUOTE.PRODUCT

   (ID, NAME, DESCRIPTION, CATEGORY, LIST_PRICE, 

    RESTRICTED, MIN_QTY, IMAGEURL, PRE_APPROVED_DISCOUNT)

 Values

   (34, 'DATABASE_RAC', 'Oracle Database Enterprise Edition RAC', NULL, 30000, 

    'n', NULL, NULL, 0.45);



COMMIT;