package bpreviewui.backing;

import javax.el.ELResolver;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

import javax.faces.el.ValueBinding;

import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCIteratorBinding;

//import oracle.adfinternal.view.faces.model.binding.FacesCtrlHierNodeBinding;

import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.worklist.util.TaskFlowPropsUtil;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.task.impl.TaskUtil;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.worklist.WorklistLogger;
import oracle.bpel.services.workflow.worklist.adf.ADFWorklistBeanUtil;
import oracle.bpel.worklistapp.dc.ale.beans.view.ApprovalListEditorComp;
import oracle.bpel.worklistapp.dc.ale.util.ApprovalListUtil;

import oracle.jbo.AttributeDef;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;

import oracle.xml.jaxb.JaxbNode;

import org.w3c.dom.Document;
import org.w3c.dom.Element;


public class ApprovalTaskView {
    //private static String TASK_NS = "http://xmlns.oracle.com/bpel/workflow/task";
    private final static String APPROVAL_TASK_NS = "http://xmlns.oracle.com/SalesQuoteDemo/SalesQuoteProcess/ApproveDeal";
    private final static String TASK_ID_ATTR_NAME = "GUID";
    private final static String TASK_NS_ATTR_NAME = "Namespace";
    private final static String ITERATOR = "ApproveTaskInfoIterator";
    
    private ApprovalListEditorComp m_comp = null;

    private IWorkflowServiceClient m_wfSvcClient = null;
    private IWorkflowContext m_context = null;
    
    public ApprovalTaskView() {
        super();
        System.out.println ("************ Creating Approvaltask Flow Bean");
    }

    public void setComp(ApprovalListEditorComp m_comp) {
        this.m_comp = m_comp;
    }

    public ApprovalListEditorComp getComp() {
        if (m_comp == null)  init();
        return m_comp;
    }
    public boolean getShow () {
        if (m_comp == null)  init();
        if (m_comp == null) {
            return false;
        } else {
            return true;
        }
    }
     private void init() {

       WorklistLogger.log(WorklistLogger.DEBUG,
                          "** Enter ApprovalTaskView:init **");
       try {
         getAttrValue("OpportunityID", "SummaryIterator");
           
         String guid = getApprovalTaskGUID ();
         if (guid == null) return;
         initWfSvcClient ();
         if (m_wfSvcClient == null) return;
           
         Task approvalTask = createTaskObject(guid);      
         
         m_comp =
             ApprovalListUtil.getComponentInstance(approvalTask, m_context, m_wfSvcClient);
       } catch (Exception ex) {
         ex.printStackTrace();
       }
     }

     private Task createTaskObject(String correlationID) {
       Task task = null;
       try {
         task = new ObjectFactory().createTask();
         task.setTaskDefinitionId(getApprovalTaskNS ());
         task.setCorrelationId(correlationID);
         Element thisPayload = getThisTaskPayload();
           if (thisPayload != null) {
         Document doc = ((JaxbNode) task).getDOMNode().getOwnerDocument();
         Element newPayload = (Element) doc.importNode(thisPayload, true);
         task.setPayloadAsElement(newPayload);
           }
         System.out.println("******** Input Task object is ***********" +
                            TaskUtil.getInstance().toString(task));
       } catch (Exception exc) {
         exc.printStackTrace();
         FacesContext context = FacesContext.getCurrentInstance();
         context.addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_ERROR, exc.getMessage(),
                                             null));
       }
       return task;
     }
     private String getApprovalTaskGUID () {
            String guid = (String)getAttrValue(TASK_ID_ATTR_NAME, ITERATOR);
            return guid;
     }
     private String getApprovalTaskNS () {
            String ns = (String) getAttrValue(TASK_NS_ATTR_NAME, ITERATOR);
         return APPROVAL_TASK_NS;
     }
     private void initWfSvcClient () {
        if (m_wfSvcClient != null && m_context != null)
            return;

        try {
            String contextStr = ADFWorklistBeanUtil.getWorklistContextId();
            if (contextStr == null || contextStr.isEmpty())
                return;

            String lookupClient = TaskFlowPropsUtil.getLookupClientType();
            m_wfSvcClient =
                    TaskFlowPropsUtil.getWorkflowServiceClient(lookupClient);
            ITaskQueryService queryService =
                m_wfSvcClient.getTaskQueryService();
            m_context = queryService.getWorkflowContext(contextStr);
        } catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.getMessage());
        }
     }
     private Object getAttrValue (String attr, String iterator) {
         DCBindingContainer bc = (DCBindingContainer) BindingContext.getCurrent().getCurrentBindingsEntry();
         DCIteratorBinding dcib = bc.findIteratorBinding(iterator);        
         //System.out.println("After get iterator binding - " + dcib);
         
         RowSetIterator iter = dcib.getRowSetIterator();
         //System.out.println("After get row iterator - " + iter);
         Row row = iter.getRowAtRangeIndex(0);
         
         //System.out.println ("After get row " + row);
         Object ret =  row.getAttribute (attr);
         System.out.println ("In ApprovalTaskView:getAttrValue got " + ret + " for " +
                             attr + ":" + iterator);
        return ret;
     }    
     private Element getThisTaskPayload () {
         try {
         String taskId = ADFWorklistBeanUtil.getWorklistTaskId();
         ITaskQueryService queryService = m_wfSvcClient.getTaskQueryService();

         ADFWorklistBeanUtil.setLocaleAndTimezone(m_context, m_wfSvcClient);

         Task reviewTask = queryService.getTaskDetailsById(m_context, taskId);
         //System.out.println("******** Review task object is ***********" +
         //                   TaskUtil.getInstance().toString(reviewTask));

         Element payload = reviewTask.getPayloadAsElement();
         //System.out.println("Payload:" + XMLUtil.toString(payload));

        return payload;
         } catch (Exception ex) {
             System.out.println (ex.getMessage());
             return null;
         }
     }
}
