package integration.view;

import javax.faces.context.FacesContext;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.services.Authentication;
import weblogic.servlet.security.ServletAuthentication;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import java.io.IOException;


public class LoginBean {

    private String _username;
    private String _password;

    public LoginBean() {
        super();
    }

    public void setUsername(String _username) {
        this._username = _username;
    }

    public String getUsername() {
        return _username;
    }

    public void setPassword(String _password) {
        this._password = _password;
    }

    public String getPassword() {
        return _password;
    }

    public String doLogin() {
      String un = _username;
      byte[] pw = _password.getBytes();
      FacesContext ctx = FacesContext.getCurrentInstance();
      HttpServletRequest request =
        (HttpServletRequest)ctx.getExternalContext().getRequest();
      CallbackHandler handler = new SimpleCallbackHandler(un, pw);
      try {
        Subject mySubject = Authentication.login(handler);
         ServletAuthentication.runAs(mySubject, request);
         ServletAuthentication.generateNewSessionID(request);
         String loginUrl = "/adfAuthentication?success_url=/faces" + 
           ctx.getViewRoot().getViewId();
         HttpServletResponse response = 
           (HttpServletResponse)ctx.getExternalContext().getResponse();
         sendForward(request, response, loginUrl);
       } catch (FailedLoginException fle) {
         FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_ERROR,
                                            "Incorrect Username or Password",
                                            "An incorrect Username or Password" +
                                            " was specified");
         ctx.addMessage(null, msg);
       } catch (LoginException le) {
         reportUnexpectedLoginError("LoginException", le);
       }
       return null;
    }

    private void sendForward(HttpServletRequest request, 
                             HttpServletResponse response,
                             String forwardUrl){
      FacesContext ctx = FacesContext.getCurrentInstance();
      RequestDispatcher dispatcher = request.getRequestDispatcher(forwardUrl);
      try {
        dispatcher.forward(request, response);
      } catch (ServletException se) {
        reportUnexpectedLoginError("ServletException", se);
       } catch (IOException ie) {
         reportUnexpectedLoginError("IOException", ie);
       }
       ctx.responseComplete();
     }

    private void reportUnexpectedLoginError(String errType, Exception e){
      FacesMessage msg =
        new FacesMessage(FacesMessage.SEVERITY_ERROR, "Unexpected error during login",
                         "Unexpected error during login (" + errType + 
                         "), please consult logs for detail");
      FacesContext.getCurrentInstance().addMessage(null, msg);
      e.printStackTrace();
    }

}