package integration.view;

import java.util.HashMap;
import java.io.*;


import javax.el.ELContext;
import javax.el.ExpressionFactory;

import javax.el.ValueExpression;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;

import oracle.adf.model.BindingContext;
import oracle.binding.BindingContainer;



public class CheckInBean {
    private String fileName;
    private String fileContent;
    private HashMap primaryFile;
    
    public CheckInBean() {
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;    }

    public String getFileName() {
        return fileName;
    }


    public void setFileContent(String fileContent) {
        this.fileContent = fileContent;
    }

    public String getFileContent() {
        return fileContent;
    }


    public void setPrimaryFile(HashMap primaryFile) {
        this.primaryFile = primaryFile;
    }

    
    public HashMap getPrimaryFile() throws IOException {
        FacesContext facesCtx = FacesContext.getCurrentInstance();
        Application app = facesCtx.getApplication();
        ExpressionFactory elFactory = app.getExpressionFactory();
        ELContext elContext = facesCtx.getELContext();

        // gets the value from the managed bean
        fileName = elFactory.createValueExpression(elContext, "#{pageFlowScope.ReportBean.reportName}", Object.class).getValue(elContext).toString();

        // puts the file name and the content into a hash map
        HashMap hashMap = new HashMap();
        hashMap.put("fileName",fileName);
        hashMap.put("fileContent",getFileInBytes(ReportBean.reportPath, fileName));
        return hashMap;
    }

    private static byte[] getFileInBytes(String reportOutputPath, String fileName) throws IOException {
        File file = new File(reportOutputPath,fileName);
        InputStream inputStream = new FileInputStream(file);

        // Get the size of the file
        long size = file.length();

        // Check that size is not larger than Integer.MAX_VALUE
        if (size > Integer.MAX_VALUE) {
            System.out.println("File too large !!");
            return null;
        }
        
        // Read the bytes into the byte array
        byte[] byteArray = new byte[(int)size];
        System.out.println("New Byte Array");
        
        int offset = 0;
        int byteRead = 0;
        
        while ((offset < byteArray.length)
            &&
            ((byteRead=inputStream.read(byteArray, offset, byteArray.length-offset)) >= 0)){
                byteRead = offset + byteRead;
            }
        inputStream.close();
        return byteArray;
    }
}