package integration.view;

import java.util.HashMap;
import java.io.*;

import java.util.Properties;

import javax.el.ELContext;
import javax.el.ExpressionFactory;

import javax.el.MethodExpression;
import javax.el.ValueExpression;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;

import javax.faces.event.ActionEvent;

import oracle.adf.model.BindingContainer;
import oracle.adf.model.BindingContext;

import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCDataControl;

import oracle.adfinternal.model.adapter.webservice.WSDataControl;
import oracle.adfinternal.model.adapter.webservice.security.SecurityModel;

// import oracle.binding.BindingContainer;

import oracle.webservices.model.Port;


public class CheckInBean extends SecurityModel {
    private String fileName;
    private String fileContent;
    private HashMap primaryFile;
    String mSavedCSFKey = null;
    private String username;
    private String password;

    
    public CheckInBean() {
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;    }

    public String getFileName() {
        return fileName;
    }


    public void setFileContent(String fileContent) {
        this.fileContent = fileContent;
    }

    public String getFileContent() {
        return fileContent;
    }


    public void setPrimaryFile(HashMap primaryFile) {
        this.primaryFile = primaryFile;
    }

    
    public HashMap getPrimaryFile() throws IOException {
        FacesContext facesCtx = FacesContext.getCurrentInstance();
        Application app = facesCtx.getApplication();
        ExpressionFactory elFactory = app.getExpressionFactory();
        ELContext elContext = facesCtx.getELContext();

        // gets the value from the managed bean
        fileName = elFactory.createValueExpression(elContext, "#{pageFlowScope.ReportBean.reportName}", Object.class).getValue(elContext).toString();

        // puts the file name and the content into a hash map
        HashMap hashMap = new HashMap();
        hashMap.put("fileName",fileName);
        hashMap.put("fileContent",getFileInBytes(ReportBean.reportPath, fileName));
        return hashMap;
    }

    private static byte[] getFileInBytes(String reportOutputPath, String fileName) throws IOException {
        File file = new File(reportOutputPath,fileName);
        InputStream inputStream = new FileInputStream(file);

        // Get the size of the file
        long size = file.length();

        // Check that size is not larger than Integer.MAX_VALUE
        if (size > Integer.MAX_VALUE) {
            System.out.println("File too large !!");
            return null;
        }
        
        // Read the bytes into the byte array
        byte[] byteArray = new byte[(int)size];
        
        int offset = 0;
        int byteRead = 0;
        
        while ((offset < byteArray.length)
            &&
            ((byteRead=inputStream.read(byteArray, offset, byteArray.length-offset)) >= 0)){
                byteRead = offset + byteRead;
            }
        inputStream.close();
        return byteArray;
    }

    public void execute(ActionEvent aev) {
      FacesContext fctx = FacesContext.getCurrentInstance();
      Application app = fctx.getApplication();
      ExpressionFactory expF = app.getExpressionFactory();
     
      ValueExpression ve = expF.createValueExpression(fctx.getELContext(), "#{bindings}", DCBindingContainer.class);
      DCBindingContainer cont = (DCBindingContainer)ve.getValue(fctx.getELContext());
      DCDataControl dc = cont.findDataControl("CheckInECM");
      if(dc.getAdaptedDC() instanceof WSDataControl)
      {
        WSDataControl wsdc = (WSDataControl)dc.getAdaptedDC();
        wsdc.getProvider().setSecurityModel(this);
      }
    // execute the data control method, that was bound to this
    // button's action listener.
      MethodExpression me = expF.createMethodExpression(fctx.getELContext(),
                              "${bindings.CheckInUniversal.execute}", Object.class,
                                                        new Class[0]);
      me.invoke(fctx.getELContext(), null);
    }

    // override security properties for any policy on the current port
    // before the method execution.
    public void initSecurity(Port thisPort) {
      super.initSecurity(thisPort); 
      System.out.println(thisPort.hashCode());
      
    // resolves username and password from the LoginBean
      FacesContext fctx = FacesContext.getCurrentInstance();
      ELContext elctx = fctx.getELContext();
      Application app = fctx.getApplication();
      ExpressionFactory expFactory = app.getExpressionFactory();
      ValueExpression valueExp = expFactory.createValueExpression(elctx, "#{LoginBean.username}", Object.class);
      username = (String)valueExp.getValue(elctx);
      valueExp = expFactory.createValueExpression(elctx, "#{LoginBean.password}", Object.class);
      password = (String)valueExp.getValue(elctx);
      Properties callP = (Properties)this.getCallProperties(thisPort);
      callP.put("javax.xml.ws.security.auth.username", username);
      callP.put("javax.xml.ws.security.auth.password", password);
     
      mSavedCSFKey = (String)callP.remove("csf-key");
      this.saveCallProperties(thisPort, callP);
    }

    // Restore the config at the end of the request.
    public void clearSecurityParameters(Port thisPort) {
      super.clearSecurityParameters(thisPort);
      Properties callP = (Properties)this.getCallProperties(thisPort);
      callP.remove("javax.xml.ws.security.auth.username");
      callP.remove("javax.xml.ws.security.auth.password");
     
      //put back the saved csf key as default...
      callP.put("csf-key", mSavedCSFKey);
      this.saveCallProperties(thisPort, callP);
    }

}