/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.Datum;

public class OracleBlobInputStream
extends OracleBufferedStream {
    long lob_offset;
    Datum lob;
    long markedByte;
    boolean endOfStream = false;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040121";

    public OracleBlobInputStream(BFILE bFILE) throws SQLException {
        this(bFILE, ((PhysicalConnection)bFILE.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleBlobInputStream(BFILE bFILE, int n) throws SQLException {
        this(bFILE, n, 1L);
    }

    public OracleBlobInputStream(BFILE bFILE, int n, long l) throws SQLException {
        super(n);
        if (bFILE == null || n <= 0 || l < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.lob = bFILE;
        this.markedByte = -1L;
        this.lob_offset = l;
    }

    public OracleBlobInputStream(BLOB bLOB) throws SQLException {
        this(bLOB, ((PhysicalConnection)bLOB.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleBlobInputStream(BLOB bLOB, int n) throws SQLException {
        this(bLOB, n, 1L);
    }

    public OracleBlobInputStream(BLOB bLOB, int n, long l) throws SQLException {
        super(n);
        if (bLOB == null || n <= 0 || l < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.lob = bLOB;
        this.markedByte = -1L;
        this.lob_offset = l;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                DatabaseError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public synchronized void mark(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedByte = this.lob_offset - (long)this.count + (long)this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public boolean needBytes() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    this.count = this.lob instanceof BLOB ? ((BLOB)this.lob).getBytes(this.lob_offset, this.chunkSize, this.buf) : ((BFILE)this.lob).getBytes(this.lob_offset, this.chunkSize, this.buf);
                    if (this.count < this.chunkSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lob_offset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    DatabaseError.SQLToIOException(sQLException);
                }
            }
            return false;
        }
        return true;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.markedByte < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lob_offset = this.markedByte;
        this.pos = this.count;
        this.endOfStream = false;
    }

    public long skip(long l) throws IOException {
        long l2;
        block5: {
            this.ensureOpen();
            l2 = 0L;
            if ((long)(this.count - this.pos) >= l) {
                this.pos = (int)((long)this.pos + l);
                l2 += l;
            } else {
                l2 += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long l3 = 0L;
                    l3 = this.lob instanceof BLOB ? ((BLOB)this.lob).length() - this.lob_offset + 1L : ((BFILE)this.lob).length() - this.lob_offset + 1L;
                    if (l3 >= l - l2) {
                        this.lob_offset += l - l2;
                        l2 += l - l2;
                        break block5;
                    }
                    this.lob_offset += l3;
                    l2 += l3;
                }
                catch (SQLException sQLException) {
                    DatabaseError.SQLToIOException(sQLException);
                }
            }
        }
        return l2;
    }
}

