/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CLOB;

public class OracleClobWriter
extends Writer {
    DBConversion db_conversion;
    CLOB clob;
    long lob_offset;
    char[] charBuf;
    byte[] nativeBuf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040121";

    public OracleClobWriter(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getInternalConnection()).getDefaultStreamChunkSize() / 3, 1L);
    }

    public OracleClobWriter(CLOB cLOB, int n) throws SQLException {
        this(cLOB, n, 1L);
    }

    public OracleClobWriter(CLOB cLOB, int n, long l) throws SQLException {
        if (cLOB == null || n <= 0 || cLOB.getJavaSqlConnection() == null || l < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.db_conversion = ((PhysicalConnection)cLOB.getInternalConnection()).conversion;
        this.clob = cLOB;
        this.lob_offset = l;
        this.charBuf = new char[n];
        this.nativeBuf = new byte[n * 3];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = n;
        this.isClosed = false;
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.isClosed = true;
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DatabaseError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.count > 0) {
                    this.clob.putString((int)this.lob_offset, new String(this.charBuf, 0, this.count));
                    this.lob_offset += (long)this.count;
                    this.count = 0;
                }
            }
            catch (SQLException sQLException) {
                DatabaseError.SQLToIOException(sQLException);
            }
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n3 = n;
            int n4 = n3 + Math.min(n2, cArray.length - n);
            while (n3 < n4) {
                int n5 = Math.min(this.chunkSize - this.count, n4 - n3);
                System.arraycopy(cArray, n3, this.charBuf, this.count, n5);
                n3 += n5;
                this.count += n5;
                if (this.count < this.chunkSize) continue;
                this.flushBuffer();
            }
        }
    }
}

