/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSPatch;

public class StreamInfo {
    static final int KOPT_NONE_FINAL_TYPE = 1;
    static final int KOPT_JAVA_OBJECT = 2;
    int null_offset = 0;
    int lds_offset = 0;
    long fixed_data_size = 0L;
    Vector m_patches = null;
    byte[] m_tds;
    int m_beginIndex;
    int m_index;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040121";

    StreamInfo(byte[] byArray, long l) {
        this.m_tds = byArray;
        this.m_beginIndex = (int)l;
        this.m_index = (int)l;
    }

    long absolute_offset() throws SQLException {
        return this.m_index;
    }

    void addNormalPatch(long l, byte by, OracleType oracleType) throws SQLException {
        this.addPatch(new TDSPatch(0, oracleType, l, by));
    }

    void addPatch(TDSPatch tDSPatch) throws SQLException {
        if (this.m_patches == null) {
            this.m_patches = new Vector(5);
        }
        this.m_patches.addElement(tDSPatch);
    }

    void addSimplePatch(long l, OracleType oracleType) throws SQLException {
        this.addPatch(new TDSPatch(1, oracleType, l, 0));
    }

    void checkNextByte(byte by) throws SQLException {
        block2: {
            try {
                if (by == this.m_tds[this.m_index]) break block2;
                DatabaseError.throwSqlException(47, "parseTDS");
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.m_index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.m_index;
    }

    TDSPatch getNextPatch() throws SQLException {
        TDSPatch tDSPatch = null;
        if (this.m_patches != null && this.m_patches.size() > 0) {
            tDSPatch = (TDSPatch)this.m_patches.firstElement();
            this.m_patches.removeElementAt(0);
        }
        return tDSPatch;
    }

    boolean isFinalType(int n, byte by) {
        return n >= 3 && (by & 1) == 0;
    }

    boolean isJavaObject(int n, byte by) {
        return n >= 3 && (by & 2) != 0;
    }

    long moveToPatchPos(TDSPatch tDSPatch) throws SQLException {
        long l = tDSPatch.getPosition();
        if ((long)this.m_beginIndex + l > (long)this.m_tds.length) {
            DatabaseError.throwSqlException(47, "parseTDS");
        }
        this.skip_to(l);
        return l;
    }

    long offset() throws SQLException {
        return this.m_index - this.m_beginIndex;
    }

    byte readByte() throws SQLException {
        try {
            byte by = this.m_tds[this.m_index];
            Object var3_2 = null;
            ++this.m_index;
            return by;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_index;
            throw throwable;
        }
    }

    long readLong() throws SQLException {
        try {
            long l = (((this.m_tds[this.m_index] & 0xFF) * 256 + (this.m_tds[this.m_index + 1] & 0xFF)) * 256 + (this.m_tds[this.m_index + 2] & 0xFF)) * 256 + (this.m_tds[this.m_index + 3] & 0xFF);
            Object var4_2 = null;
            this.m_index += 4;
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.m_index += 4;
            throw throwable;
        }
    }

    short readShort() throws SQLException {
        try {
            short s = (short)((this.m_tds[this.m_index] & 0xFF) * 256 + (this.m_tds[this.m_index + 1] & 0xFF));
            Object var3_2 = null;
            this.m_index += 2;
            return s;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_index += 2;
            throw throwable;
        }
    }

    int readUnsignedByte() throws SQLException {
        try {
            int n = this.m_tds[this.m_index] & 0xFF;
            Object var3_2 = null;
            ++this.m_index;
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_index;
            throw throwable;
        }
    }

    void skipBytes(int n) throws SQLException {
        this.m_index += n;
    }

    void skip_to(long l) {
        this.m_index = this.m_beginIndex + (int)l;
    }

    byte[] tds() throws SQLException {
        return this.m_tds;
    }
}

