/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;

public class ARRAY
extends DatumWithConnection
implements Array {
    static final byte KOPUP_INLINE_COLL = 1;
    ArrayDescriptor m_descriptor;
    Object m_objArray;
    Datum[] m_datumArray;
    byte[] m_locator;
    byte m_prefixFlag;
    byte[] m_prefixSegment;
    int m_numElems = -1;
    boolean m_enableBuffering = false;
    boolean m_enableIndexing = false;
    public static final int ACCESS_FORWARD = 1;
    public static final int ACCESS_REVERSE = 2;
    public static final int ACCESS_UNKNOWN = 3;
    int m_accessDirection = 3;
    long m_lastIndex;
    long m_lastOffset;
    long[] m_indexArray;
    long m_imgOffset;
    long m_imgLength;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040121";

    public ARRAY(ArrayDescriptor arrayDescriptor, Connection connection, Object object) throws SQLException {
        DatumWithConnection.assertNotNull(arrayDescriptor);
        this.m_descriptor = arrayDescriptor;
        DatumWithConnection.assertNotNull(connection);
        if (!arrayDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            throw new SQLException("Cannot construct ARRAY instance, invalid connection");
        }
        arrayDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.m_datumArray = object == null ? new Datum[0] : this.m_descriptor.toOracleArray(object, 1L, -1);
    }

    public ARRAY(ArrayDescriptor arrayDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        DatumWithConnection.assertNotNull(arrayDescriptor);
        this.m_descriptor = arrayDescriptor;
        DatumWithConnection.assertNotNull(connection);
        if (!arrayDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            throw new SQLException("Cannot construct ARRAY instance, invalid connection");
        }
        arrayDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.m_datumArray = null;
        this.m_locator = null;
    }

    public int getAccessDirection() throws SQLException {
        return this.m_accessDirection;
    }

    public synchronized Object getArray() throws SQLException {
        return this.m_descriptor.toJavaArray(this, 1L, -1, this.getMap(), this.m_enableBuffering);
    }

    public synchronized Object getArray(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            DatabaseError.check_error(68, "getArray()");
        }
        return this.m_descriptor.toJavaArray(this, l, n, this.getMap(), false);
    }

    public synchronized Object getArray(long l, int n, Map map) throws SQLException {
        if (l < 1L || n < 0) {
            DatabaseError.check_error(68, "getArray()");
        }
        return this.m_descriptor.toJavaArray(this, l, n, map, false);
    }

    public synchronized Object getArray(Map map) throws SQLException {
        return this.m_descriptor.toJavaArray(this, 1L, -1, map, this.m_enableBuffering);
    }

    public boolean getAutoBuffering() throws SQLException {
        return this.m_enableBuffering;
    }

    public boolean getAutoIndexing() throws SQLException {
        return this.m_enableIndexing;
    }

    public synchronized int getBaseType() throws SQLException {
        return this.m_descriptor.getBaseType();
    }

    public synchronized String getBaseTypeName() throws SQLException {
        String string = this.m_descriptor.getBaseName();
        return string;
    }

    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.m_descriptor;
    }

    public synchronized double[] getDoubleArray() throws SQLException {
        return (double[])this.m_descriptor.toNumericArray(this, 1L, -1, 5, this.m_enableBuffering);
    }

    public synchronized double[] getDoubleArray(long l, int n) throws SQLException {
        return (double[])this.m_descriptor.toNumericArray(this, l, n, 5, false);
    }

    public synchronized float[] getFloatArray() throws SQLException {
        return (float[])this.m_descriptor.toNumericArray(this, 1L, -1, 6, this.m_enableBuffering);
    }

    public synchronized float[] getFloatArray(long l, int n) throws SQLException {
        return (float[])this.m_descriptor.toNumericArray(this, l, n, 6, false);
    }

    public long getImageLength() {
        return this.m_imgLength;
    }

    public long getImageOffset() {
        return this.m_imgOffset;
    }

    public synchronized int[] getIntArray() throws SQLException {
        return (int[])this.m_descriptor.toNumericArray(this, 1L, -1, 4, this.m_enableBuffering);
    }

    public synchronized int[] getIntArray(long l, int n) throws SQLException {
        return (int[])this.m_descriptor.toNumericArray(this, l, n, 4, false);
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public long getLastIndex() throws SQLException {
        return this.m_lastIndex;
    }

    public long getLastOffset() throws SQLException {
        return this.m_lastOffset;
    }

    public byte[] getLocator() {
        return this.m_locator;
    }

    public synchronized long[] getLongArray() throws SQLException {
        return (long[])this.m_descriptor.toNumericArray(this, 1L, -1, 7, this.m_enableBuffering);
    }

    public synchronized long[] getLongArray(long l, int n) throws SQLException {
        return (long[])this.m_descriptor.toNumericArray(this, l, n, 7, false);
    }

    public Map getMap() throws SQLException {
        return this.getInternalConnection().getTypeMap();
    }

    public long getOffset(long l) throws SQLException {
        long l2 = -1L;
        if (this.m_indexArray != null) {
            l2 = this.m_indexArray[(int)l - 1];
        }
        return l2;
    }

    public synchronized Datum[] getOracleArray() throws SQLException {
        return this.m_descriptor.toOracleArray(this, 1L, -1, this.m_enableBuffering);
    }

    public synchronized Datum[] getOracleArray(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            DatabaseError.check_error(68, "getOracleArray()");
        }
        return this.m_descriptor.toOracleArray(this, l, n, false);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        return this.getResultSet(this.getInternalConnection().getTypeMap());
    }

    public synchronized ResultSet getResultSet(long l, int n) throws SQLException {
        return this.getResultSet(l, n, this.getInternalConnection().getTypeMap());
    }

    public synchronized ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        if (l < 1L || n < -1) {
            DatabaseError.check_error(68, "getResultSet()");
        }
        return this.m_descriptor.toResultSet(this, l, n, map, false);
    }

    public synchronized ResultSet getResultSet(Map map) throws SQLException {
        return this.m_descriptor.toResultSet(this, 1L, -1, map, this.m_enableBuffering);
    }

    public synchronized String getSQLTypeName() throws SQLException {
        String string = null;
        if (this.m_descriptor != null) {
            string = this.m_descriptor.getName();
        } else {
            DatabaseError.check_error(61, "ARRAY");
        }
        return string;
    }

    public synchronized short[] getShortArray() throws SQLException {
        return (short[])this.m_descriptor.toNumericArray(this, 1L, -1, 8, this.m_enableBuffering);
    }

    public synchronized short[] getShortArray(long l, int n) throws SQLException {
        return (short[])this.m_descriptor.toNumericArray(this, l, n, 8, false);
    }

    public boolean hasDataSeg() {
        return this.m_locator == null;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public boolean isInline() {
        return (this.m_prefixFlag & 1) == 1;
    }

    public synchronized int length() throws SQLException {
        return this.m_descriptor.toLength(this);
    }

    public Object makeJdbcArray(int n) {
        return new Object[n][];
    }

    public synchronized void setAutoBuffering(boolean bl) throws SQLException {
        this.m_enableBuffering = bl;
    }

    public synchronized void setAutoIndexing(boolean bl) throws SQLException {
        this.m_enableIndexing = bl;
        this.m_accessDirection = 3;
    }

    public synchronized void setAutoIndexing(boolean bl, int n) throws SQLException {
        this.m_enableIndexing = bl;
        this.m_accessDirection = n;
    }

    public synchronized void setDatumArray(Datum[] datumArray) {
        this.m_datumArray = datumArray;
    }

    public void setImage(byte[] byArray, long l, long l2) throws SQLException {
        this.setShareBytes(byArray);
        this.m_imgOffset = l;
        this.m_imgLength = l2;
    }

    public void setImageLength(long l) throws SQLException {
        this.m_imgLength = l;
    }

    public void setIndexOffset(long l, long l2) throws SQLException {
        if (this.m_indexArray == null) {
            this.m_indexArray = new long[this.m_numElems];
        }
        this.m_indexArray[(int)l - 1] = l2;
    }

    public void setLastIndexOffset(long l, long l2) throws SQLException {
        this.m_lastIndex = l;
        this.m_lastOffset = l2;
    }

    public synchronized void setLength(int n) {
        this.m_numElems = n;
    }

    public synchronized void setLocator(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.m_locator = byArray;
        }
    }

    public synchronized void setObjArray(Object object) throws SQLException {
        if (object == null) {
            DatabaseError.throwSqlException(1);
        }
        this.m_objArray = object;
    }

    public synchronized void setPrefixFlag(byte by) {
        this.m_prefixFlag = by;
    }

    public synchronized void setPrefixSegment(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.m_prefixSegment = byArray;
        }
    }

    public static ARRAY toARRAY(Object object, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        ARRAY aRRAY = null;
        if (object != null) {
            if (object instanceof ARRAY) {
                aRRAY = (ARRAY)object;
            } else if (object instanceof ORAData) {
                aRRAY = (ARRAY)((ORAData)object).toDatum(oracleConnection);
            } else if (object instanceof CustomDatum) {
                aRRAY = (ARRAY)((OracleConnection)oracleConnection).toDatum((CustomDatum)object);
            } else {
                DatabaseError.check_error(59, object);
            }
        }
        return aRRAY;
    }

    public synchronized byte[] toBytes() throws SQLException {
        return this.m_descriptor.toBytes(this, this.m_enableBuffering);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }
}

