/*
 * Created on May 17, 2005
 * 
 * Class: BroadcastDriver 
 * 
 * The driving class which is called
 * to create a spreadsheet based upon a set of database 
 * connections and a SQL statement.
 */
package com.saternos.database.utilities.broadcast;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

import javax.xml.transform.TransformerException;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/**
 * @author csaternos
 * 
 */
public class BroadcastDriver {

	public static void main(String[] args) throws TransformerException {

		/*
		 * Create a new workbook
		 */
		HSSFWorkbook wb = new HSSFWorkbook();

		/*
		 * Read in the configuration information
		 * (connections and an SQL query) 
		 * found in the config.xml file
		 */
		XMLConfigVO cnf = new XMLConfigVO();
		String query = cnf.getSqlStatement();
		List conns = cnf.getConnects();
		
		/*
		 * Iterate through the connections and create
		 * a sheet based upon the results returned by
		 * executing the SQL against each database
		 */
		Iterator iter = conns.iterator();
		while (iter.hasNext()) {
			OracleConnectionVO conn = (OracleConnectionVO) iter.next();
			/*
			 * Set the Driver, database jdbc url, database username,
			 * database password for the user, the query to be
			 * executed, and the name of the sheet... which will be
			 * in the form <servername>-<database name>.  Then populate
			 * the sheet.
			 */
			POISheetGenerator sg = new POISheetGenerator();
			sg.setDriver(conn.getDriverName());
			sg.setUrl(conn.getUrl());
			sg.setUsername(conn.getUsername());
			sg.setPassword(conn.getPassword());
			sg.setQuery(query);
			sg.setSheetname(conn.getServerName() + "-" + conn.getSid());
			sg.populateSheet(wb);
		}

		/*
		 * Write the workbook to the file system
		 */
		writeWorkbook(wb);

	}

	/**
	 * Utility function to write the workbook to the 
	 * file system
	 * @param wb
	 */
	private static void writeWorkbook(HSSFWorkbook wb) {
		try {
			OutputStream out;
			out = new FileOutputStream("output.xls");
			wb.write(out);
			out.close();
		} catch (Exception e) {

			e.printStackTrace();
		}
	}

	/**
	 *  Centralize logging to this function
	 */
	public static void log(String input) {

		if (input == null)
			input = "";
		else
			input = input.trim();

		System.out.println(input);
	}

}