/*
 * Created on Mar 28, 2005
 *
 *	Class: OracleConnectionVO
 *
 *  A value object that holds all of the component strings
 *  required to make an Oracle jdbc database connection
 */
package com.saternos.database.utilities.broadcast;

/**
 * @author csaternos
 *
 */
public class OracleConnectionVO {

	/** 
	 * JDBC driver class name
	 */
    String driverName = "oracle.jdbc.driver.OracleDriver";
    
    /**
     *  Standard Oracle Listener port
     */
    String portNumber = "1521";
    
    /**
     * Name of the server on which the database resides
     */
    String serverName = null;
    
    /**
     * Oracle database name
     */
    String sid = null;
    
    /**
     * Database user
     */
    String username = null;
    
    /**
     * Database password
     */
    String password = null;
       

	/**
	 * @return Returns the driverName.
	 */
	public String getDriverName() {
		return driverName;
	}
	/**
	 * @param driverName The driverName to set.
	 */
	public void setDriverName(String driverName) {
		this.driverName = driverName;
	}
	/**
	 * @return Returns the password.
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * @param password The password to set.
	 */
	public void setPassword(String password) {
		this.password = password;
	}
	/**
	 * @return Returns the portNumber.
	 */
	public String getPortNumber() {
		return portNumber;
	}
	/**
	 * @param portNumber The portNumber to set.
	 */
	public void setPortNumber(String portNumber) {
		this.portNumber = portNumber;
	}
	/**
	 * @return Returns the serverName.
	 */
	public String getServerName() {
		return serverName;
	}
	/**
	 * @param serverName The serverName to set.
	 */
	public void setServerName(String serverName) {
		this.serverName = serverName;
	}
	/**
	 * @return Returns the sid.
	 */
	public String getSid() {
		return sid;
	}
	/**
	 * @param sid The sid to set.
	 */
	public void setSid(String sid) {
		this.sid = sid;
	}
	/**
	 * @return Returns the url.
	 */
	public String getUrl() {
		return "jdbc:oracle:thin:@" + serverName + ":" + portNumber + ":" + sid;
	}
	
	/**
	 * @return Returns the username.
	 */
	public String getUsername() {
		return username;
	}
	/**
	 * @param username The username to set.
	 */
	public void setUsername(String username) {
		this.username = username;
	}
}
