/*
 * Created on May 19, 2005
 *
 * Class: POISheetGenerator
 * 
 * Generates a POI HSSFSheet based upon a SQL query and
 * a database connection
 */
package com.saternos.database.utilities.broadcast;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/**
 * @author csaternos
 * 
 */
public class POISheetGenerator {

	/*
	 * Oracle database driver class name
	 */
	private String driver;

	/*
	 * Oracle database user name
	 */
	private String username;

	/*
	 * Oracle datbase password
	 */
	private String password;

	/*
	 * Oracle database jdbc url
	 */
	private String url;

	/*
	 * SQL query
	 */
	private String query;

	/*
	 * The name that will be assigned to the particular sheet
	 * in the workbook (spreadsheet).
	 */
	private String sheetname;


	/**
	 * Populate a sheet of the workbook based upon the results
	 * of a query and specified connection information
	 * @param wb
	 */
	public void populateSheet(HSSFWorkbook wb) {
		Connection connection = null;

		//
		// Font Style Bold used for the column headers
		//
		HSSFFont boldFont = wb.createFont();
		boldFont.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		HSSFCellStyle boldStyle = wb.createCellStyle();
		boldStyle.setFont(boldFont);

		try {

			// Open the connection
			Class.forName(driver);
			BroadcastDriver.log(url);
			connection = DriverManager.getConnection(url, username, password);

			// Execute the statement
			BroadcastDriver.log(query);
			Statement stmt = connection.createStatement();
			ResultSet rs = stmt.executeQuery(query);
			
			//
			//Get the metadata which is needed to determine the
			//number of columns that we need to iterate through
			//as well as the column names
			//
			ResultSetMetaData md = rs.getMetaData();

			//Create the sheet
			int excelRow = 0;
			HSSFSheet sheet = wb.createSheet(sheetname);
			BroadcastDriver.log("Sheet: " + sheetname + " created.");
			BroadcastDriver.log("------------------------------");
			
			// Create the first row for column headers
			HSSFRow row = sheet.createRow((short) excelRow);

			// Set the values of the column headers (in bold)
			for (int i = 1; i <= md.getColumnCount(); i++) {
				int x=i-1; //POI starts with 0
				row.createCell((short) x).setCellValue(md.getColumnName(i));
				row.getCell((short) x).setCellStyle(boldStyle);
			}

			//
			// Each row of the sheet
			//
			while (rs.next()) {
				//create a new row
				excelRow++;
				row = sheet.createRow((short) excelRow);

				//create each cell in the row
				for (int i = 1; i <= md.getColumnCount(); i++) {
					int x=i-1; //POI starts with 0
					if (rs.getObject(i) != null)

						/*
						 * We try to create the cell as a number (java Long). If
						 * that fails, we just toString the data.
						 */
						try {
							row.createCell((short) x).setCellValue(
									Long.parseLong(rs.getObject(i).toString()));
						} catch (NumberFormatException e) {
							row.createCell((short) x).setCellValue(
									rs.getObject(i).toString());
						}
				}
			}
			connection.close();
		} catch (SQLException se) {
			se.printStackTrace();
		} catch (ClassNotFoundException ce) {
			BroadcastDriver.log("Driver not found: " + driver + " " + ce);
		}
	}
	
	/**
	 * @param sheetname
	 */
	public void setSheetname(String sheetname) {
		this.sheetname = sheetname;
	}
	
	/**
	 * @param driver
	 */
	public void setDriver(String driver) {
		this.driver = driver;
	}

	/**
	 * @param password
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @param query
	 */
	public void setQuery(String query) {
		this.query = query;
	}

	/**
	 * @param url
	 */
	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * @param username
	 */
	public void setUsername(String username) {
		this.username = username;
	}
}