/*
 * Created on May 19, 2005
 * 
 * Class: XMLConfigVO
 * 
 * Read the data (connection info and a SQL query) from 
 * an XML configuration file using
 * XPath.
 */
package com.saternos.database.utilities.broadcast;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.sun.org.apache.xpath.internal.XPathAPI;

/**
 * @author csaternos
 * 
 */
public class XMLConfigVO {

	private String configFileName = "config.xml";

	private List connects = null;

	private String sqlStatement;

	public XMLConfigVO() throws TransformerException {
		//Read the Configuration file in
		Document doc = readDocument(configFileName);
		connects = getConnects(doc, "//broadcast/connection-config/database");
		sqlStatement = getSqlStatement(doc, "//broadcast/sql-statement");
	}

	/**
	 * @param string
	 * @return
	 */
	private Document readDocument(String filename) {
		try {

			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();
			factory.setValidating(false);
			Document doc = factory.newDocumentBuilder().parse(
					new File(filename));
			return doc;

		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * @return
	 * @throws TransformerException
	 */
	private List getConnects(Document doc, String path)
			throws TransformerException {

		NodeList nodelist = XPathAPI.selectNodeList(doc, path);
		connects = new ArrayList();
		// Process the elements in the nodelist
		for (int i = 0; i < nodelist.getLength(); i++) {
			// Get element
			Element elem = (Element) nodelist.item(i);
			OracleConnectionVO vo = new OracleConnectionVO();

			for (int j = 0; j < elem.getChildNodes().getLength(); j++) {
				Node elem2 = (Node) elem.getChildNodes().item(j);

				if (elem2.getNodeName().equalsIgnoreCase("server-name"))
					vo.setServerName(elem2.getFirstChild().getNodeValue());

				if (elem2.getNodeName().equalsIgnoreCase("port"))
					vo.setPortNumber(elem2.getFirstChild().getNodeValue());

				if (elem2.getNodeName().equalsIgnoreCase("sid"))
					vo.setSid(elem2.getFirstChild().getNodeValue());

				if (elem2.getNodeName().equalsIgnoreCase("username"))
					vo.setUsername(elem2.getFirstChild().getNodeValue());

				if (elem2.getNodeName().equalsIgnoreCase("password")) {
					vo.setPassword(elem2.getFirstChild().getNodeValue());
				}
			}
			connects.add(vo);
		}
		return connects;
	}

	private String getSqlStatement(Document doc, String xpath)
			throws TransformerException {

		NodeList nodelist = XPathAPI.selectNodeList(doc, xpath);
		Element elem = (Element) nodelist.item(0);
		return elem.getFirstChild().getNodeValue();
	}

	public List getConnects() {
		return connects;
	}

	public String getSqlStatement() {
		return sqlStatement;
	}
}