/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.util.RKUtil;
import org.apache.poi.util.LittleEndian;

public class RKRecord
extends Record
implements CellValueRecordInterface {
    public static final short sid = 638;
    public static final short RK_IEEE_NUMBER = 0;
    public static final short RK_IEEE_NUMBER_TIMES_100 = 1;
    public static final short RK_INTEGER = 2;
    public static final short RK_INTEGER_TIMES_100 = 3;
    private short field_1_row;
    private short field_2_col;
    private short field_3_xf_index;
    private int field_4_rk_number;

    public RKRecord() {
    }

    public RKRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public RKRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 638) {
            throw new RecordFormatException("NOT A valid RK RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_row = LittleEndian.getShort(data, 0 + offset);
        this.field_2_col = LittleEndian.getShort(data, 2 + offset);
        this.field_3_xf_index = LittleEndian.getShort(data, 4 + offset);
        this.field_4_rk_number = LittleEndian.getInt(data, 6 + offset);
    }

    public short getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_col;
    }

    public short getXFIndex() {
        return this.field_3_xf_index;
    }

    public int getRKField() {
        return this.field_4_rk_number;
    }

    public short getRKType() {
        return (short)(this.field_4_rk_number & 3);
    }

    public double getRKNumber() {
        return RKUtil.decodeNumber(this.field_4_rk_number);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[RK]\n");
        buffer.append("    .row            = ").append(Integer.toHexString(this.getRow())).append("\n");
        buffer.append("    .col            = ").append(Integer.toHexString(this.getColumn())).append("\n");
        buffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        buffer.append("    .rknumber       = ").append(Integer.toHexString(this.getRKField())).append("\n");
        buffer.append("        .rktype     = ").append(Integer.toHexString(this.getRKType())).append("\n");
        buffer.append("        .rknumber   = ").append(this.getRKNumber()).append("\n");
        buffer.append("[/RK]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        NumberRecord rec = new NumberRecord();
        rec.setColumn(this.getColumn());
        rec.setRow(this.getRow());
        rec.setValue(this.getRKNumber());
        rec.setXFIndex(this.getXFIndex());
        return rec.serialize(offset, data);
    }

    public static void main(String[] ignored_args) {
        int[] values = new int[]{0x3FF00000, 1079951361, 49382714, 49382715, -52598374};
        double[] rvalues = new double[]{1.0, 1.23, 1.2345678E7, 123456.78, -1.3149594E7};
        int j = 0;
        while (j < values.length) {
            System.out.println("input = " + Integer.toHexString(values[j]) + " -> " + rvalues[j] + ": " + RKUtil.decodeNumber(values[j]));
            ++j;
        }
    }

    public short getSid() {
        return 638;
    }

    public boolean isBefore(CellValueRecordInterface i) {
        if (this.getRow() > i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() > i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    public boolean isAfter(CellValueRecordInterface i) {
        if (this.getRow() < i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() < i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    public boolean isEqual(CellValueRecordInterface i) {
        return this.getRow() == i.getRow() && this.getColumn() == i.getColumn();
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public void setColumn(short col) {
    }

    public void setRow(short row) {
    }

    public void setXFIndex(short xf) {
    }
}

