/*
*An example of harvesting connections
*/

import java.sql.*; 
import oracle.ucp.jdbc.PoolDataSourceFactory;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.ConnectionHarvestingCallback;

public class ConnectionHarvesting {
  public static void main(String argv[]) {
   try { 
    //Creating a pool-enabled data source
    PoolDataSource pds = PoolDataSourceFactory.getPoolDataSource();
    //Setting connection properties of the data source
    pds.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
    pds.setURL("jdbc:oracle:thin:@//localhost:1521/XE");
    pds.setUser("hr");
    pds.setPassword("hr");
    //Setting pool properties
    pds.setInitialPoolSize(10);
    pds.setMaxPoolSize(20);
    //Enabling the connection harvesting feature
    pds.setConnectionHarvestTriggerCount(5);
    pds.setConnectionHarvestMaxCount(2);
    //Creating an array of Connection objects
    Connection[] conn = new Connection[5];
    //Creating an array of callback objects
    CustConnectionHarvestingCallback[] callbk = new CustConnectionHarvestingCallback[5];
    //Borrowing four connections from the pool
    for (int i = 0; i < 4; i++)
    {
      conn[i] = pds.getConnection();
      //Registering the callback object with each connection
      callbk[i] = new CustConnectionHarvestingCallback(conn[i]); 
      ((HarvestableConnection) conn[i]).registerConnectionHarvestingCallback(callbk[i]);
    }
    //Setting conn[0] as non-harvestable 
    ((HarvestableConnection) conn[0]).setConnectionHarvestable(false);
    //Borrowing the fifth connection to trigger harvesting
    conn[4] = pds.getConnection();
    callbk[4] = new CustConnectionHarvestingCallback(conn[4]);
    ((HarvestableConnection) conn[4]).registerConnectionHarvestingCallback(callbk[4]);

    System.out.println("Connections available in the pool: " + pds.getAvailableConnectionsCount());
    System.out.println("Connections borrowed : " + pds.getBorrowedConnectionsCount());

    // Waiting for harvesting to happen
    Thread.sleep(30000);
    //Checking connections
    for (int i = 0; i < 5; i++)
    {
      System.out.println("Connection " + i + " returned to the pool - " + conn[i].isClosed());
    }
    System.out.println("Connections available in the pool: " + pds.getAvailableConnectionsCount());
    System.out.println("Connections borrowed : " + pds.getBorrowedConnectionsCount());
   } catch (Exception e) { 
      System.out.println("\nException: " + e); 
    }
  }
}
//Implementation of the ConnectionHarvestingCallback abstract interface
class CustConnectionHarvestingCallback implements ConnectionHarvestingCallback
{
  private Connection conn = null;
  public CustConnectionHarvestingCallback(Connection conn)
  {
    this.conn = conn;
  }
  public boolean cleanup()
  {
    try
    {
      conn.close();
    }
    catch (Exception e)
    {
      return false;
    }
    return true;
  }
}
