/*
*An example of validating connections on borrow;
*this also shows the use of the ValidConnection interface's methods:
*isValid and setInvalid methods in combination with a retry mechanism
*/

import java.sql.*; 
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.ValidConnection;
import javax.naming.*; 
import java.util.Hashtable; 

public class ConnectionValidating {
  public static void main(String argv[]) {
    PoolDataSource pds;
    //Looking up for the jdbc/HRPool pool-enabled data source registered in JNDI tree
    try { 
      Hashtable env = new Hashtable(); 
      env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.fscontext.RefFSContextFactory");
      Context ctx = new InitialContext(env); 
      pds = (PoolDataSource) ctx.lookup("jdbc/HRPool"); 
    }
    catch (NamingException eName) { 
      System.out.println("Cannot look up " +  "jdbc/HRPool" + ": " +eName); 
      return; 
    }
    try { 
      //Instructing the pool to validate connections on borrow
      pds.setValidateConnectionOnBorrow(true);
      //Calling the getUser method that borrows a connection from the pool
      //limiting the number of recursive calls to 3
      System.out.println("\nConnected as :"+getUser(pds, 3));
    }
    catch (SQLException eSQL) { 
      System.out.println("\nSQLException: " + eSQL); 
      return; 
    }
  }
  //This method borrows a connection from the pool and will make a recursive call 
  //if it turns out the borrowed connection has become unusable
  private static String getUser (PoolDataSource pds, int recursiveCalls) throws SQLException {
    Connection conn = null;
    Statement stmt = null;
    ResultSet rs = null;
    String user = null;
    try {
      //Borrowing a connection from the pool
      conn = pds.getConnection(); 
      //Working with the connection
      stmt =  conn.createStatement();
      rs = stmt.executeQuery("select user from dual");
      while(rs.next())
        user = rs.getString(1);
      if (conn != null)
        conn.close();
    } 
    catch (SQLException eSQL) {
      if (recursiveCalls > 0 && !((ValidConnection) conn).isValid()) {
          System.out.println("\nConnection is no longer valid: " + eSQL);
          //Calling setInvalid often leads to an exception
          //so it's a wise idea to put it in a separate try block
          try {
            ((ValidConnection) conn).setInvalid();
          } catch (SQLException conEx) {
            System.out.println("\nInvalidating failed: " + conEx); 
          }
          conn.close();
          conn = null; 
          System.out.println("\nRetrying to obtain a new connection");
          //making a recurive call to getUser in an attempt to obtain a valid connection
          //the number of recursive calls allowed is reduced by 1
          user = getUser(pds, recursiveCalls - 1);
       } else {
          System.out.println("\nSQLException: " + eSQL);  
       }
    }
    finally {
       return user; 
    }     
  }
}
