/*
*An example of using UCP for JDBC with Fast Connection Failover
*/
import java.sql.*;
import oracle.ucp.jdbc.*;

public class FcfUcp {
  public static void main(String[] args) {
  try {
   //Creating a pool-enabled data source
    PoolDataSource pds = PoolDataSourceFactory.getPoolDataSource();
   //Setting pool properties
    pds.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
   //Setting a RAC-specific URL
    pds.setURL(
      "jdbc:oracle:thin:@" +
      "(DESCRIPTION=(ADDRESS_LIST=(LOAD_BALANCE=ON)" +
      "(ADDRESS=(PROTOCOL=TCP)" +
      "(HOST=rachost1)(PORT=1521))" +
      "(ADDRESS=(PROTOCOL=TCP)" +
      "(HOST=rachost2)(PORT=1521)))" +
      "(CONNECT_DATA=(SERVICE_NAME=orcl)))"); 
    pds.setUser("usr");
    pds.setPassword("pswd");
    pds.setMinPoolSize(10);
    pds.setMaxPoolSize(20);
    //Configuring remote ONS subscription
    pds.setONSConfiguration("nodes=rachost1:4200,rachost2:4200");
    // Enabling Fast Connection Failover
    pds.setFastConnectionFailoverEnabled(true);

    Connection conn = pds.getConnection();
    Statement stmt = conn.createStatement();
    ResultSet rs = null;

    boolean retry = true;
    while(retry)
    {
      try
      {
        //Getting a RAC connection from the pool
        conn = pds.getConnection();
        // Executing a query on the connection.
        rs = stmt.executeQuery("select user from dual");
        rs.next();
        System.out.println("\nConnected as : " + rs.getString(1));
        //Setting retry to false to exit the loop
        retry = false;
      }
      catch (SQLException eSQL)
      {
        System.out.println("\nSQLException: " + eSQL);
        // Checking connection usability after a RAC-down event triggers UCP FCF actions
        if (conn == null || !((ValidConnection) conn).isValid())
        {
          //Closing the connection
          try
          {
            conn.close();
          }
          catch (SQLException eClose)
          {
            System.out.println("\nException arose when closing connection: " + eClose);
          }
          //Setting retry to true to try again
          retry = true;
        }
      }
      Thread.sleep(1000);
    } //while
  }
  catch(Exception e)
  {
    e.printStackTrace();
  }
 }
}

