/*
*An example of a JNDI lookup for
* a pool-enabled data source 
*/

import java.sql.*; 
import oracle.ucp.jdbc.PoolDataSource;
import javax.naming.*; 
import java.util.Hashtable; 

public class JNDILookup {
  public static void main(String argv[]) {
    PoolDataSource pds;
    //Performing a lookup for a pool-enabled data source registered in JNDI tree
    try { 
      Hashtable env = new Hashtable(); 
      env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.fscontext.RefFSContextFactory");
      Context ctx = new InitialContext(env); 
      pds = (PoolDataSource) ctx.lookup("jdbc/HRPool"); 
    }
    catch (NamingException eName) { 
      System.out.println("Cannot look up " +  "jdbc/HRPool" + ": " +eName); 
       return; 
    }
    //Borrowing a connection from the data source returned by the JNDI lookup
    try { 
      Connection conn = pds.getConnection(); 
      Statement stmt = conn.createStatement();
      ResultSet rs = stmt.executeQuery("select user from dual");
      while(rs.next())
        System.out.println("\nConnected as: "+rs.getString(1));
      if (conn != null) 
        conn.close(); 
    } 
    catch (SQLException eSQL) { 
      System.out.println("Cannot obtain a connection: " + eSQL); 
    } 
    return; 
  }
}




