/*
*An example of how you can register
* a pool-enabled data source to JNDI
*/
import oracle.ucp.jdbc.PoolDataSourceFactory;
import oracle.ucp.jdbc.PoolDataSource;
import javax.naming.*; 
import java.util.Hashtable; 

public class JNDIRegister { 
   public static void main(String argv[]) { 
      try { 
        //Creating a pool-enabled data source instance and setting its properties 
        PoolDataSource pds = PoolDataSourceFactory.getPoolDataSource();
        pds.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
        pds.setURL("jdbc:oracle:thin:@//localhost:1521/XE");
        pds.setUser("hr");
        pds.setPassword("hr");
        pds.setInitialPoolSize(5);
        pds.setMinPoolSize(5);
        pds.setMaxPoolSize(10);
        //Registering the data source to JNDI
        Hashtable env = new Hashtable(); 
        env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.fscontext.RefFSContextFactory"); 
        Context ctx = new InitialContext(env); 
        ctx.bind("jdbc/HRPool", pds);
      }
      catch (Exception e) { 
        System.out.println(e); 
      } 
   } 
}
