/*
*An example showing statement pooling 
*/

import java.sql.*; 
import oracle.ucp.jdbc.PoolDataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import javax.naming.*; 
import java.util.Hashtable; 

public class StatementPooling {
  public static void main(String argv[]) {
    PoolDataSource pds;
    //Looking up for the jdbc/HRPool pool-enabled data source registered in JNDI tree
    try { 
      Hashtable env = new Hashtable(); 
      env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.fscontext.RefFSContextFactory");
      Context ctx = new InitialContext(env); 
      pds = (PoolDataSource) ctx.lookup("jdbc/HRPool"); 
    }
    catch (NamingException eName) { 
      System.out.println("Cannot look up " +  "jdbc/HRPool" + ": " +eName); 
       return; 
    }
    try {
      //Enabling statement caching for the pool's connections 
      pds.setMaxStatements(10); 
      //Borrowing a connection from the pool
      OracleConnection conn = (OracleConnection) pds.getConnection(); 
      //Checking if the implicit statement caching is enabled
      if (conn.getImplicitCachingEnabled())
        System.out.println("\nimplicit caching enabled"); 
      else
        System.out.println("\nimplicit caching disabled"); 

      //Looping through calls to the getRegion private class method that executes a prepared statement
      for (int i = 1; i < 5; i++ ) {
        System.out.println("\n" + getRegion(conn, i));
      }
      //Returning the connectin to the pool
      if (conn != null) 
        conn.close();
        conn = null;
    } 
    catch (SQLException eSQL) { 
      System.out.println("Cannot obtain a connection: " + eSQL); 
    } 
  }
  //This method creates, executes and then closes a prepared statement
  private static String getRegion (OracleConnection conn, int region_id ) throws SQLException {
    OraclePreparedStatement stmt = null;
    ResultSet rs = null;
    String region = null;
    String sql = "SELECT * FROM regions WHERE region_id = ?";   
    try {
      stmt = (OraclePreparedStatement)conn.prepareStatement(sql);
      //Checking the creation state of the prepared statement
      int creationState = stmt.creationState();
      switch(creationState) {
        case 0:
          System.out.println("\nCreation state: new");
          break;
        case 1:
          System.out.println("\nCreation state: from the implicit cache");   
          break;
        case 2:
          System.out.println("\nCreation state: from the explicit cache"); 
          break;
      }
      
      stmt.setInt(1, region_id);
      rs = stmt.executeQuery();
      rs.next();
      region = rs.getString("REGION_NAME");
    } 
    catch (SQLException eSQL) {
      System.out.println("\nSQLException: " + eSQL); 
    }
    //this code is executed under all circumstances  
    finally {
      if (rs != null)
        rs.close ();
      if (stmt != null)
        //if implicit caching is enabled the statement is not actually closed
        //but is sent to the cache
        stmt.close ();
      return region;
    }
  }
}




