CREATE TABLE  "CUSTOMER" 
   (	"CUSTOMER_ID" NUMBER, 
	"CUSTOMER_NAME" VARCHAR2(2000), 
	"CUSTOMER_ADDRESS" VARCHAR2(2000), 
	 CONSTRAINT "CUSTOMER_PK2" PRIMARY KEY ("CUSTOMER_ID") ENABLE
   );

CREATE TABLE  "PRODUCT" 
   (	"PRODUCT_ID" NUMBER, 
	"PRODUCT_NAME" VARCHAR2(2000), 
	"PRICE" NUMBER, 
	 CONSTRAINT "PRODUCT_PK2" PRIMARY KEY ("PRODUCT_ID") ENABLE
   );

CREATE SEQUENCE   "PRODUCT_SEQ2"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20 NOORDER  NOCYCLE; 

CREATE SEQUENCE   "CUSTOMER_SEQ2"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20 NOORDER  NOCYCLE;

CREATE OR REPLACE TRIGGER  "BI_PRODUCT2" 
  before insert on "PRODUCT"               
  for each row  
begin   
  if :NEW."PRODUCT_ID" is null then 
    select "PRODUCT_SEQ".nextval into :NEW."PRODUCT_ID" from dual; 
  end if; 
end; 

/
ALTER TRIGGER  "BI_PRODUCT2" ENABLE;

CREATE OR REPLACE TRIGGER  "BI_CUSTOMER2" 
  before insert on "CUSTOMER"               
  for each row  
begin   
  if :NEW."CUSTOMER_ID" is null then 
    select "CUSTOMER_SEQ".nextval into :NEW."CUSTOMER_ID" from dual; 
  end if; 
end; 

/
ALTER TRIGGER  "BI_CUSTOMER2" ENABLE;

